/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DB2iSeriesDriver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.LocaleMessage;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DB2Driver
extends SQLDriver {
    private static Logger log = new Logger(DB2Driver.class.getName());

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new DB2iSeriesDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new DB2iSeriesDriver(dbName);
    }

    public DB2Driver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public DB2Driver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public String getLastSequenceQuery() {
        return "VALUES(IDENTITY_VAL_LOCAL())";
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("DB2 can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            String obj = DB2Driver.getScalarResult(this.getLastSequenceQuery(), this.dbConnection, this.dbName, this, req).toString();
            Long sequenceValue = new Long(obj.toString());
            primaryKeys.put(sequenceName, sequenceValue);
        }
        return primaryKeys;
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\'g", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String escapeClause() {
        return " {ESCAPE '\\'}";
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue;
            if (valueMap.get(actualValue) instanceof LocaleMessage) {
                Locale locale = request != null ? request.context.getLocale() : Locale.getDefault();
                displayValue = ((LocaleMessage)valueMap.get(actualValue)).getMessage(locale);
            } else {
                displayValue = valueMap.get(actualValue) == null ? null : valueMap.get(actualValue).toString();
            }
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    public String getDummyQuery() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    public boolean shouldParameterizeNullValues() {
        return false;
    }
}

