/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authenticator;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.sql.SQLDriver;
import java.security.Principal;
import java.util.List;
import java.util.Map;

public class SQLAuthenticator
extends Authenticator {
    public String database = config.getString((Object)"sql.defaultDatabase");
    public String table = "users";
    public String usernameColumn = "uid";
    public String passwordColumn = "password";
    String passwordType = "cleartext";
    private static Logger log = new Logger(SQLAuthenticator.class.getName());

    public SQLAuthenticator() {
    }

    public SQLAuthenticator(String database, String table, String usernameColumn, String passwordColumn) {
        this.database = database;
        this.table = table;
        this.usernameColumn = usernameColumn;
        this.passwordColumn = passwordColumn;
    }

    public Principal authenticate(RequestContext context) throws Exception {
        String username = this.getSubmittedUsername(context);
        String password = this.getSubmittedPassword(context);
        if (username == null) {
            log.debug((Object)"attempt to authenticate with a null username");
            return null;
        }
        if (password == null) {
            log.debug((Object)("attempt to authenticate with a null password with username: " + username));
            return null;
        }
        if (this.passwordType.equals("cleartext")) {
            SQLDriver driver = SQLDriver.instance(this.database);
            String query = "SELECT * FROM " + this.table + " WHERE " + driver.escapeColumnName(this.usernameColumn) + "=" + driver.escapeValue(username);
            List rows = SQLDriver.getTransformedResults(query, this.database, null);
            if (rows == null || rows.size() == 0) {
                log.debug((Object)("no user record for username: " + username));
                return null;
            }
            if (rows.size() > 1) {
                throw new Exception("query for username: " + username + " returned multiple rows - username" + " column is supposed to be unique!");
            }
            Map userRow = (Map)rows.get(0);
            String dbPassword = (String)userRow.get(this.passwordColumn);
            if (dbPassword == null) {
                return null;
            }
            if (dbPassword.equals(password)) {
                log.debug((Object)("db auth succeded for username: " + username));
                return new AuthenticatedUser(username, userRow);
            }
        } else {
            throw new Exception("passwordType '" + this.passwordType + "' is not supported");
        }
        log.info((Object)("password incorrect for username: " + username));
        return null;
    }

    public Principal getUser(RequestContext context) throws Exception {
        return (Principal)this.getContextValue(context, "user");
    }
}

