/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.openqa.selenium.By;

class Operation {
    private String operator;
    private Object operand1;
    private Object operand2;

    public Operation(String operator, String operand1, String operand2) {
        this.operator = operator;
        this.operand1 = this.parse(operand1);
        this.operand2 = this.parse(operand2);
    }

    private Object parse(String operand) {
        if (operand == null) {
            return null;
        }
        if (operand.startsWith("\\")) {
            operand = operand.substring(1);
        }
        if ("true".equalsIgnoreCase(operand)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(operand)) {
            return Boolean.FALSE;
        }
        if (operand.startsWith("//")) {
            return ByScLocator.scLocator(operand);
        }
        if (operand.toLowerCase().startsWith("id=")) {
            return By.ById.id((String)operand.substring(3));
        }
        if (operand.toLowerCase().startsWith("name=")) {
            return By.ByName.name((String)operand.substring(5));
        }
        if (this.isLong(operand)) {
            return Long.parseLong(operand);
        }
        return operand;
    }

    private boolean isLong(String operand) {
        try {
            Long.parseLong(operand);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public boolean isVerify() {
        return this.operator.startsWith("verify");
    }

    public Object execute(SmartClientWebDriver driver) throws Exception {
        boolean andWait = false;
        String webDriverOperator = this.convertSeleneseToWebDriver(this.operator);
        if (webDriverOperator.endsWith("AndWait")) {
            andWait = true;
            webDriverOperator = webDriverOperator.substring(0, webDriverOperator.indexOf("AndWait"));
        }
        LinkedList<Object> args = new LinkedList<Object>();
        LinkedList types = new LinkedList();
        if (this.operand1 != null) {
            args.add(this.operand1);
            types.add(this.operand1.getClass());
            if (this.operand2 != null) {
                args.add(this.operand2);
                types.add(this.operand2.getClass());
            }
        }
        for (Method method : driver.getClass().getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals(webDriverOperator) || (params = method.getParameterTypes()).length != types.size()) continue;
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (params[i].isAssignableFrom((Class)types.get(i))) continue;
                match = false;
            }
            if (!match) continue;
            try {
                Object i = method.invoke((Object)driver, args.toArray());
                return i;
            }
            catch (Exception e) {
                System.err.println("Problem executing: " + this);
                throw e;
            }
            finally {
                if (andWait) {
                    System.err.println("Webdriver implictly waits and doesn't 100% support: " + this.operator);
                    Thread.sleep(3000L);
                }
            }
        }
        throw new NoSuchMethodException("No match for: " + this);
    }

    private String convertSeleneseToWebDriver(String operator) {
        if ("open".equals(operator)) {
            return "get";
        }
        if ("dragAndDropToObject".equals(operator)) {
            return "dragAndDrop";
        }
        return operator;
    }

    public String toJavaString() {
        String result = "driver." + this.operator + "(";
        if (this.operand1 != null) {
            result = result + this.toJavaString(this.operand1);
        }
        if (this.operand2 != null) {
            result = result + ", " + this.toJavaString(this.operand2);
        }
        return result + ");";
    }

    private String toJavaString(Object operand) {
        if (operand instanceof ByScLocator) {
            return ((ByScLocator)((Object)operand)).toJavaString();
        }
        if (operand instanceof String) {
            return "\"" + operand.toString() + "\"";
        }
        return operand.toString();
    }

    public String toString() {
        String result = this.operator + "(";
        if (this.operand1 != null) {
            result = result + this.operand1 + "/" + this.operand1.getClass().getSimpleName();
        }
        if (this.operand2 != null) {
            result = result + ", " + this.operand2 + "/" + this.operand2.getClass().getSimpleName();
        }
        return result + ")";
    }
}

