/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.compression;

import com.isomorphic.base.Base;
import com.isomorphic.interfaces.ICompression;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class CompressFile
extends Base {
    private static Logger log = new Logger(CompressFile.class.getName());

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        String cmdLineSyntax = "CompressFile [options] fileList";
        Options options = new Options();
        options.addOption("h", "help", false, "Show usage message and exit");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("h")) {
            CompressFile.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        ICompression compression = (ICompression)InterfaceProvider.load((String)"ICompression");
        String[] fileList = line.getArgs();
        for (int i = 0; i < fileList.length; ++i) {
            String fileName = fileList[i];
            String outFileName = fileName + ".gz";
            boolean addPadding = fileName.endsWith(".js");
            ISCFile inFile = new ISCFile(fileName);
            ByteArrayOutputStream compressedBuf = compression.compressStream(inFile.getInputStream(), addPadding);
            File outFile = new File(outFileName);
            if (outFile.exists()) {
                outFile.delete();
            }
            FileOutputStream outStream = new FileOutputStream(outFile);
            IOUtil.copyStreams((InputStream)new ByteArrayInputStream(compressedBuf.toByteArray()), (OutputStream)outStream);
            outStream.flush();
            ((OutputStream)outStream).close();
            log.info((Object)("Compressed: " + fileName + " to: " + outFileName));
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "");
    }
}

