/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.compression;

import com.isomorphic.base.Config;
import com.isomorphic.compression.Compression;
import com.isomorphic.interfaces.IInstanceSingleton;
import com.isomorphic.interfaces.IServletCompression;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public class ServletCompression
implements IServletCompression,
IInstanceSingleton {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Compression.class.getName());
    public ByteArrayOutputStream wrapBuf = null;
    public OutputStream servletOutputStream = null;
    public boolean compressing = false;

    public boolean canCompress(RequestContext context) {
        return ServletTools.compressionEnabled() && ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request) && !ServletTools.contextIsIncluded((RequestContext)context);
    }

    public boolean compressIfPossible(RequestContext context) throws Exception {
        if (!this.canCompress(context)) {
            return false;
        }
        try {
            this.servletOutputStream = context.response.getOutputStream();
        }
        catch (Exception e) {
            String logPrefix = context.requestPath + ": ";
            log.error((Object)(logPrefix + "Can't compress response because the servlet output" + " stream is already in use: " + e.toString()));
            return false;
        }
        this.wrapBuf = new ByteArrayOutputStream();
        context.setOut((Writer)new PrintWriter(this.wrapBuf));
        this.compressing = true;
        return true;
    }

    public void completeResponse(RequestContext context) throws Exception {
        if (!this.compressing) {
            return;
        }
        try {
            context.out().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.out().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.compressAndSend(context, this.wrapBuf);
    }

    public void compressAndSend(RequestContext context, ByteArrayOutputStream wrapBuf) throws Exception {
        this.compressAndSend(context, wrapBuf, -1);
    }

    public void compressAndSend(RequestContext context, ByteArrayOutputStream wrapBuf, int compressThreshold) throws Exception {
        int wrapBufSize;
        String logPrefix = context.requestPath + ": ";
        if (this.servletOutputStream == null) {
            this.servletOutputStream = context.response.getOutputStream();
        }
        if (compressThreshold == -1) {
            compressThreshold = config.getInt((Object)"compression.compressThreshold", -1);
        }
        if (compressThreshold == -1) {
            compressThreshold = config.getInt((Object)"compressionFilter.compressThreshold", 250);
        }
        if ((wrapBufSize = wrapBuf.size()) == 0 || wrapBufSize < compressThreshold) {
            context.response.setContentLength(wrapBufSize);
            if (wrapBufSize == 0) {
                log.debug((Object)(logPrefix + "Result is zero length - not compressing"));
            } else {
                log.debug((Object)(logPrefix + "Result data size of " + wrapBufSize + " bytes is less than set threshold of " + compressThreshold + " bytes - not compressing"));
                wrapBuf.writeTo(this.servletOutputStream);
            }
            try {
                this.servletOutputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context.response.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        ByteArrayOutputStream compressedBuf = new Compression().compressBuffer(wrapBuf, context.contentType);
        log.info((Object)(logPrefix + wrapBufSize + " -> " + compressedBuf.size() + " bytes"));
        context.response.setHeader("Content-Encoding", "gzip");
        if (!ServletTools.compressionReadyCookieIsSet((RequestContext)context)) {
            ServletTools.setCompressionReadyCookie((RequestContext)context);
        }
        context.response.setContentLength(compressedBuf.size());
        compressedBuf.writeTo(this.servletOutputStream);
        try {
            this.servletOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.response.flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object staticInstance() throws Exception {
        return new ServletCompression();
    }
}

