/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.customDataSource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDataSource
extends BasicDataSource {
    private static List data = new ArrayList();
    private static int nextId;

    public DSResponse executeAdd(DSRequest req) throws Exception {
        Map createdRecord = this.createRecord(req.getValues());
        return new DSResponse((Object)createdRecord);
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        List records = this.fetchRecords(req.getCriteria());
        return new DSResponse((Object)records);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        Map removedRecord = this.removeRecord(req.getValues().get(this.getPrimaryKey()));
        return new DSResponse((Object)removedRecord);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        Map updatedRecord = this.updateRecord(req.getValues());
        return new DSResponse((Object)updatedRecord);
    }

    private Map createRecord(Map values) {
        values.put(this.getPrimaryKey(), new Integer(nextId++));
        data.add(values);
        return values;
    }

    private List fetchRecords(Map criteria) {
        return data;
    }

    private Map removeRecord(Object id) {
        Number idNum = (Number)id;
        Map map = this.findById(idNum);
        boolean removed = false;
        if (map != null) {
            removed = data.remove(map);
        }
        if (removed) {
            return map;
        }
        return null;
    }

    private Map updateRecord(Map values) {
        Number idNum = (Number)values.get(this.getPrimaryKey());
        Map map = this.findById(idNum);
        if (map != null) {
            DataTools.mapMerge((Map)values, (Map)map);
            return map;
        }
        return null;
    }

    private Map findById(Number id) {
        if (id != null) {
            Integer integerId = id.intValue();
            for (int i = 0; i < data.size(); ++i) {
                Map record = (Map)data.get(i);
                if (!integerId.equals(record.get(this.getPrimaryKey()))) continue;
                return record;
            }
        }
        return null;
    }

    static {
        String[] userName = new String[]{"Charles Madigen", "Ralph Brogan", "Grigori Ognev", "Tamara Kane", "Betsy Rosenbaum", "Gene Porter", "Prya Sambhus", "Ren Xian"};
        String[] jobTitle = new String[]{"Chief Operating Officer", "Manager Systems", "Technician", "Manager Site Services", "Secretary", "Manager Purchasing", "Line Worker", "Mobile Equipment Operator"};
        String[] email = new String[]{"charles.madigen", "ralph.brogan", "grigori.ognev", "tamara.kane", "elizabeth.rosenbaum", "gene.porter", "prya.sambhus", "ren.xian"};
        String[] type = new String[]{"full time", "contract", "part time", "full time", "part time", "contract", "part time", "full time"};
        float[] salary = new float[]{20395.0f, 18076.0f, 12202.0f, 21227.0f, 11632.0f, 17702.0f, 12985.0f, 16402.0f};
        for (int i = 0; i < userName.length; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("employeeId", new Integer(i + 1));
            map.put("userName", userName[i]);
            map.put("job", jobTitle[i]);
            map.put("email", email[i] + "@server.com");
            map.put("employeeType", type[i]);
            map.put("salary", new Float(salary[i]));
            data.add(map);
        }
        nextId = data.size() + 1;
    }
}

