/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.customDownload;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.rpc.RPCManager;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class CustomDownload {
    public void downloadData(DSRequest dsRequest, RPCManager rpc) {
        DSResponse dsResponse = new DSResponse();
        try {
            rpc.doCustomResponse();
            HttpServletResponse response = rpc.getContext().response;
            response.setHeader("content-disposition", "attachment; filename=downloadDescriptions.txt");
            response.setContentType("text/plain");
            dsResponse = dsRequest.execute();
            List list = dsResponse.getDataList();
            String result = "";
            for (Map record : list) {
                String itemName = record.get("itemName") == null ? "" : record.get("itemName").toString();
                String description = record.get("description") == null ? "" : record.get("description").toString();
                result = result + itemName + " : " + description + "\r\n\r\n";
            }
            ServletOutputStream out = response.getOutputStream();
            out.write(result.getBytes());
            dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
            rpc.send(dsRequest, dsResponse);
        }
        catch (Exception e) {
            try {
                rpc.sendFailure((Object)dsRequest, e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

