/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.editableServerSideDataSource;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.xml.XML;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class GeneratorSetup {
    private static Logger log = new Logger(GeneratorSetup.class.getName());

    public void setupGenerator() {
        DataSource.addDynamicDSGenerator((DynamicDSGenerator)new DynamicDSGenerator(){

            public DataSource getDataSource(String id, DSRequest dsRequest) {
                if ("dynamicDS".equals(id)) {
                    try {
                        StringWriter sw = new StringWriter();
                        sw.write("<DataSource ID=\"dynamicDS\" titleField=\"name\">\n");
                        sw.write("<fields>\n");
                        DSRequest fieldFetchRequest = new DSRequest("dynamicDSFields", "fetch");
                        DSResponse dsResp = fieldFetchRequest.execute();
                        List data = dsResp.getDataList();
                        for (Object dateRow : data) {
                            Map record = (Map)dateRow;
                            XML.recordToXML((String)"field", (Map)record, (Writer)sw);
                            sw.write("\n");
                        }
                        sw.write("</fields>\n");
                        sw.write("</DataSource>");
                        return DataSource.fromXML((String)sw.toString());
                    }
                    catch (Exception e) {
                        log.error((Object)"Problems when creating dynamic server side datasource.", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }
}

