/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSExec
extends Base {
    public static Logger log = new Logger(JSExec.class.getName());

    public static void main(String[] args) {
        try {
            String filename = args[0];
            String configFile = config.getPath("js.configFile");
            Context cx = Context.enter();
            Scriptable scope = cx.initStandardObjects((ScriptableObject)new ImporterTopLevel(cx));
            try {
                JSExec.execFile(configFile, scope);
            }
            catch (Exception jse) {
                log.warning((Object)("Problem executing jsConfig: " + configFile), (Throwable)jse);
            }
            JSExec.execFile(filename, scope);
            cx.exit();
            System.exit(0);
        }
        catch (Exception any) {
            any.printStackTrace();
        }
    }

    public static Object execFile(String filename) throws Exception {
        return JSExec.execFile(filename, null);
    }

    public static Object execFile(String filename, Scriptable scope) throws Exception {
        Context cx = Context.getCurrentContext();
        Reader reader = new ISCFile(filename).getReader();
        Object result = cx.getUndefinedValue();
        if (scope == null) {
            scope = cx.initStandardObjects((ScriptableObject)new ImporterTopLevel(cx));
        }
        result = cx.evaluateReader(scope, reader, filename, 1, null);
        return result;
    }
}

