/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSExpression;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.w3c.dom.Element;

public class DefineClass
extends BasicDataSource {
    private static Logger log = new Logger(DefineClass.class.getName());

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (!(data instanceof Element)) {
            return data;
        }
        if (!((data = super.toRecord(data, context)) instanceof Map)) {
            return data;
        }
        Map record = (Map)data;
        StringWriter out = new StringWriter();
        JSTranslater jsTrans = JSTranslater.get();
        Object properties = (Map)record.get("properties");
        Map methods = (Map)record.get("methods");
        String superclass = (String)record.get("extends");
        ((Writer)out).write("isc.defineClass(\"" + record.get("name") + (superclass != null ? "\",\"" + superclass : "") + "\")");
        if (properties != null) {
            if (superclass != null) {
                DataSource ds = DataSourceManager.getDataSource(superclass, context.getDSRequest());
                if (ds != null) {
                    properties = ds.toRecord(properties, context);
                    ((Map)properties).remove("__autoConstruct");
                    DataSourceManager.freeDataSource(ds);
                } else {
                    log.info("datasource for " + superclass + " not found; special processing " + "for properties not performed");
                }
            }
            ((Writer)out).write(".addProperties(" + jsTrans.toJS(properties) + ")");
        }
        if (methods != null) {
            LinkedMap newMethods = new LinkedMap();
            for (Object key : methods.keySet()) {
                Object value = methods.get(key);
                if (value instanceof String && ((String)value).startsWith("function ")) {
                    value = new JSExpression((String)value);
                }
                newMethods.put(key, value);
            }
            ((Writer)out).write(".addMethods(" + jsTrans.toJS(newMethods) + ")");
        }
        ((Writer)out).write("\n");
        return new JSExpression(((Object)out).toString());
    }
}

