/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.ValueMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class IntegerListType
extends BasicDataSource {
    private static Logger log = new Logger(ValueMap.class.getName());

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            return this.toRecords((List)data, context);
        }
        if (data instanceof Element) {
            Element element = (Element)data;
            List children = XML.getElementChildren(element);
            List l = DataTools.makeListIfSingle(IntegerListType.recordsFromXML(children, context));
            ArrayList result = new ArrayList();
            for (Object item : l) {
                if (item instanceof List) {
                    result.add(item);
                    continue;
                }
                if (item instanceof Long) {
                    result.add(item);
                    continue;
                }
                if (item instanceof Integer) {
                    result.add(new Long(((Integer)item).longValue()));
                    continue;
                }
                if (item instanceof String) {
                    try {
                        Long value = Long.parseLong((String)item);
                        result.add(value);
                    }
                    catch (NumberFormatException ex) {
                        log.warn("Cannot convert " + item + "with type " + item.getClass().getName() + " to " + "Long. Adding it to result as it is.");
                        result.add(item);
                    }
                    continue;
                }
                log.warn("Unknown type of element " + item.getClass().getName() + " in IntegerListType. " + "Adding it to result as it is.");
                result.add(item);
            }
            return result;
        }
        return DataTools.makeListIfSingle(data);
    }
}

