/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
extends URIRegexFilter {
    public Map expires;
    public boolean noExpires = false;
    public Map cache = null;
    public boolean noCache = false;
    public Map charsets;
    public int stripPathComponents = -1;
    public String stripIfStartsWith = null;

    public void setExpires(String value) {
        this.expires = new HashMap();
        if (value == null) {
            return;
        }
        if ("NONE".equals(value.toUpperCase())) {
            this.noExpires = true;
            return;
        }
        List list = DataTools.commaSeparatedStringToList(value);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mapping = i.next().toString();
            if (mapping.equals("")) continue;
            List split = DataTools.simpleSplit(mapping, ":");
            if (split.size() != 2) {
                this.log.error("Malformed expiry mapping: " + mapping + " - ignored");
                continue;
            }
            String mimeType = split.get(0).toString().toLowerCase();
            Long expiry = null;
            try {
                expiry = Long.valueOf((String)split.get(1));
            }
            catch (Exception e) {
                this.log.error((Object)("Malformed expiry mapping: " + mapping + " - ignored"), e);
                continue;
            }
            this.expires.put(mimeType, expiry);
            this.log.debug("Registered expires mapping - " + mimeType + ": " + expiry + " seconds");
        }
        if (this.expires.size() == 0) {
            this.expires = null;
        }
    }

    public void setCache(String value) {
        if ("NONE".equals(value.toUpperCase())) {
            this.noCache = true;
            return;
        }
    }

    public void setCharsets(String value) {
        this.charsets = new HashMap();
        List list = DataTools.commaSeparatedStringToList(value);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mapping = i.next().toString();
            if (mapping.equals("")) continue;
            List split = DataTools.simpleSplit(mapping, ":");
            if (split.size() != 2) {
                this.log.error("Malformed charset mapping: " + mapping + " - ignored");
                continue;
            }
            String mimeType = split.get(0).toString().toLowerCase();
            String charset = (String)split.get(1);
            this.charsets.put(mimeType, charset);
            this.log.debug("Registerd charset mapping - " + mimeType + ": " + charset);
        }
    }

    public void setStripPathComponents(String value) {
        if (value != null) {
            try {
                this.stripPathComponents = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.log.error("Non-integer value provided for stripPathComponents property");
            }
            this.log.debug("stripPathComponents set to " + this.stripPathComponents);
        }
    }

    public void setStripIfStartsWith(String value) {
        this.stripIfStartsWith = value;
        this.log.debug("stripIfStartsWith set to " + this.stripIfStartsWith);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            block7: {
                try {
                    RequestContext context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
                    String requestPath = ServletTools.getCurrentRequestURI(request);
                    if (this.stripPathComponents > 0 && (this.stripIfStartsWith == null || requestPath.startsWith(this.stripIfStartsWith))) {
                        requestPath = ServletTools.stripPathComponents(requestPath, this.stripPathComponents);
                    }
                    String filePath = config.get("webRoot") + requestPath;
                    ISCFile file = new ISCFile(filePath);
                    if (this.noCache) {
                        context.setNoCacheHeaders();
                    }
                    if (!file.exists()) {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        break block7;
                    }
                    ServletTools.sendStaticFile(context, filePath, null, this.expires, this.charsets, this.noExpires);
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    requestTimer.stop();
                }
            }
            Object var12_12 = null;
            requestTimer.stop();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            requestTimer.stop();
            throw throwable;
        }
    }
}

