/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IExecutable;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ThreadTimer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class ISCSystem
extends Base {
    public static final int NO_TIMEOUT = 0;
    private static final int POLL_DELAY = 50;
    private static Logger log = new Logger(ISCSystem.class.getName());
    String stdout;
    String stderr;
    Process p;
    int exitValue = 256;
    String command;
    int timeout;
    private PrintStream processStdin;

    public static ISCSystem execute(IExecutable theClass) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), 0);
    }

    public static ISCSystem execute(IExecutable theClass, int timeout) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), timeout);
    }

    public static ISCSystem execute(String command) throws Exception {
        return ISCSystem.execute(command, 0);
    }

    public static ISCSystem execute(String command, int timeout) throws Exception {
        return new ISCSystem().run(command, timeout);
    }

    public static ISCSystem execute(String[] command) throws Exception {
        return ISCSystem.execute(command, 0);
    }

    public static ISCSystem execute(String[] command, int timeout) throws Exception {
        return new ISCSystem().run(command, timeout);
    }

    public ISCSystem run(String command, int timeout) throws Exception {
        return this.run(new String[]{"sh", "-c", command}, timeout);
    }

    public ISCSystem run(String[] command, int timeout) throws Exception {
        this.timeout = timeout;
        log.debug("executing command (" + (timeout == 0 ? "no" : timeout + "ms") + " timeout): " + command);
        String[] envp = null;
        if (config.getBoolean((Object)"devenv", false)) {
            ArrayList<String> envList = new ArrayList<String>();
            String classpath = null;
            String devenvClasspath = null;
            HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
            for (String envVar : envMap.keySet()) {
                String envValue = (String)envMap.get(envVar);
                if (envVar.equals("DEVENV_CLASSPATH")) {
                    devenvClasspath = envValue;
                    continue;
                }
                if (envVar.equals("CLASSPATH")) {
                    classpath = envValue;
                    continue;
                }
                envList.add(envVar + "=" + envValue);
            }
            if (devenvClasspath != null) {
                envList.add("CLASSPATH=" + devenvClasspath);
            } else if (classpath != null) {
                envList.add("CLASSPATH=" + classpath);
            }
            if (envp == null) {
                envp = DataTools.listToStringArray(envList);
            } else {
                DataTools.listToStringArray(DataTools.addAll(DataTools.arrayToList(envp), envList));
            }
        }
        this.p = Runtime.getRuntime().exec(command, envp);
        return this;
    }

    public ISCSystem waitFor() throws Exception {
        InputStream is = this.p.getInputStream();
        InputStream es = this.p.getErrorStream();
        ThreadTimer tt = null;
        try {
            try {
                if (this.timeout != 0) {
                    tt = new ThreadTimer(Thread.currentThread(), this.timeout);
                    tt.start();
                }
                ProcessStreamReader stdoutThread = new ProcessStreamReader(this.p.getInputStream());
                ProcessStreamReader stderrThread = new ProcessStreamReader(this.p.getErrorStream());
                stdoutThread.start();
                stderrThread.start();
                stdoutThread.join();
                stderrThread.join();
                this.stdout = stdoutThread.getString();
                this.stderr = stderrThread.getString();
                this.exitValue = this.p.waitFor();
            }
            catch (InterruptedException e) {
                this.p.destroy();
                throw new Exception("execution of: " + this.command + " timed out after " + this.timeout + "ms and was killed.");
            }
            Object var7_7 = null;
            if (tt != null) {
                tt.cancelInterrupt();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (tt != null) {
                tt.cancelInterrupt();
            }
            throw throwable;
        }
        return this;
    }

    public int exitValue() {
        return this.exitValue;
    }

    public Process getProcess() {
        return this.p;
    }

    public PrintStream getProcessStdin() {
        if (this.processStdin == null) {
            this.processStdin = new PrintStream(this.p.getOutputStream(), true);
        }
        return this.processStdin;
    }

    public String getStdout() throws Exception {
        return this.stdout;
    }

    public String getStderr() throws Exception {
        return this.stderr;
    }

    private static class ProcessStreamReader
    extends Thread {
        StringWriter sw = new StringWriter();
        InputStream is;

        public ProcessStreamReader(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                IOUtil.copyCharacterStreams(new InputStreamReader(this.is), this.sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getString() {
            return this.sw.toString();
        }
    }
}

