/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.CanParseCriterion;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.SimpleCriteria;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.log.Logger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public class Evaluator {
    public static Logger log = new Logger(Evaluator.class.getName());
    private Map<String, Operator> customOperators;

    public void addSearchOperator(Operator op) {
        if (this.customOperators == null) {
            this.customOperators = new HashMap<String, Operator>();
        }
        if (this.customOperators.containsValue(op)) {
            log.warn("Attempted to add existing operator " + op.getID() + " - replacing");
        } else if (this.customOperators.containsKey(op.getID())) {
            log.warn("Two different operators have the same ID " + op.getID() + " - replacing.");
        }
        this.customOperators.put(op.getID(), op);
    }

    Operator getSearchOperator(String id) {
        Operator object = DefaultOperators.getDefaultOperatorMap().get(id);
        if (object == null && this.customOperators != null) {
            object = this.customOperators.get(id);
        }
        return object;
    }

    public boolean valuesMatchCriteria(Map values, SimpleCriteria sc, String textMatchStyle) throws Exception {
        return sc.valuesMatchCriteria(values, textMatchStyle);
    }

    public boolean valuesMatchCriteria(Map values, AdvancedCriteria ac) throws Exception {
        return this.evaluateCriterion(values, ac.criteria);
    }

    public boolean evaluateCriterion(Map values, Criterion criterion) throws Exception {
        if (criterion == null) {
            throw new Exception("Null criterion found (Invalid operator ID probably used)");
        }
        Operator operator = this.getSearchOperator(criterion.getOperatorId());
        if (operator == null) {
            throw new Exception("No operator for id=" + criterion.getOperatorId());
        }
        try {
            return operator.condition(values, criterion, this);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AdvancedCriteria parseAdvancedCriteria(Map rawCriteria) {
        return new AdvancedCriteria(Evaluator.parseCriterion(rawCriteria));
    }

    public static Criterion parseCriterion(Map rawCriteria) {
        Object objOperator;
        if (!rawCriteria.containsKey("operator") && rawCriteria.containsKey("fieldName") && rawCriteria.containsKey("value")) {
            rawCriteria.put("operator", "equals");
        }
        String operatorId = (objOperator = rawCriteria.get("operator")) == null ? null : String.valueOf(objOperator);
        Map<String, Operator> operators = DefaultOperators.getDefaultOperatorMap();
        Operator operator = operators.get(operatorId);
        if (operator != null && operator instanceof CanParseCriterion) {
            return ((CanParseCriterion)((Object)operator)).parseCriterion(rawCriteria);
        }
        return new CustomCriterion(operatorId, rawCriteria);
    }

    public static Object getPathValue(Map values, String fieldPath) {
        if (!fieldPath.contains(".")) {
            return values.get(fieldPath);
        }
        String[] path = fieldPath.split("\\.");
        Map object = values;
        for (String pathPart : path) {
            object = object.get(pathPart);
        }
        return object;
    }

    public static String getPathValueAsString(Map values, String fieldPath) {
        return ObjectUtils.toString((Object)Evaluator.getPathValue(values, fieldPath));
    }
}

