/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Evaluator;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleCriteria
extends HashMap {
    public static final String TEXT_MATCH_STYLE_STARTS_WITH = "startsWith";
    public static final String TEXT_MATCH_STYLE_SUBSTRING = "substring";
    private static final long serialVersionUID = 805040010287624875L;
    private static Logger log = new Logger();

    public SimpleCriteria(Map map) {
        super(map);
    }

    public boolean valuesMatchCriteria(Map values, String textMatchStyle) {
        for (String key : this.keySet()) {
            Object value = this.get(key);
            if (this.compareValues(Evaluator.getPathValue(values, key), value, textMatchStyle)) continue;
            return false;
        }
        return true;
    }

    private boolean compareValues(Object dataValue, Object filterValue, String textMatchStyle) {
        ArrayList<Object> work = null;
        if (filterValue instanceof List) {
            work = (ArrayList<Object>)filterValue;
        } else {
            work = new ArrayList<Object>();
            work.add(filterValue);
        }
        Iterator i = work.iterator();
        while (i.hasNext()) {
            if (this.compareSingleValue(dataValue, i.next(), textMatchStyle)) continue;
            return false;
        }
        return true;
    }

    private boolean compareSingleValue(Object dataValue, Object filterValue, String textMatchStyle) {
        if (dataValue == null) {
            return filterValue == null;
        }
        if (filterValue == null) {
            filterValue = "";
        }
        if (dataValue instanceof Double) {
            return ((Double)dataValue).equals(Double.valueOf(filterValue.toString()));
        }
        if (dataValue instanceof Float) {
            return ((Float)dataValue).equals(Float.valueOf(filterValue.toString()));
        }
        if (dataValue instanceof Long) {
            return ((Long)dataValue).equals(Long.valueOf(filterValue.toString()));
        }
        if (dataValue instanceof Integer) {
            return ((Integer)dataValue).equals(Integer.valueOf(filterValue.toString()));
        }
        if (dataValue instanceof Date) {
            if (!(filterValue instanceof Date)) {
                log.warn("Found data value of type Date for filter value of type " + filterValue.getClass().getName());
                return false;
            }
            return dataValue.equals(filterValue);
        }
        if (TEXT_MATCH_STYLE_SUBSTRING.equals(textMatchStyle)) {
            return dataValue.toString().toLowerCase().indexOf(filterValue.toString().toLowerCase()) != -1;
        }
        if (TEXT_MATCH_STYLE_STARTS_WITH.equals(textMatchStyle)) {
            return dataValue.toString().toLowerCase().indexOf(filterValue.toString().toLowerCase()) == 0;
        }
        return dataValue.toString().toLowerCase().equals(filterValue.toString().toLowerCase());
    }
}

