/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.base.Config;
import com.isomorphic.log.ANSIColorizedPatternLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.varia.NullAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.LoggerFactory;

public class Logger {
    private static boolean initialized = false;
    public static Logger auth;
    public static Logger timing;
    public static Logger validation;
    public static Logger fileSandbox;
    public static Logger resultData;
    public static Logger download;
    public static Logger global;
    public static Level ALL;
    public static Level DEBUG;
    public static Level ERROR;
    public static Level FATAL;
    public static Level INFO;
    public static Level OFF;
    public static Level WARN;
    private static Hierarchy hierarchy;
    protected static boolean logEnabled;
    private static boolean prefixWithPackage;
    private static boolean useExistingLogOnly;
    private static Map threadContext;
    private static LoggerRepository repository;
    private static boolean useSlf4j;
    private static boolean useLog4jConfig;
    public static Set ignoreThreads;
    private static final String DEFAULT_SUBSYSTEM = "Undefined Subsystem";
    private org.apache.log4j.Logger nativeLog;
    private org.slf4j.Logger slf4jLogger;
    private String packageName;
    private String packagePrefix;
    private String messagePrefix;
    public Level level;
    private static Map<String, Level> savedThresholds;

    @Deprecated
    public static Hierarchy getHierarchy() {
        return hierarchy;
    }

    public static LoggerRepository getLoggerRepository() {
        return repository;
    }

    public static boolean useLog4j() {
        return repository != null;
    }

    public static Throwable getRealTargetException(Throwable ite) {
        if (ite instanceof InvocationTargetException) {
            return Logger.getRealTargetException(((InvocationTargetException)ite).getTargetException());
        }
        return ite;
    }

    public static void initialize() {
        Config config = Config.getGlobal();
        ANSIColorizedPatternLayout.initialize();
        Logger log = new Logger(Logger.class.getName());
        log.info("Logging system started.");
        auth = new Logger("com.isomorphic.auth.Auth");
        timing = new Logger("com.isomorphic.timing.Timing");
        validation = new Logger("com.isomorphic.validation.Validation");
        fileSandbox = new Logger("com.isomorphic.fileSandbox.FileSandbox");
        resultData = new Logger("com.isomorphic.resultData.ResultData");
        download = new Logger("com.isomorphic.download.Download");
        global = new Logger("GLOBAL");
    }

    public static void ignoreThread() {
        if (ignoreThreads == null) {
            ignoreThreads = new HashSet();
        }
        if (!Logger.threadIgnored()) {
            ignoreThreads.add(Thread.currentThread());
        }
    }

    public static void observeThread() {
        if (ignoreThreads != null) {
            ignoreThreads.remove(Thread.currentThread());
        }
    }

    public static boolean threadIgnored() {
        return ignoreThreads != null && ignoreThreads.contains(Thread.currentThread());
    }

    private static String prependContext(Object message) {
        Stack s = Logger.getStackForCurrentThread();
        if (s.empty()) {
            return message.toString();
        }
        return s.toString() + " " + message.toString();
    }

    private String prefixMessage(Object message) {
        if (message != null) {
            message = Logger.prependContext(message);
            if (prefixWithPackage) {
                message = this.packagePrefix + message.toString();
            }
            if (this.messagePrefix != null) {
                message = this.messagePrefix + message.toString();
            }
        } else {
            message = "null";
        }
        return message.toString();
    }

    public Logger(Class objClass) {
        this(objClass.getName());
    }

    public Logger(Object obj) {
        this(obj.getClass().getName());
    }

    public Logger(String subsystem) {
        this(subsystem, null);
    }

    public Logger(String subsystem, String messagePrefix) {
        int start = 0;
        int end = 0;
        if (subsystem == null) {
            subsystem = DEFAULT_SUBSYSTEM;
        }
        if (subsystem.indexOf(".") != -1) {
            end = subsystem.lastIndexOf(".");
            start = subsystem.lastIndexOf(".", end - 1);
        }
        this.packageName = start > 0 && end > start ? subsystem.substring(start + 1, end).toUpperCase() : subsystem;
        this.packagePrefix = this.packageName + " - ";
        if (!useSlf4j) {
            this.nativeLog = repository.getLogger(subsystem);
        } else {
            this.slf4jLogger = LoggerFactory.getLogger((String)subsystem);
        }
        if (messagePrefix != null) {
            this.messagePrefix = messagePrefix + " - ";
        }
    }

    public Logger() {
        this(DEFAULT_SUBSYSTEM);
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.fatal((Object)this.prefixMessage(message));
            } else {
                this.slf4jLogger.error(this.prefixMessage(message));
            }
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.fatal((Object)this.prefixMessage(message), Logger.getRealTargetException(t));
            } else {
                this.slf4jLogger.error(this.prefixMessage(message), Logger.getRealTargetException(t));
            }
        }
    }

    public void fatal(Object message, Object o) {
        if (this.isFatalEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.fatal(message.toString() + ": " + ostring);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.error((Object)this.prefixMessage(message));
            } else {
                this.slf4jLogger.error(this.prefixMessage(message));
            }
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.error((Object)this.prefixMessage(message), Logger.getRealTargetException(t));
            } else {
                this.slf4jLogger.error(this.prefixMessage(message), Logger.getRealTargetException(t));
            }
        }
    }

    public void error(Object message, Object o) {
        if (this.isErrorEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.error(message.toString() + ": " + ostring);
        }
    }

    public void warning(Object message) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.warn((Object)this.prefixMessage(message));
            } else {
                this.slf4jLogger.warn(this.prefixMessage(message));
            }
        }
    }

    public void warning(Object message, Throwable t) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.warn((Object)this.prefixMessage(message), Logger.getRealTargetException(t));
            } else {
                this.slf4jLogger.warn(this.prefixMessage(message), Logger.getRealTargetException(t));
            }
        }
    }

    public void warning(Object message, Object o) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.warning(message.toString() + ": " + ostring);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.warn((Object)this.prefixMessage(message));
            } else {
                this.slf4jLogger.warn(this.prefixMessage(message));
            }
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.warn((Object)this.prefixMessage(message), Logger.getRealTargetException(t));
            } else {
                this.slf4jLogger.warn(this.prefixMessage(message), Logger.getRealTargetException(t));
            }
        }
    }

    public void warn(Object message, Object o) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            this.warning(message, o);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.info((Object)this.prefixMessage(message), Logger.getRealTargetException(t));
            } else {
                this.slf4jLogger.info(this.prefixMessage(message), Logger.getRealTargetException(t));
            }
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.info((Object)this.prefixMessage(message));
            } else {
                this.slf4jLogger.info(this.prefixMessage(message));
            }
        }
    }

    public void info(Object message, Object o) {
        if (this.isInfoEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.info(message.toString() + ": " + ostring);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.debug((Object)this.prefixMessage(message));
            } else {
                this.slf4jLogger.debug(this.prefixMessage(message));
            }
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled() && !Logger.threadIgnored()) {
            if (this.nativeLog != null) {
                this.nativeLog.debug((Object)this.prefixMessage(message), Logger.getRealTargetException(t));
            } else {
                this.slf4jLogger.debug(this.prefixMessage(message), Logger.getRealTargetException(t));
            }
        }
    }

    public void debug(Object message, Object o) {
        if (this.isDebugEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.debug(message.toString() + ": " + ostring);
        }
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor(Level.FATAL);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(Level.ERROR);
    }

    public boolean isEnabledFor(Object level) {
        if (!logEnabled) {
            return false;
        }
        if (this.level != null) {
            return ((Level)level).isGreaterOrEqual((Priority)this.level);
        }
        if (this.nativeLog != null) {
            return this.nativeLog.isEnabledFor((Priority)((Level)level));
        }
        if (FATAL.equals((Object)((Level)level))) {
            return this.slf4jLogger.isErrorEnabled();
        }
        if (ERROR.equals((Object)((Level)level))) {
            return this.slf4jLogger.isErrorEnabled();
        }
        if (WARN.equals((Object)((Level)level))) {
            return this.slf4jLogger.isWarnEnabled();
        }
        if (INFO.equals((Object)((Level)level))) {
            return this.slf4jLogger.isInfoEnabled();
        }
        return this.slf4jLogger.isDebugEnabled();
    }

    private static Stack getStackForCurrentThread() {
        Stack s = (Stack)threadContext.get(Thread.currentThread().getName());
        if (s == null) {
            s = new Stack();
            threadContext.put(Thread.currentThread().getName(), s);
        }
        return s;
    }

    public static void pushContext(String message) {
        Stack s = Logger.getStackForCurrentThread();
        s.push(message);
    }

    public static void popContext() {
        Stack s = Logger.getStackForCurrentThread();
        try {
            s.pop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String peekContext() {
        Stack s = Logger.getStackForCurrentThread();
        if (s.empty()) {
            return null;
        }
        return s.toString();
    }

    public static void removeContext() {
        threadContext.remove(Thread.currentThread().getName());
    }

    public Object getLevel() {
        if (this.nativeLog == null) {
            return null;
        }
        return this.nativeLog.getLevel();
    }

    public void setLevel(Object level) {
        if (this.nativeLog != null) {
            this.nativeLog.setLevel((Level)level);
        }
    }

    public Object getInstanceLevel() {
        if (this.level != null) {
            return this.level;
        }
        return this.getLevel();
    }

    public void setInstanceLevel(Object level) {
        this.level = (Level)level;
    }

    public static void saveCurrentThreshold(String category) {
        if (Logger.useLog4j()) {
            Level level = repository.getLogger(category).getLevel();
            savedThresholds.put(category, level);
        }
    }

    public static void restoreSavedThresholds() {
        if (Logger.useLog4j()) {
            for (Map.Entry<String, Level> entry : savedThresholds.entrySet()) {
                org.apache.log4j.Logger logger = repository.getLogger(entry.getKey());
                if (logger == null) continue;
                logger.setLevel(entry.getValue());
            }
            savedThresholds.clear();
        }
    }

    static {
        ALL = Level.ALL;
        DEBUG = Level.DEBUG;
        ERROR = Level.ERROR;
        FATAL = Level.FATAL;
        INFO = Level.INFO;
        OFF = Level.OFF;
        WARN = Level.WARN;
        logEnabled = true;
        prefixWithPackage = false;
        useExistingLogOnly = false;
        threadContext = Collections.synchronizedMap(new HashMap());
        useSlf4j = false;
        useLog4jConfig = true;
        try {
            String sUseLog4jConfig;
            String sUseSlf4j;
            String sLogEnabled = System.getProperty("iscLogEnabled");
            if ("false".equals(sLogEnabled)) {
                logEnabled = false;
            }
            if ("true".equals(sUseSlf4j = System.getProperty("iscUseSlf4j"))) {
                useSlf4j = true;
            }
            if (useSlf4j && "false".equals(sUseLog4jConfig = System.getProperty("iscUseLog4jConfig"))) {
                useLog4jConfig = false;
            }
            if (useLog4jConfig) {
                if (!logEnabled) {
                    if (useSlf4j) {
                        repository = LogManager.getRootLogger().getLoggerRepository();
                        repository.getRootLogger().setLevel(OFF);
                    } else {
                        hierarchy = new Hierarchy((org.apache.log4j.Logger)new RootLogger(OFF));
                        repository = hierarchy;
                    }
                } else {
                    if (useSlf4j) {
                        repository = LogManager.getRootLogger().getLoggerRepository();
                        repository.getRootLogger().setLevel(WARN);
                    } else {
                        hierarchy = new Hierarchy((org.apache.log4j.Logger)new RootLogger(WARN));
                        repository = hierarchy;
                    }
                    URL configURL = Loader.getResource((String)"log4j.isc.config.xml");
                    if (configURL == null) {
                        System.out.println("=== SmartClient Init: log4j.isc.config.xml not found in CLASSPATH. Assuming log4j configuration for com.isomorphic is located in some other log4j configuration file.");
                    } else {
                        System.out.println("ISC: Configuring log4j from: " + configURL);
                        new DOMConfigurator().doConfigure(configURL, repository);
                        URL projectConfigURL = Loader.getResource((String)"log4j.isc.project.config.xml");
                        if (projectConfigURL != null) {
                            System.out.println("ISC: Appending log4j config from: " + projectConfigURL);
                            new DOMConfigurator().doConfigure(configURL, repository);
                        }
                    }
                    org.apache.log4j.Logger rootLogger = repository.getRootLogger();
                    Enumeration e = rootLogger.getAllAppenders();
                    if (!e.hasMoreElements()) {
                        rootLogger.addAppender((Appender)new NullAppender());
                    }
                }
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            try {
                sw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("ISC: ERROR: Unable to configure log4j - logging may not be available.\r\n" + sw.toString());
        }
        savedThresholds = Collections.synchronizedMap(new HashMap());
    }
}

