/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.scripting.IScript;
import com.isomorphic.scripting.ScriptGroovy;
import com.isomorphic.scripting.ScriptJS;
import com.isomorphic.scripting.ScriptJava;
import com.isomorphic.scripting.ScriptR;
import com.isomorphic.scripting.ScriptXBase;
import com.isomorphic.servlet.RequestContext;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class Scripting
extends Base {
    protected static Logger log = new Logger(Scripting.class.getName());

    public static Map getAvailableScriptEngines() throws Exception {
        HashMap<String, String> scriptEngines = new HashMap<String, String>();
        try {
            Class.forName("com.isomorphic.scripting.java.ISCJavaScriptEngineFactory", false, Scripting.class.getClassLoader());
            scriptEngines.put("java", "Java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            List<ScriptEngineFactory> factories = mgr.getEngineFactories();
            for (int i = 0; i < factories.size(); ++i) {
                ScriptEngineFactory factory = factories.get(i);
                String language = factory.getLanguageName();
                String engineName = factory.getNames().get(0);
                scriptEngines.put(engineName, language);
            }
            return scriptEngines;
        }
        catch (Throwable e) {
            try {
                new GroovyShell();
                scriptEngines.put("groovy", "Groovy");
            }
            catch (Throwable ee) {
                log.error((Object)"Unable to init scripting.  Make sure you're running JDK 1.6+ for JSR223 scripting or install Groovy.", e);
            }
            return scriptEngines;
        }
    }

    public static RPCResponse evalGroovyScript(DataTypeMap data) throws Exception {
        return new RPCResponse(new ScriptGroovy().eval(data));
    }

    public static RPCResponse devConsoleEvalServerScript(RequestContext context, DataTypeMap data) throws Exception {
        String engineName = (String)data.get("engineName");
        boolean supportsFullJavaReflection = config.getBoolean((Object)("scripting." + engineName.toLowerCase() + ".supportsFullJavaReflection"), true);
        HashMap<String, RequestContext> bindings = (HashMap<String, RequestContext>)data.get("bindings");
        if (bindings == null) {
            bindings = new HashMap<String, RequestContext>();
            data.put("bindings", bindings);
        }
        if (supportsFullJavaReflection) {
            bindings.put("requestContext", context);
            bindings.put("request", (RequestContext)((Object)context.request));
            bindings.put("response", (RequestContext)context.response);
            bindings.put("servletContext", (RequestContext)context.servletContext);
            if (InterfaceProvider.exists("ISpringBeanFactory", false)) {
                try {
                    ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                    if (beanFactory != null) {
                        bindings.put("beanFactory", (RequestContext)beanFactory.getBeanFactory(context.servletContext));
                        bindings.put("applicationContext", (RequestContext)beanFactory.getBeanFactory(context.servletContext));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bindings.put("log", (RequestContext)((Object)log));
        }
        return Scripting.evalServerScript(data);
    }

    public static RPCResponse evalServerScript(DataTypeMap data) throws Exception {
        IScript script = Scripting.getScript((String)data.get("engineName"));
        return new RPCResponse(script.eval(data));
    }

    public static IScript getScript(String engineName) throws Exception {
        if (engineName == null || "".equals(engineName.trim())) {
            throw new Exception("Script language is not defined.");
        }
        if ("groovy".equals(engineName = engineName.trim().toLowerCase())) {
            return new ScriptGroovy();
        }
        if ("java".equals(engineName)) {
            return new ScriptJava();
        }
        if ("javascript".equals(engineName) || "ecmascript".equals(engineName) || "js".equals(engineName)) {
            return new ScriptJS();
        }
        if ("r".equals(engineName) || "rengine".equals(engineName)) {
            return new ScriptR();
        }
        return new ScriptXBase();
    }
}

