/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.scripting.ScriptExceptionItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptException
extends Exception {
    private String scriptSourceName = null;
    private List<ScriptExceptionItem> items;

    public ScriptException(String message, Throwable cause) {
        super(message, cause);
    }

    public ScriptException(String scriptSourceName, List<ScriptExceptionItem> items) {
        this(scriptSourceName, items, null);
    }

    public ScriptException(String scriptSourceName, final ScriptExceptionItem item, Throwable cause) {
        this(scriptSourceName, (List<ScriptExceptionItem>)new ArrayList<ScriptExceptionItem>(){
            {
                this.add(item);
            }
        }, cause);
    }

    public ScriptException(String scriptSourceName, List<ScriptExceptionItem> items, Throwable cause) {
        super(ScriptException.generateMessage(scriptSourceName, items), cause);
        if (items == null || items.size() == 0) {
            throw new ExceptionInInitializerError("Items collection cannot be empty.");
        }
        this.items = items;
    }

    public String getScriptSourceName() {
        return this.scriptSourceName;
    }

    public List<ScriptExceptionItem> getItems() {
        return this.items;
    }

    private static String generateMessage(String scriptSourceName, List<ScriptExceptionItem> items) {
        String msg = null;
        if (scriptSourceName != null && !"".equals(scriptSourceName.trim())) {
            msg = "Script source: " + scriptSourceName.trim();
        }
        for (ScriptExceptionItem item : items) {
            msg = msg == null ? "" : msg + "\n";
            msg = msg + item.toString();
        }
        return msg;
    }
}

