/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class IOUtil {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void copyStreams(InputStream in, OutputStream out) throws IOException {
        IOUtil.copyStreams(in, out, 4096, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufSize) throws IOException {
        IOUtil.copyStreams(in, out, bufSize, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, boolean buffered) throws IOException {
        IOUtil.copyStreams(in, out, 4096, buffered);
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufSize];
        if (buffered) {
            in = new BufferedInputStream(in);
            out = new BufferedOutputStream(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    public static void copyCharacterStreams(Reader in, Writer out) throws IOException {
        IOUtil.copyCharacterStreams(in, out, 4096, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize) throws IOException {
        IOUtil.copyCharacterStreams(in, out, bufSize, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, boolean buffered) throws IOException {
        IOUtil.copyCharacterStreams(in, out, 4096, buffered);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        char[] buffer = new char[bufSize];
        if (buffered) {
            in = new BufferedReader(in);
            out = new BufferedWriter(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutput(Writer writer, Object input) throws Exception {
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            if (!(input instanceof List)) break block11;
                            List inputs = (List)input;
                            Iterator e = inputs.iterator();
                            while (e.hasNext()) {
                                IOUtil.addOutput(writer, e.next());
                            }
                            break block12;
                        }
                        if (!(input instanceof String)) break block13;
                        writer.write((String)input);
                        break block12;
                    }
                    if (!(input instanceof InputStream)) break block14;
                    InputStream inputStream = (InputStream)input;
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    try {
                        IOUtil.copyCharacterStreams(reader, writer);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
                if (!(input instanceof Reader)) break block15;
                Reader inputReader = (Reader)input;
                try {
                    IOUtil.copyCharacterStreams(inputReader, writer);
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    try {
                        inputReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputReader.close();
                }
                catch (Exception exception) {}
                break block12;
            }
            throw new Exception("Unsupported input format: " + input.getClass().getName());
        }
    }

    public static void addOutput(OutputStream out, Object input) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(new NonFlushingOutputStream(out));
        IOUtil.addOutput(writer, input);
        ((Writer)writer).flush();
    }

    public static Reader makeReader(Object source) {
        if (source == null) {
            throw new NullPointerException("Passed null source");
        }
        if (source instanceof Reader) {
            return (Reader)source;
        }
        if (source instanceof InputStream) {
            return new InputStreamReader((InputStream)source);
        }
        if (source instanceof String || source instanceof StringBuffer) {
            return new StringReader(source.toString());
        }
        if (source instanceof char[]) {
            return new CharArrayReader((char[])source);
        }
        if (source instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])source));
        }
        throw new IllegalArgumentException("Don't know to make a Reader from a " + source.getClass().getName());
    }

    public static String inputStreamToString(InputStream stream) throws IOException {
        return IOUtil.readerToString(new InputStreamReader(stream));
    }

    public static String readerToString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtil.copyCharacterStreams(reader, writer);
        return ((Object)writer).toString();
    }

    public static void closeQuitely(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuitely(OutputStream os) {
        try {
            os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = stream.read(buffer);
            if (read <= 0) continue;
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    static class NonFlushingOutputStream
    extends FilterOutputStream {
        public NonFlushingOutputStream(OutputStream stream) {
            super(stream);
        }

        public void flush() {
        }
    }
}

