/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.base.Config;
import com.isomorphic.jpa.EMFProviderInterface;
import com.isomorphic.log.Logger;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.transaction.UserTransaction;

public class EMFProviderBMT
implements EMFProviderInterface {
    private static final String CLASS_NAME = EMFProviderBMT.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public String entityManagerRef;
    public String entityManagerFactoryRef;

    public EMFProviderBMT() {
        this(Config.getGlobal().getString((Object)"jpa.entityManager", null), Config.getGlobal().getString((Object)"jpa.entityManagerFactory", null));
    }

    public EMFProviderBMT(Properties config) {
        this(config.getProperty("entityManager"), config.getProperty("entityManagerFactory"));
    }

    public EMFProviderBMT(String entityManagerRef, String entityManagerFactoryRef) {
        this.entityManagerRef = entityManagerRef;
        this.entityManagerFactoryRef = entityManagerFactoryRef;
    }

    public EntityManagerFactory get() {
        EntityManagerFactory emf = null;
        try {
            Context envCtx = new InitialContext();
            envCtx = (Context)envCtx.lookup("java:comp/env");
            emf = (EntityManagerFactory)envCtx.lookup(this.entityManagerFactoryRef);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire entity manager factory.", (Throwable)ex);
        }
        if (emf == null) {
            throw new PersistenceException("Unable to acquire entity manager factory.");
        }
        return emf;
    }

    public EntityManager getEntityManager() throws PersistenceException {
        EntityManager em = null;
        try {
            Context envCtx = new InitialContext();
            envCtx = (Context)envCtx.lookup("java:comp/env");
            em = (EntityManager)envCtx.lookup(this.entityManagerRef);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire entity manager.", (Throwable)ex);
        }
        if (em == null) {
            throw new PersistenceException("Unable to acquire entity manager.");
        }
        return em;
    }

    public void returnEntityManager(EntityManager em) {
    }

    public Object getTransaction(EntityManager em) throws Exception {
        UserTransaction tx = null;
        try {
            InitialContext envCtx = new InitialContext();
            tx = (UserTransaction)envCtx.lookup("java:comp/UserTransaction");
            if (tx.getStatus() != 0) {
                tx.begin();
            }
            if (em != null) {
                em.joinTransaction();
            }
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire transaction.", (Throwable)ex);
        }
        if (tx == null) {
            throw new PersistenceException("Unable to acquire transaction.");
        }
        return tx;
    }

    public void commitTransaction(Object tx) throws Exception {
        if (tx != null) {
            int status = ((UserTransaction)tx).getStatus();
            if (status == 0) {
                ((UserTransaction)tx).commit();
            } else if (status == 1 || status == 9 || status == 4) {
                throw new PersistenceException("Can not commit. Transaction rolled back already.");
            }
        }
    }

    public void rollbackTransaction(Object tx) {
        if (tx != null) {
            try {
                ((UserTransaction)tx).rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }
}

