@echo off

set HAVE_JDK=0
set HAVE_JRE=0
set JAVA_IN_PATH=0
set USER_DEFINED_JAVA_HOME=0

rem ===========================================================================
rem JAVA_HOME detection
rem ===========================================================================
rem if JAVA_HOME is set in the env, use that
if not "%JAVA_HOME%" == "" (
   set USER_DEFINED_JAVA_HOME=1
   goto checkJavaHome
)

rem if JAVA_HOME is not set in the current environment, try to look it up in the registry
rem ===========================================================================
rem JDK >= 9 detection: JavaHome stored under a different registry key than older releases
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\JDK
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if not "%JAVA_HOME%" == "" (
   set HAVE_JDK=1
   goto checkJavaHome
)

rem if JAVA_HOME is not set in the current environment, try to look it up in the registry
rem ===========================================================================
rem JDK < 9 detection
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Development Kit
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if not "%JAVA_HOME%" == "" (
   set HAVE_JDK=1
   goto checkJavaHome
)

rem ===========================================================================
rem JRE >= 9 detection
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\JDK
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if not "%JAVA_HOME%" == "" (
   set HAVE_JRE=1
   goto checkJavaHome
)

rem ===========================================================================
rem JRE < 9 detection
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Runtime Environment
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if not "%JAVA_HOME%" == "" (
   set HAVE_JRE=1
   goto checkJavaHome
)

rem ===========================================================================
rem Java path detection
rem ===========================================================================
rem as a last effort, try java in the path
for /f %%A in ("java.exe") do (
    set JAVA_BIN_DIR=%%~dp$PATH:A
    set JAVA=%%~dp$PATH:A\java
)
if not "%JAVA_BIN_DIR%" == "" (
   set JAVA_IN_PATH=1
   goto checkJavaHome
)

:checkJavaHome
if %USER_DEFINED_JAVA_HOME% == 1 (
    echo. 
    echo:Using user-defined JAVA_HOME: "%JAVA_HOME%"
    echo. 
    goto setJava
)

if %HAVE_JDK% == 1 (
    echo.
    echo:Using auto-detected JDK JAVA_HOME: "%JAVA_HOME%"
    echo.
    goto setJava
)

if %HAVE_JRE% == 1 (
    echo.
    echo:Using auto-detected JRE JAVA_HOME: "%JAVA_HOME%"
    echo.
    goto setJava
)

if %JAVA_IN_PATH% == 1 (
    echo.
    echo:Using Java installation detected in PATH variable at "%JAVA_BIN_DIR%"
    echo.
    goto setJava
)

rem if JAVA_HOME is unset, complain
if "%JAVA_HOME%" == "" (
    echo.
    echo:Error: could not find a Java JDK or JRE in your environment.
    echo.
    echo:If you do not have Java installed, please download and install the JDK.
    echo:If you do have Java installed, please set the JAVA_HOME environment
    echo:variable to the base directory of the JDK.
    echo.
    pause
    exit
)

:setJava
rem if JAVA_HOME environment var is set, look in there for the java binary - otherwise rely on the
rem PATH environment var
if "%JAVA%" == "" set JAVA=java
if not "%JAVA_HOME%" == "" set JAVA=%JAVA_HOME%\bin\java
 
rem read in command line args
set ARGS=
:argLoop
if ""%1""=="""" goto endArgLoop
    set ARGS=%ARGS% %1
    shift
    goto argLoop
:endArgLoop

rem determine java version
for /f "tokens=3*" %%g in ('"%JAVA%" -version 2^>^&1 ^| findstr /i version') do (
    set JAVA_VERSION=%%g
)
set JAVA_VERSION=%JAVA_VERSION:"=%

rem JDK 9,10 don't ship with EE APIs such as javax.xml.bind: must pass a special flag, but 11 onwards, removed entirely
set JAVA_RUNTIME_ARGS=
if "%JAVA_VERSION%" == "9" (
    set JAVA_RUNTIME_ARGS=--add-modules=java.se.ee
)
if "%JAVA_VERSION%" == "10" (
    set JAVA_RUNTIME_ARGS=--add-modules=java.se.ee
)

rem Remember (so we can restore) and set UTF8 codepage on console.  Note that you also need to set a font
rem contains UTF8 chars (most if not all TrueType fonts will work. E.g. "Lucida Console")
for /f "tokens=2 delims=:." %%x in ('chcp') do set DEFAULT_CODEPAGE=%%x
chcp 65001

rem Workaround: HSQLDB shifts dates according to timezone, even if the column is declared as a 
rem true "date" column, which should be timezoneless.  The "user.timezone" reference in this 
rem call sets the local timezone to match the timezone where the sample DB was created.
:execCommand
"%JAVA%" %JAVA_RUNTIME_ARGS% -Xmx512m -Djava.awt.headless=true -Disc_config.override=cli.properties  -Duser.timezone=GMT -Djava.awt.headless=true  -cp ..\..\WEB-INF\classes\;..\..\WEB-INF\lib\spring-jdbc-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\activation.jar;..\..\WEB-INF\lib\gson-2.3.1.jar;..\..\WEB-INF\lib\batik-bridge.jar;..\..\WEB-INF\lib\operadriver-1.5.jar;..\..\WEB-INF\lib\poi-ooxml-3.9-20121203.jar;..\..\WEB-INF\lib\spring-expression-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\jaxrpc.jar;..\..\WEB-INF\lib\htmlunit-core-js-2.14.jar;..\..\WEB-INF\lib\asm-3.1.jar;..\..\WEB-INF\lib\jna-platform-4.1.0.jar;..\..\WEB-INF\lib\spring-web-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\asm-attrs.jar;..\..\WEB-INF\lib\iText-2.0.8.jar;..\..\WEB-INF\lib\spring-tx-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\isomorphic_realtime_messaging.jar;..\..\WEB-INF\lib\spring-beans-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\aopalliance.jar;..\..\WEB-INF\lib\core-renderer.jar;..\..\WEB-INF\lib\isomorphic_struts.jar;..\..\WEB-INF\lib\wsdl4j-1.5.1.jar;..\..\WEB-INF\lib\batik-xml.jar;..\..\WEB-INF\lib\velocity-1.7.jar;..\..\WEB-INF\lib\jna-4.1.0.jar;..\..\WEB-INF\lib\isomorphic_examples.jar;..\..\WEB-INF\lib\commons-io-2.2.jar;..\..\WEB-INF\lib\hibernate-jpa-2.0-api-1.0.0.Final.jar;..\..\WEB-INF\lib\commons-configuration-1.7.jar;..\..\WEB-INF\lib\isomorphic_sql.jar;..\..\WEB-INF\lib\xml-apis-1.3.04.jar;..\..\WEB-INF\lib\groovy-sql-2.3.6.jar;..\..\WEB-INF\lib\commons-jxpath-1.3.jar;..\..\WEB-INF\lib\isomorphic_contentexport.jar;..\..\WEB-INF\lib\isomorphic_compression.jar;..\..\WEB-INF\lib\commons-discovery-0.2.jar;..\..\WEB-INF\lib\httpclient-4.3.5.jar;..\..\WEB-INF\lib\jta-1.1.jar;..\..\WEB-INF\lib\selenium-server-2.47.1.jar;..\..\WEB-INF\lib\groovy-jsr223-2.3.6.jar;..\..\WEB-INF\lib\batik-script.jar;..\..\WEB-INF\lib\jstl.jar;..\..\WEB-INF\lib\antlr-2.7.6.jar;..\..\WEB-INF\lib\guava-13.0.1.jar;..\..\WEB-INF\lib\xml-apis-ext.jar;..\..\WEB-INF\lib\axis.jar;..\..\WEB-INF\lib\dom4j-1.6.1.jar;..\..\WEB-INF\lib\phantomjsdriver-1.1.0.jar;..\..\WEB-INF\lib\spring-webmvc-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\batik-util.jar;..\..\WEB-INF\lib\commons-dbcp-1.3.jar;..\..\WEB-INF\lib\mail.jar;..\..\WEB-INF\lib\jakarta-taglibs-standard-1.1.2.jar;..\..\WEB-INF\lib\saaj.jar;..\..\WEB-INF\lib\isomorphic_spring.jar;..\..\WEB-INF\lib\batik-parser.jar;..\..\WEB-INF\lib\spring-core-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\batik-gvt.jar;..\..\WEB-INF\lib\isomorphic_tools.jar;..\..\WEB-INF\lib\jdbc2_0-stdext.jar;..\..\WEB-INF\lib\javassist-3.4.GA.jar;..\..\WEB-INF\lib\commons-cli-1.2.jar;..\..\WEB-INF\lib\isomorphic_assembly.jar;..\..\WEB-INF\lib\isomorphic_autotest.jar;..\..\WEB-INF\lib\ant.jar;..\..\WEB-INF\lib\commons-logging-1.1.1.jar;..\..\WEB-INF\lib\axis-schema.jar;..\..\WEB-INF\lib\groovy-2.3.6.jar;..\..\WEB-INF\lib\htmlunit-2.14.jar;..\..\WEB-INF\lib\batik-anim.jar;..\..\WEB-INF\lib\commons-beanutils.jar;..\..\WEB-INF\lib\isomorphic_core_rpc.jar;..\..\WEB-INF\lib\hibernate3.jar;..\..\WEB-INF\lib\spring-orm-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\isc-jakarta-oro-2.0.6.jar;..\..\WEB-INF\lib\commons-exec-1.3.jar;..\..\WEB-INF\lib\poi-3.9-20121203.jar;..\..\WEB-INF\lib\isomorphic_js_parser.jar;..\..\WEB-INF\lib\commons-pool-1.6.jar;..\..\WEB-INF\lib\hsqldb-2.2.9.jar;..\..\WEB-INF\lib\commons-lang-2.6.jar;..\..\WEB-INF\lib\struts.jar;..\..\WEB-INF\lib\xmlbeans-2.3.0.jar;..\..\WEB-INF\lib\slf4j-api-1.7.7.jar;..\..\WEB-INF\lib\isomorphic_jpa.jar;..\..\WEB-INF\lib\jtidy-r938.jar;..\..\WEB-INF\lib\commons-validator.jar;..\..\WEB-INF\lib\batik-dom.jar;..\..\WEB-INF\lib\batik-css.jar;..\..\WEB-INF\lib\batik-svg-dom.jar;..\..\WEB-INF\lib\xercesImpl-2.9.1.jar;..\..\WEB-INF\lib\batik-awt-util.jar;..\..\WEB-INF\lib\slf4j-log4j12-1.7.7.jar;..\..\WEB-INF\lib\validation-api-1.0.0.GA.jar;..\..\WEB-INF\lib\commons-vfs-1.0.jar;..\..\WEB-INF\lib\cglib-2.2.jar;..\..\WEB-INF\lib\jetty-repacked-5.jar;..\..\WEB-INF\lib\backport-util-concurrent.jar;..\..\WEB-INF\lib\commons-collections-3.2.2.jar;..\..\WEB-INF\lib\commons-digester.jar;..\..\WEB-INF\lib\isomorphic_web_services.jar;..\..\WEB-INF\lib\poi-ooxml-schemas-3.9-20121203.jar;..\..\WEB-INF\lib\spring-aop-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\commons-fileupload-1.3.3.jar;..\..\WEB-INF\lib\spring-context-3.2.10.RELEASE.jar;..\..\WEB-INF\lib\hibernate-validator-4.1.0.Final.jar;..\..\WEB-INF\lib\httpcore-4.3.2.jar;..\..\WEB-INF\lib\commons-codec-1.6.jar;..\..\WEB-INF\lib\isomorphic_hibernate.jar;..\..\WEB-INF\lib\spring-hibernate3.jar;..\..\WEB-INF\lib\log4j-1.2.17.jar;..\..\WEB-INF\lib\batik-ext.jar;..\..\WEB-INF\embeddedTomcat\* com.isomorphic.tools.SQLImport  %ARGS%
if "%ERRORLEVEL%" == "5" goto execCommand

rem Restore original codepage. Technically this can fail to be called if the user
rem interrupts batch execution with Ctrl+C.  But given that these are not intended to be
rem production tools and the fact that in most cases failure to reset is innocuous, this should
rem be fine.
chcp %DEFAULT_CODEPAGE%

rem if there was an error or relevant output - allow the user to see it before the window
rem auto-closes
pause
