/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.annotations.DataSourceAnnotations;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.IdClass;
import javax.persistence.Persistence;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.BasicType;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPA2DSGenerator {
    private static final String CLASS_NAME = JPA2DSGenerator.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);

    public static Map<String, Map<String, Object>> generateFromPersistenceUnit(String persistenceUnitName) throws Exception {
        HashMap<String, Map<String, Object>> dsList = new HashMap<String, Map<String, Object>>();
        log.debug((Object)("Generating data sources for entities mapped in persistence unit '" + persistenceUnitName + "'"));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        Metamodel metamodel = emf.getMetamodel();
        Set entities = metamodel.getEntities();
        for (EntityType entity : entities) {
            dsList.put(entity.getName() + "_JPA", JPA2DSGenerator.getDataSourceConfigFromEntityType(entity, true, false));
        }
        log.debug((Object)"Generation complete.");
        return dsList;
    }

    public static Map<String, Object> getDataSourceConfigFromMetamodel(String className, EntityManager em) throws Exception {
        return JPA2DSGenerator.getDataSourceConfigFromMetamodel(className, em, true, false);
    }

    public static Map<String, Object> getDataSourceConfigFromMetamodel(String className, EntityManager em, boolean generateRelations, boolean extended) throws Exception {
        log.debug((Object)("Instantiating class " + className));
        Class c = Reflection.classForName((String)className);
        Metamodel metamodel = em.getMetamodel();
        try {
            EntityType entity = metamodel.entity(c);
            return JPA2DSGenerator.getDataSourceConfigFromEntityType(entity, generateRelations, extended);
        }
        catch (Exception exEntity) {
            try {
                EmbeddableType embeddable = metamodel.embeddable(c);
                return JPA2DSGenerator.getDataSourceConfigFromEmbeddableType(embeddable, generateRelations, extended);
            }
            catch (Exception exEmbeddable) {
                throw exEntity;
            }
        }
    }

    private static Map<String, Object> getDataSourceConfigFromEntityType(EntityType entity, boolean generateRelations, boolean extended) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        String id = entity.getName() + "_JPA";
        log.debug((Object)("Generating data source '" + id + "' for class " + entity.getJavaType().getName()));
        config.put("ID", id);
        config.put("serverType", "jpa");
        config.put("beanClassName", entity.getJavaType().getName());
        config.put("dropExtraFields", Boolean.TRUE);
        config.put("allowAdvancedCriteria", Boolean.TRUE);
        Config iscConfig = Config.getGlobal();
        if (iscConfig != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        if (entity.hasSingleIdAttribute()) {
            Type idType = entity.getIdType();
            if (Type.PersistenceType.EMBEDDABLE.equals((Object)idType.getPersistenceType())) {
                config.put("idClassName", idType.getJavaType().getName());
                config.put("extIsEmbeddedId", Boolean.TRUE);
            }
        } else {
            Map idClassAnnotation = DataSourceAnnotations.getAnnotationParameterValues((Object)entity.getJavaType(), IdClass.class);
            if (idClassAnnotation != null) {
                Class idClass = (Class)idClassAnnotation.get("value");
                config.put("idClassName", idClass.getName());
                config.put("extIsEmbeddedId", Boolean.FALSE);
            }
        }
        List<Map<String, Object>> dsFields = JPA2DSGenerator.getDSFields(entity.getAttributes(), generateRelations, extended);
        try {
            List<Map<String, Object>> idFields = JPA2DSGenerator.getDSFields(entity.getIdClassAttributes(), generateRelations, extended);
            dsFields.addAll(idFields);
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.put("fields", dsFields);
        return config;
    }

    private static Map<String, Object> getDataSourceConfigFromEmbeddableType(EmbeddableType embeddable, boolean generateRelations, boolean extended) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        String id = embeddable.getJavaType().getSimpleName() + "_JPA";
        log.debug((Object)("Generating data source '" + id + "' for class " + embeddable.getJavaType().getName()));
        config.put("ID", id);
        config.put("serverType", "jpa");
        config.put("beanClassName", embeddable.getJavaType().getName());
        config.put("dropExtraFields", Boolean.TRUE);
        config.put("allowAdvancedCriteria", Boolean.TRUE);
        Config iscConfig = Config.getGlobal();
        if (iscConfig != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        List<Map<String, Object>> dsFields = JPA2DSGenerator.getDSFields(embeddable.getAttributes(), generateRelations, extended);
        config.put("fields", dsFields);
        return config;
    }

    private static List<Map<String, Object>> getDSFields(Set attributes, boolean generateRelations, boolean extended) throws Exception {
        ArrayList<Map<String, Object>> dsFields = new ArrayList<Map<String, Object>>();
        for (Object attribute : attributes) {
            log.debug((Object)("Generating field '" + ((Attribute)attribute).getName() + "' of type " + ((Attribute)attribute).getJavaType().getName()));
            HashMap<String, String> dsField = DataSourceAnnotations.getDSField((Object)((Attribute)attribute).getJavaMember(), (boolean)extended);
            if (dsField == null) {
                log.warn((Object)"Property not found for mapped attribute.");
                dsField = new HashMap<String, String>();
            }
            dsField.put("name", ((Attribute)attribute).getName());
            if (attribute instanceof SingularAttribute) {
                Object values;
                Class javaType;
                SingularAttribute sa = (SingularAttribute)attribute;
                Type type = sa.getType();
                if (type instanceof BasicType) {
                    if (sa.isId()) {
                        dsField.put("primaryKey", (String)((Object)Boolean.TRUE));
                    }
                    if (sa.isOptional()) {
                        dsField.put("required", (String)((Object)Boolean.FALSE));
                    } else if ("sequence".equals(dsField.get("type")) || DataTools.getBoolean(dsField, (Object)"autoGenerated")) {
                        dsField.put("required", (String)((Object)Boolean.FALSE));
                    } else {
                        dsField.put("required", (String)((Object)Boolean.TRUE));
                    }
                    if (dsField.get("type") == null) {
                        javaType = sa.getJavaType();
                        dsField.put("type", DataSourceAnnotations.dsTypeForJavaType((Class)javaType));
                        if ("enum".equals(dsField.get("type"))) {
                            values = Reflection.getEnumValues((Class)javaType, (boolean)false);
                            dsField.put("valueMap", (String)values);
                        }
                    }
                    log.debug((Object)("Singular field configuration generated: " + dsField));
                    dsFields.add(dsField);
                    continue;
                }
                if (type instanceof EmbeddableType) {
                    log.debug((Object)("Property with embedded fields. Generating subproperties for type " + ((EmbeddableType)type).getJavaType().getName()));
                    List<Map<String, Object>> embeddedFields = JPA2DSGenerator.getDSFields(((EmbeddableType)type).getAttributes(), generateRelations, extended);
                    for (Map<String, Object> map : embeddedFields) {
                        String propertyName = sa.getName();
                        String embeddedPropertyName = (String)map.get("name");
                        map.put("name", propertyName + "_" + embeddedPropertyName);
                        map.put("valueXPath", propertyName + "/" + embeddedPropertyName);
                        map.put("useJoin", Boolean.FALSE);
                        if (sa.isId()) {
                            map.put("primaryKey", Boolean.TRUE);
                        }
                        log.debug((Object)("Updated subproperty field configuration: " + map));
                        dsFields.add(map);
                    }
                    log.debug((Object)"Subproperties generated.");
                    continue;
                }
                if (type instanceof EntityType) {
                    if (generateRelations) {
                        List<Object> entityFields;
                        log.debug((Object)("Property with reference to another entity. Generating reference to type " + ((EntityType)type).getJavaType().getName()));
                        try {
                            entityFields = JPA2DSGenerator.getDSFields(((EntityType)type).getAttributes(), generateRelations, extended);
                        }
                        catch (Exception ex) {
                            entityFields = new ArrayList();
                        }
                        for (Map map : entityFields) {
                            boolean isPk = DataTools.getBoolean((Map)map, (Object)"primaryKey");
                            if (!isPk) continue;
                            map.remove("primaryKey");
                            String propertyName = sa.getName();
                            String entityPropertyName = (String)map.get("name");
                            map.put("name", propertyName + "_" + entityPropertyName);
                            map.put("valueXPath", propertyName + "/" + entityPropertyName);
                            map.put("foreignKey", ((EntityType)type).getName() + "_JPA." + entityPropertyName);
                            log.debug((Object)("Updated reference field configuration: " + dsField));
                            dsFields.add(map);
                        }
                        log.debug((Object)"Reference generated.");
                        continue;
                    }
                    log.debug((Object)("Property with reference to another entity skipped: " + dsField));
                    continue;
                }
                log.warn((Object)"Unknown property type.");
                if (dsField.get("type") == null) {
                    javaType = sa.getJavaType();
                    dsField.put("type", DataSourceAnnotations.dsTypeForJavaType((Class)javaType));
                    if ("enum".equals(dsField.get("type"))) {
                        values = Reflection.getEnumValues((Class)javaType, (boolean)false);
                        dsField.put("valueMap", (String)values);
                    }
                }
                dsFields.add(dsField);
                continue;
            }
            if (!(attribute instanceof PluralAttribute)) continue;
            if (generateRelations) {
                dsField.put("multiple", "true");
                Type elementType = ((PluralAttribute)attribute).getElementType();
                dsField.put("javaClass", elementType.getJavaType().getName());
                if (elementType instanceof EntityType) {
                    dsField.put("type", ((EntityType)elementType).getName() + "_JPA");
                } else {
                    dsField.put("type", DataSourceAnnotations.dsTypeForJavaType((Class)elementType.getJavaType()));
                }
                if (attribute instanceof MapAttribute) {
                    dsField.put("javaKeyClass", ((MapAttribute)attribute).getKeyJavaType().getName());
                }
                log.debug((Object)("Plural field configuration generated: " + dsField));
                dsFields.add(dsField);
                continue;
            }
            log.debug((Object)("Plural field skipped: " + dsField));
        }
        return dsFields;
    }
}

