/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.BaseLineInfo;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.LineInfo;
import com.sun.tools.jdi.LocalVariableImpl;
import com.sun.tools.jdi.LocationImpl;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.SDE;
import com.sun.tools.jdi.StratumLineInfo;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConcreteMethodImpl
extends MethodImpl {
    private Location location = null;
    private SoftReference softBaseLocationXRefsRef;
    private SoftReference softOtherLocationXRefsRef;
    private SoftReference variablesRef = null;
    private boolean absentVariableInformation = false;
    private long firstIndex = -1L;
    private long lastIndex = -1L;
    private SoftReference bytecodesRef = null;
    private int argSlotCount = -1;

    ConcreteMethodImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l, String string, String string2, String string3, int n) {
        super(virtualMachine, referenceTypeImpl, l, string, string2, string3, n);
    }

    public Location location() {
        if (this.location == null) {
            this.getBaseLocations();
        }
        return this.location;
    }

    List sourceNameFilter(List list, SDE.Stratum stratum, String string) throws AbsentInformationException {
        if (string == null) {
            return list;
        }
        ArrayList<LocationImpl> arrayList = new ArrayList<LocationImpl>();
        for (LocationImpl locationImpl : list) {
            if (!locationImpl.sourceName(stratum).equals(string)) continue;
            arrayList.add(locationImpl);
        }
        return arrayList;
    }

    List allLineLocations(SDE.Stratum stratum, String string) throws AbsentInformationException {
        List list = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (list.size() == 0) {
            throw new AbsentInformationException();
        }
        return Collections.unmodifiableList(this.sourceNameFilter(list, stratum, string));
    }

    List locationsOfLine(SDE.Stratum stratum, String string, int n) throws AbsentInformationException {
        SoftLocationXRefs softLocationXRefs = this.getLocations(stratum);
        if (softLocationXRefs.lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        ArrayList arrayList = (ArrayList)softLocationXRefs.lineMapper.get(new Integer(n));
        if (arrayList == null) {
            arrayList = new ArrayList(0);
        }
        return Collections.unmodifiableList(this.sourceNameFilter(arrayList, stratum, string));
    }

    public Location locationOfCodeIndex(long l) {
        if (this.firstIndex == -1L) {
            this.getBaseLocations();
        }
        if (l < this.firstIndex || l > this.lastIndex) {
            return null;
        }
        return new LocationImpl(this.virtualMachine(), this, l);
    }

    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long l) {
        LocationImpl locationImpl;
        if (this.firstIndex == -1L) {
            this.getBaseLocations();
        }
        if (l < this.firstIndex || l > this.lastIndex) {
            throw new InternalError("Location with invalid code index");
        }
        List list = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (list.size() == 0) {
            return super.codeIndexToLineInfo(stratum, l);
        }
        Iterator iterator = list.iterator();
        LocationImpl locationImpl2 = (LocationImpl)iterator.next();
        while (iterator.hasNext() && (locationImpl = (LocationImpl)iterator.next()).codeIndex() <= l) {
            locationImpl2 = locationImpl;
        }
        return locationImpl2.getLineInfo(stratum);
    }

    public List variables() throws AbsentInformationException {
        return this.getVariables();
    }

    public List variablesByName(String string) throws AbsentInformationException {
        List list = this.getVariables();
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(2);
        for (LocalVariable localVariable : list) {
            if (!localVariable.name().equals(string)) continue;
            arrayList.add(localVariable);
        }
        return arrayList;
    }

    public List arguments() throws AbsentInformationException {
        List list = this.getVariables();
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(list.size());
        for (LocalVariable localVariable : list) {
            if (!localVariable.isArgument()) continue;
            arrayList.add(localVariable);
        }
        return arrayList;
    }

    public byte[] bytecodes() {
        byte[] byArray;
        byte[] byArray2 = byArray = this.bytecodesRef == null ? null : (byte[])this.bytecodesRef.get();
        if (byArray == null) {
            try {
                byArray = JDWP.Method.Bytecodes.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).bytes;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            this.bytecodesRef = new SoftReference<byte[]>(byArray);
        }
        return (byte[])byArray.clone();
    }

    int argSlotCount() throws AbsentInformationException {
        if (this.argSlotCount == -1) {
            this.getVariables();
        }
        return this.argSlotCount;
    }

    private SoftLocationXRefs getLocations(SDE.Stratum stratum) {
        SoftLocationXRefs softLocationXRefs;
        if (stratum.isJava()) {
            return this.getBaseLocations();
        }
        String string = stratum.id();
        SoftLocationXRefs softLocationXRefs2 = softLocationXRefs = this.softOtherLocationXRefsRef == null ? null : (SoftLocationXRefs)this.softOtherLocationXRefsRef.get();
        if (softLocationXRefs != null && softLocationXRefs.stratumID.equals(string)) {
            return softLocationXRefs;
        }
        ArrayList<LocationImpl> arrayList = new ArrayList<LocationImpl>();
        HashMap<Integer, ArrayList<LocationImpl>> hashMap = new HashMap<Integer, ArrayList<LocationImpl>>();
        int n = -1;
        int n2 = -1;
        SDE.LineStratum lineStratum = null;
        SDE.Stratum stratum2 = this.declaringType.stratum("Java");
        for (LocationImpl locationImpl : this.getBaseLocations().lineLocations) {
            int n3;
            int n4 = locationImpl.lineNumber(stratum2);
            SDE.LineStratum lineStratum2 = stratum.lineStratum(this.declaringType, n4);
            if (lineStratum2 == null || (n3 = lineStratum2.lineNumber()) == -1 || lineStratum2.equals(lineStratum)) continue;
            lineStratum = lineStratum2;
            if (n3 > n2) {
                n2 = n3;
            }
            if (n3 < n || n == -1) {
                n = n3;
            }
            locationImpl.addStratumLineInfo(new StratumLineInfo(string, n3, lineStratum2.sourceName(), lineStratum2.sourcePath()));
            arrayList.add(locationImpl);
            Integer n5 = new Integer(n3);
            ArrayList<LocationImpl> arrayList2 = (ArrayList<LocationImpl>)hashMap.get(n5);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<LocationImpl>(1);
                hashMap.put(n5, arrayList2);
            }
            arrayList2.add(locationImpl);
        }
        softLocationXRefs = new SoftLocationXRefs(string, hashMap, arrayList, n, n2);
        this.softOtherLocationXRefsRef = new SoftReference<SoftLocationXRefs>(softLocationXRefs);
        return softLocationXRefs;
    }

    private SoftLocationXRefs getBaseLocations() {
        SoftLocationXRefs softLocationXRefs;
        SoftLocationXRefs softLocationXRefs2 = softLocationXRefs = this.softBaseLocationXRefsRef == null ? null : (SoftLocationXRefs)this.softBaseLocationXRefsRef.get();
        if (softLocationXRefs != null) {
            return softLocationXRefs;
        }
        JDWP.Method.LineTable lineTable = null;
        try {
            lineTable = JDWP.Method.LineTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        int n = lineTable.lines.length;
        ArrayList<LocationImpl> arrayList = new ArrayList<LocationImpl>(n);
        HashMap<Integer, ArrayList<LocationImpl>> hashMap = new HashMap<Integer, ArrayList<LocationImpl>>();
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            long l = lineTable.lines[i].lineCodeIndex;
            int n4 = lineTable.lines[i].lineNumber;
            if (i + 1 != n && l == lineTable.lines[i + 1].lineCodeIndex) continue;
            if (n4 > n3) {
                n3 = n4;
            }
            if (n4 < n2 || n2 == -1) {
                n2 = n4;
            }
            LocationImpl locationImpl = new LocationImpl(this.virtualMachine(), this, l);
            locationImpl.addBaseLineInfo(new BaseLineInfo(n4, this.declaringType));
            arrayList.add(locationImpl);
            Integer n5 = new Integer(n4);
            ArrayList<LocationImpl> arrayList2 = (ArrayList<LocationImpl>)hashMap.get(n5);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<LocationImpl>(1);
                hashMap.put(n5, arrayList2);
            }
            arrayList2.add(locationImpl);
        }
        if (this.location == null) {
            this.firstIndex = lineTable.start;
            this.lastIndex = lineTable.end;
            this.location = n > 0 ? (Location)arrayList.get(0) : new LocationImpl(this.virtualMachine(), this, this.firstIndex);
        }
        softLocationXRefs = new SoftLocationXRefs("Java", hashMap, arrayList, n2, n3);
        this.softBaseLocationXRefsRef = new SoftReference<SoftLocationXRefs>(softLocationXRefs);
        return softLocationXRefs;
    }

    private List getVariables1_4() throws AbsentInformationException {
        JDWP.Method.VariableTable variableTable = null;
        try {
            variableTable = JDWP.Method.VariableTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw jDWPException.toJDIException();
        }
        this.argSlotCount = variableTable.argCnt;
        int n = variableTable.slots.length;
        ArrayList<LocalVariableImpl> arrayList = new ArrayList<LocalVariableImpl>(n);
        for (int i = 0; i < n; ++i) {
            JDWP.Method.VariableTable.SlotInfo slotInfo = variableTable.slots[i];
            if (slotInfo.name.startsWith("this$") || slotInfo.name.equals("this")) continue;
            LocationImpl locationImpl = new LocationImpl(this.virtualMachine(), this, slotInfo.codeIndex);
            LocationImpl locationImpl2 = new LocationImpl(this.virtualMachine(), this, slotInfo.codeIndex + (long)slotInfo.length - 1L);
            LocalVariableImpl localVariableImpl = new LocalVariableImpl(this.virtualMachine(), this, slotInfo.slot, locationImpl, locationImpl2, slotInfo.name, slotInfo.signature, null);
            arrayList.add(localVariableImpl);
        }
        return arrayList;
    }

    private List getVariables1() throws AbsentInformationException {
        if (!this.vm.canGet1_5LanguageFeatures()) {
            return this.getVariables1_4();
        }
        JDWP.Method.VariableTableWithGeneric variableTableWithGeneric = null;
        try {
            variableTableWithGeneric = JDWP.Method.VariableTableWithGeneric.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw jDWPException.toJDIException();
        }
        this.argSlotCount = variableTableWithGeneric.argCnt;
        int n = variableTableWithGeneric.slots.length;
        ArrayList<LocalVariableImpl> arrayList = new ArrayList<LocalVariableImpl>(n);
        for (int i = 0; i < n; ++i) {
            JDWP.Method.VariableTableWithGeneric.SlotInfo slotInfo = variableTableWithGeneric.slots[i];
            if (slotInfo.name.startsWith("this$") || slotInfo.name.equals("this")) continue;
            LocationImpl locationImpl = new LocationImpl(this.virtualMachine(), this, slotInfo.codeIndex);
            LocationImpl locationImpl2 = new LocationImpl(this.virtualMachine(), this, slotInfo.codeIndex + (long)slotInfo.length - 1L);
            LocalVariableImpl localVariableImpl = new LocalVariableImpl(this.virtualMachine(), this, slotInfo.slot, locationImpl, locationImpl2, slotInfo.name, slotInfo.signature, slotInfo.genericSignature);
            arrayList.add(localVariableImpl);
        }
        return arrayList;
    }

    private List getVariables() throws AbsentInformationException {
        List list;
        if (this.absentVariableInformation) {
            throw new AbsentInformationException();
        }
        List list2 = list = this.variablesRef == null ? null : (List)this.variablesRef.get();
        if (list != null) {
            return list;
        }
        list = this.getVariables1();
        list = Collections.unmodifiableList(list);
        this.variablesRef = new SoftReference(list);
        return list;
    }

    private static class SoftLocationXRefs {
        final String stratumID;
        final Map lineMapper;
        final List lineLocations;
        final int lowestLine;
        final int highestLine;

        SoftLocationXRefs(String string, Map map, List list, int n, int n2) {
            this.stratumID = string;
            this.lineMapper = Collections.unmodifiableMap(map);
            this.lineLocations = Collections.unmodifiableList(list);
            this.lowestLine = n;
            this.highestLine = n2;
        }
    }
}

