/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.ConsoleController;
import com.sun.deploy.util.ConsoleHelper;
import com.sun.deploy.util.ConsoleTraceListener;
import com.sun.deploy.util.ConsoleWindow;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.FileTraceListener;
import com.sun.deploy.util.LoggerTraceListener;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.TraceListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import sun.plugin.AppletViewer;
import sun.plugin.util.PluginConsoleController;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.UserProfile;

public class JavaRunTime {
    private static boolean traceInit = false;
    private static ConsoleWindow console = null;
    private static ConsoleTraceListener ctl = null;
    private static ConsoleController controller = null;

    protected static void initEnvironment(String string, String string2, String string3) {
        DeploySysRun.setOverride((DeploySysRun)new PluginSysUtil());
        Properties properties = System.getProperties();
        properties.put("java.home", string);
        if (string3 == null) {
            properties.put("user.home", string);
        } else {
            properties.put("user.home", string3);
        }
        AppletViewer.loadPropertiesFiles();
        Trace.redirectStdioStderr();
    }

    public static synchronized ConsoleWindow getJavaConsole() {
        JavaRunTime.initTraceEnvironment();
        if (console == null) {
            console = ConsoleWindow.create((ConsoleController)controller);
            ctl.setConsole(console);
        }
        return console;
    }

    public static synchronized void initTraceEnvironment() {
        Object object;
        if (traceInit) {
            return;
        }
        traceInit = true;
        if (Config.getBooleanProperty((String)"deployment.trace")) {
            object = Config.getProperty((String)"deployment.trace.level");
            if (object == null || ((String)object).equals("")) {
                Trace.setBasicTrace((boolean)true);
                Trace.setNetTrace((boolean)true);
                Trace.setCacheTrace((boolean)true);
                Trace.setTempTrace((boolean)true);
                Trace.setSecurityTrace((boolean)true);
                Trace.setExtTrace((boolean)true);
                Trace.setLiveConnectTrace((boolean)true);
            } else {
                Trace.setInitialTraceLevel();
            }
        }
        controller = new PluginConsoleController();
        ctl = new ConsoleTraceListener(controller);
        Trace.addTraceListener((TraceListener)ctl);
        object = new File(UserProfile.getTraceFile());
        ((File)object).getParentFile().mkdirs();
        if (((File)object).canWrite() || !((File)object).exists() && ((File)object).getParentFile().canWrite()) {
            Trace.addTraceListener((TraceListener)new FileTraceListener((File)object, false));
        } else {
            Trace.println((String)("can not write to trace file: " + object), (TraceLevel)TraceLevel.BASIC);
        }
        if (Config.getBooleanProperty((String)"deployment.log")) {
            String string = UserProfile.getLogFile();
            File file = new File(string);
            file.getParentFile().mkdirs();
            if (file.canWrite() || !file.exists() && file.getParentFile().canWrite()) {
                LoggerTraceListener loggerTraceListener = new LoggerTraceListener("sun.plugin", string);
                loggerTraceListener.getLogger().setLevel(Level.ALL);
                ((PluginConsoleController)controller).setLogger(loggerTraceListener.getLogger());
                Trace.addTraceListener((TraceListener)loggerTraceListener);
            } else {
                Trace.println((String)("can not write to log file: " + string), (TraceLevel)TraceLevel.BASIC);
            }
        }
        System.out.print(ConsoleHelper.displayVersion());
    }

    public static boolean isJavaConsoleVisible() {
        if (console == null) {
            return false;
        }
        return console.isConsoleVisible();
    }

    public static void showJavaConsole(final boolean bl) {
        try {
            PluginSysUtil.invokeAndWait(new Runnable(){

                public void run() {
                    ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
                    if (consoleWindow != null) {
                        consoleWindow.showConsole(bl);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void showJavaConsoleLater(final boolean bl) {
        try {
            PluginSysUtil.invokeLater(new Runnable(){

                public void run() {
                    ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
                    if (consoleWindow != null) {
                        consoleWindow.showConsole(bl);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printToJavaConsole(String string) {
        ctl.print(string + "\n");
    }

    public static native String dumpAllStacks();
}

