/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.IMessaging;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessagingConnectionHandler
implements IMessaging {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(MessagingConnectionHandler.class.getName());
    static int keepaliveInterval = config.getInt((Object)"messaging.keepaliveInterval", -1);
    static int connectionTTL = config.getInt((Object)"messaging.connectionTTL", 0);
    static int keepaliveReestablishDelay = config.getInt((Object)"messaging.keepaliveReestablishDelay", -1);
    static int clientReconnectWindow = config.getInt((Object)"messaging.clientReconnectWindow", -1);
    static int connectTimeout = config.getInt((Object)"messaging.connectTimeout", -1);
    RequestContext context;
    HttpServletRequest request;
    HttpServletResponse response;
    Writer out;
    boolean eventStream = false;
    boolean disconnectUponConnect = false;
    String sessionID;
    String requestType;
    String connectionID;
    ISCMessageDispatcher dispatcher;
    ISubscriber subscriber;
    long registrationTime;
    private static String syncDomain = "if (window.top != window && !(new RegExp(\"^(\\\\d{1,3}\\\\.){3}\\\\d{1,3}$\").test(document.domain))){while (document.domain.indexOf('.') != -1) {try {if (window.parent.isc) break;} catch (e) {try {document.domain = document.domain.replace(/.*?\\./, '');} catch (ee) {break;}}}}";

    public MessagingConnectionHandler() {
    }

    public void send(RequestContext context, Map values) throws Exception {
        List channels = (List)values.get("sendToChannels");
        Object data = values.get("data");
        ISCMessage msg = new ISCMessage(channels, data);
        this.dispatcher = ISCMessageDispatcher.instance(context);
        this.dispatcher.deliver(msg);
        try {
            this.dispatcher.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessagingConnectionHandler(RequestContext context) throws Exception {
        this.context = context;
        this.request = context.request;
        this.response = context.response;
        this.sessionID = this.request.getSession().getId();
        this.connectionID = this.request.getParameter("connectionID");
        if (!DataTools.isIdentifier((String)this.connectionID)) {
            throw new Exception("connectionID is not a valid identifier: " + DataTools.escapeHTML((String)this.connectionID));
        }
        this.requestType = this.request.getParameter("type");
    }

    public void process() throws Exception {
        block15: {
            this.response.setHeader("Connection", "close");
            RequestContext.setNoCacheHeaders((HttpServletResponse)this.response);
            this.out = this.context.out();
            if (!this.eventStream) {
                ServletTools.sendHTMLStart((Writer)this.out);
                this.sendSyncDocumentDomain();
            }
            this.dispatcher = ISCMessageDispatcher.instance(this.context);
            this.subscriber = this.registerSubscriber();
            boolean inClientReconnectWindow = false;
            try {
                if ("establishAck".equals(this.requestType)) {
                    this.sendEstablishAck();
                    break block15;
                }
                this.sendConnectCallback();
                int ttl = this.disconnectUponConnect ? 1 : connectionTTL;
                while (true) {
                    long start = System.currentTimeMillis();
                    ISCMessage msg = this.subscriber.nextMessage(Math.min(keepaliveInterval, ttl));
                    long end = System.currentTimeMillis();
                    ttl = (int)((long)ttl - (end - start));
                    if (msg != null) {
                        this.sendMessage(msg);
                        continue;
                    }
                    if (ttl > 0) {
                        this.sendKeepalive();
                        continue;
                    }
                    if (!inClientReconnectWindow) {
                        this.terminateConnection();
                        inClientReconnectWindow = true;
                        ttl = clientReconnectWindow;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.dispatcher.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dispatcher.unregister(this.subscriber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.eventStream) {
            try {
                ServletTools.sendHTMLEnd((Writer)this.out);
                this.response.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendSyncDocumentDomain() throws Exception {
        ServletTools.sendScriptBlock((String)syncDomain, (Writer)this.out);
        this.response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEstablishAck() throws Exception {
        String ackFrameID = this.context.request.getParameter("ackFrameID");
        if (!DataTools.isIdentifier((String)ackFrameID)) {
            throw new Exception("ackFrameID is not a valid identifier: " + DataTools.escapeHTML((String)ackFrameID));
        }
        String ackCallback = "parent.isc.Messaging._establishAck('" + ackFrameID + "');";
        if (this.eventStream) {
            Writer writer = this.out;
            synchronized (writer) {
                this.out.write("event: establishAck\n");
                ServletTools.sendMessageEventWithPadding((String)ackCallback, (Writer)this.out);
            }
        } else {
            ServletTools.sendScriptBlockWithPadding((String)ackCallback, (Writer)this.out);
        }
        this.response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConnectCallback() throws Exception {
        String initCallback = "parent.isc.Messaging._connectCallback('" + this.connectionID + "', {keepaliveInterval: " + keepaliveInterval + ",connectionTTL: " + connectionTTL + ",connectTimeout: " + connectTimeout + ",keepaliveReestablishDelay: " + keepaliveReestablishDelay + "});";
        if (this.eventStream) {
            Writer writer = this.out;
            synchronized (writer) {
                this.out.write("event: connectCallback\n");
                ServletTools.sendMessageEventWithPadding((String)initCallback, (Writer)this.out);
            }
        } else {
            ServletTools.sendScriptBlockWithPadding((String)initCallback, (Writer)this.out);
        }
        this.response.flushBuffer();
    }

    public void sendMessage(ISCMessage msg) throws Exception {
        JSTranslater jsTrans = this.context.jsTrans;
        DataTypeMap messageMap = DataTools.buildMap((Object[])new Object[]{"conn", this.connectionID, "channels", msg.getTargetChannels(), "id", msg.getID(), "data", msg.getData()});
        String message = jsTrans.toJS((Object)jsTrans.toJS((Object)messageMap));
        String update = "parent.isc.Messaging._message(" + message + ");";
        if (this.eventStream) {
            ServletTools.sendMessageEventWithPadding((String)update, (Writer)this.out);
        } else {
            ServletTools.sendScriptBlockWithPadding((String)update, (Writer)this.out);
        }
        this.response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepalive() throws Exception {
        String keepalive = "parent.isc.Messaging._keepalive('" + this.connectionID + "');";
        if (this.eventStream) {
            Writer writer = this.out;
            synchronized (writer) {
                this.out.write("event: keepalive\n");
                ServletTools.sendMessageEventWithPadding((String)keepalive, (Writer)this.out);
            }
        } else {
            ServletTools.sendScriptBlockWithPadding((String)keepalive, (Writer)this.out);
        }
        this.response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateConnection() throws Exception {
        String connTerminate = "parent.isc.Messaging._serverConnTerminate('" + this.connectionID + "');";
        if (this.eventStream) {
            Writer writer = this.out;
            synchronized (writer) {
                this.out.write("event: serverConnTerminate\n");
                ServletTools.sendMessageEventWithPadding((String)connTerminate, (Writer)this.out);
            }
        } else {
            ServletTools.sendScriptBlockWithPadding((String)connTerminate, (Writer)this.out);
        }
        this.response.flushBuffer();
    }

    public ISubscriber registerSubscriber() throws Exception {
        Map channels = (Map)this.context.jsTrans.fromJS(this.context.request.getParameter("subscribedChannels"));
        String subscriberImpl = config.getString((Object)"messaging.subscriberImplementer");
        ISubscriber subscriber = (ISubscriber)Reflection.instantiateClass((String)subscriberImpl);
        this.dispatcher.register(subscriber);
        this.dispatcher.subscribe(subscriber, channels);
        return subscriber;
    }
}

