/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class TransientAsyncAppender
extends AsyncAppender {
    protected int transientBufferSize = 50;
    protected CircularFifoBuffer transientBuffer;
    protected Level transientBufferDumpThreshold = Level.FATAL;
    protected Level passthroughThreshold = Level.INFO;

    public TransientAsyncAppender() {
        this.transientBuffer = new CircularFifoBuffer(this.transientBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransientBufferSize(int size) {
        Class<TransientAsyncAppender> clazz = TransientAsyncAppender.class;
        synchronized (TransientAsyncAppender.class) {
            while (this.transientBuffer.size() > size) {
                this.transientBuffer.remove();
            }
            CircularFifoBuffer newBuffer = new CircularFifoBuffer(size);
            while (this.transientBuffer.size() > 0) {
                newBuffer.add(this.transientBuffer.remove());
            }
            this.transientBuffer = newBuffer;
            this.transientBufferSize = size;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setTransientBufferDumpThreshold(String level) {
        this.transientBufferDumpThreshold = Level.toLevel((String)level);
    }

    public void setPassthroughThreshold(String level) {
        this.passthroughThreshold = Level.toLevel((String)level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpBuffer() {
        Class<TransientAsyncAppender> clazz = TransientAsyncAppender.class;
        synchronized (TransientAsyncAppender.class) {
            if (this.transientBuffer.size() > 0) {
                super.append(new LoggingEvent("", (Category)Logger.getLogger((String)((Object)((Object)this)).getClass().getName()), (Priority)this.transientBufferDumpThreshold, (Object)"------TRANSIENT BUFFER DUMP FOLLOWS------", null));
                while (this.transientBuffer.size() > 0) {
                    super.append((LoggingEvent)this.transientBuffer.remove());
                }
                super.append(new LoggingEvent("", (Category)Logger.getLogger((String)((Object)((Object)this)).getClass().getName()), (Priority)this.transientBufferDumpThreshold, (Object)"------END TRANSIENT BUFFER DUMP------", null));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void append(LoggingEvent event) {
        Level eventLevel = event.getLevel();
        if (eventLevel.isGreaterOrEqual((Priority)this.transientBufferDumpThreshold)) {
            this.dumpBuffer();
        } else {
            Class<TransientAsyncAppender> clazz = TransientAsyncAppender.class;
            // MONITORENTER : com.isomorphic.log.TransientAsyncAppender.class
            this.transientBuffer.add((Object)event);
            // MONITOREXIT : clazz
        }
        if (!eventLevel.isGreaterOrEqual((Priority)this.passthroughThreshold)) return;
        super.append(event);
    }
}

