/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FeatureExplorerRPC
extends BaseServlet {
    String examplesDir;
    boolean wwwProduction = false;
    boolean devenv = false;
    private final String bounceCSSPrefix = "bounceCSS_";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this.examplesDir == null) {
            this.examplesDir = config.getString("FeatureExplorer.examplesDir");
        }
        this.wwwProduction = config.getBoolean((Object)"wwwProduction", false);
        this.devenv = config.getBoolean((Object)"devenv", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block19: {
            RequestTimer requestTimer;
            block18: {
                requestTimer = new RequestTimer(request);
                Map data = null;
                String method = null;
                Object result = null;
                boolean noSCServer = "true".equals(request.getParameter("noSCServer"));
                RPCManager rpc = null;
                if (noSCServer) {
                    ValidationContext vc = new ValidationContext();
                    vc.setRestrictedXMLMode(true);
                    data = (Map)XML.toDSRecords(new StringReader(request.getParameter("data")), vc);
                    vc.freeResources();
                } else {
                    try {
                        rpc = new RPCManager((Servlet)this, request, response);
                    }
                    catch (ClientMustResubmitException cmre) {
                        Object var11_12 = null;
                        requestTimer.stop();
                        try {
                            response.flushBuffer();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    data = (Map)rpc.getData();
                }
                method = (String)data.get("method");
                if ("loadFiles".equals(method)) {
                    result = this.loadFiles((List)data.get("exampleFiles"));
                }
                if ("xmlToJS".equals(method)) {
                    result = this.xmlToJS((List)data.get("exampleFiles"));
                }
                if ("bounceCSS".equals(method)) {
                    result = this.bounceCSS(request, data);
                }
                if (noSCServer) {
                    JSTranslater.instance().toJS(result, response.getWriter());
                    break block18;
                }
                rpc.send(new RPCResponse(result));
            }
            Object var11_13 = null;
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (Throwable e) {
                    this.handleError(response, e);
                    Object var11_14 = null;
                    requestTimer.stop();
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cssID = request.getParameter("cssID");
        if (cssID != null) {
            HttpSession session = request.getSession(true);
            String css = (String)session.getAttribute("bounceCSS_" + cssID);
            if (css == null) {
                throw new ServletException("invalid cssID: " + cssID);
            }
            session.removeAttribute("bounceCSS_" + cssID);
            response.setContentType("text/css");
            response.setContentLength(css.length());
            response.getWriter().write(css);
            response.flushBuffer();
        } else {
            this.doPost(request, response);
        }
    }

    private List xmlToJS(List exampleFiles) {
        Iterator i = exampleFiles.iterator();
        while (i.hasNext()) {
            DataTypeMap exampleFile = new DataTypeMap((Map)i.next());
            exampleFile.remove("error");
            String fileContents = exampleFile.getString("fileContents");
            try {
                exampleFile.put("xmlToJS", this.convertToJS(fileContents));
            }
            catch (Exception e) {
                exampleFile.put("error", e.toString());
                String exampleFilesAsJS = null;
                try {
                    exampleFilesAsJS = DataTools.prettyPrint(exampleFiles);
                }
                catch (Exception ee) {
                    exampleFilesAsJS = ee.toString();
                }
                this.log.error((Object)("Error during xmlToJS processing - exampleFiles: " + exampleFilesAsJS), e);
            }
        }
        return exampleFiles;
    }

    private String bounceCSS(HttpServletRequest request, Map data) {
        Map exampleFile = (Map)data.get("exampleFile");
        String fileContents = (String)exampleFile.get("fileContents");
        String fileURL = (String)exampleFile.get("url");
        request.getSession(true).setAttribute("bounceCSS_" + fileURL, (Object)fileContents);
        return "true";
    }

    private List loadFiles(List exampleFiles) {
        Perl5Util perl5 = new Perl5Util();
        Iterator i = exampleFiles.iterator();
        while (i.hasNext()) {
            DataTypeMap exampleFile = new DataTypeMap((Map)i.next());
            exampleFile.remove("error");
            String url = exampleFile.getString("url");
            String dataSource = exampleFile.getString("dataSource");
            boolean eval = exampleFile.getBoolean((Object)"doEval", true);
            boolean external = exampleFile.getBoolean((Object)"external", false);
            boolean showSource = exampleFile.getBoolean((Object)"showSource", true);
            if (dataSource != null || url != null && url.endsWith(".ds.xml")) {
                exampleFile.put("isDataSource", new Boolean(true));
            }
            if ((external || !eval) && !showSource) continue;
            try {
                String path = null;
                if (dataSource != null && dataSource.indexOf(".") != -1) {
                    url = dataSource;
                }
                if (url != null) {
                    path = ISCFile.canonicalizePath(this.examplesDir + "/" + url);
                } else if (dataSource != null) {
                    path = DataStructCache.getInstanceFile(dataSource, "datasources", "DS");
                    if (path == null) {
                        throw new Exception("Couldn't find dataSource: " + dataSource);
                    }
                    String comparePath = ISCFile.canonicalizePath(path);
                    if (!comparePath.equals(webRoot + "/examples/shared/ds/" + dataSource + ".ds.xml")) {
                        if (this.devenv) {
                            String sdkWebRoot = config.getPath("sdkWebRoot");
                            String path1 = sdkWebRoot + "/examples/shared/ds/" + dataSource + ".ds.xml";
                            path1 = new File(path1).getCanonicalPath();
                            String path2 = sdkWebRoot + "/shared/ds/" + dataSource + ".ds.xml";
                            path2 = new File(path2).getCanonicalPath();
                            if (!(comparePath.equals(path1) || comparePath.equals(path2) || comparePath.equals(this.examplesDir))) {
                                String partialPath = sdkWebRoot + "/examples/shared/ds";
                                if (!comparePath.startsWith(partialPath = new File(partialPath).getCanonicalPath()) && !comparePath.startsWith(partialPath = ISCFile.canonicalizePath(new File(this.examplesDir).getCanonicalPath()))) {
                                    throw new Exception("Access to datasource: " + dataSource + " denied - at path: " + comparePath + ".  You must place your datasource either directly in SDKPackage/webroot/shared/ds or in SDKPackage/webroot/examples/shared/ds or a subpath of that folder, or in a subpath of the examples directory itself,  for it to be loadable by the FeatureExplorer");
                                }
                            }
                        } else {
                            String partialPath = webRoot + "/examples/shared/ds";
                            if (!comparePath.startsWith(partialPath) && !comparePath.startsWith(partialPath = ISCFile.canonicalizePath(new File(this.examplesDir).getCanonicalPath()))) {
                                this.log.warn("Access to datasource: " + dataSource + " DENIED - at path: " + comparePath + " - must be in: " + webRoot + "/examples/shared/ds or  a subpath of that folder,  or in a subpath of the examples directory " + partialPath + " for Feature Explorer to serve it");
                                throw new Exception("Couldn't find dataSource: " + dataSource);
                            }
                        }
                    }
                } else {
                    throw new Exception("Couldn't find url or dataSource in: " + DataTools.prettyPrint((Object)exampleFile));
                }
                if (path.indexOf("..") != -1) {
                    throw new Exception("Derived relative path to example: " + path + " refusing to serve.");
                }
                ISCFile file = ISCFile.newInstance(path);
                String fileContents = DataTools.fileContentsAsString(file, config.defaultCharset());
                if (fileContents.indexOf("//>FEStrip") != -1) {
                    Perl5Util regex = new Perl5Util();
                    fileContents = regex.substitute("s|(<!--)?//>FEStrip.*?//<FEStrip(-->)?||gs", fileContents);
                }
                exampleFile.put("fileContents", fileContents);
                if (!eval || external || !perl5.match("/^\\s*</", fileContents)) continue;
                if (Boolean.TRUE.equals(exampleFile.getBoolean("isDataSource"))) {
                    DataSource ds = DataSource.fromXML(fileContents);
                    exampleFile.put("xmlToJS", JSTranslater.get().toJS(ds));
                } else {
                    exampleFile.put("xmlToJS", this.convertToJS(fileContents));
                }
                exampleFile.put("isXML", new Boolean(true));
            }
            catch (Exception e) {
                exampleFile.put("error", e.toString());
                exampleFile.put("error", e.toString());
                String exampleFilesAsJS = null;
                try {
                    exampleFilesAsJS = DataTools.prettyPrint(exampleFiles);
                }
                catch (Exception ee) {
                    exampleFilesAsJS = ee.toString();
                }
                this.log.error((Object)("Error during loadFiles processing - exampleFiles: " + exampleFilesAsJS), e);
            }
        }
        return exampleFiles;
    }

    private String convertToJS(String xml) throws Exception {
        StringWriter sw = new StringWriter();
        SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(xml), "</isomorphicXML>");
        XML.toJS(reader, (Writer)sw).freeResources();
        return sw.toString();
    }
}

