/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.util.DataTools;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class PreCache
extends BaseServlet {
    private static boolean started = false;
    private static boolean cachingFinished = false;

    public static boolean isCachingFinished() {
        return cachingFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Class<PreCache> clazz = PreCache.class;
        synchronized (PreCache.class) {
            if (started) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            started = true;
            Config iscConfig = Config.getGlobal();
            if (iscConfig.getBoolean((Object)"datasources.preCacheOnStartup", true)) {
                this.log.info("Isomorphic PreCache servlet loading");
                long start = System.currentTimeMillis();
                try {
                    this.preLoadDataSources();
                }
                catch (Exception e) {
                    this.log.warn("Problem during PreCache: " + DataTools.getStackTrace(e));
                }
                long end = System.currentTimeMillis();
                this.log.info("Isomorphic PreCache complete (" + (end - start) + "ms)");
            } else {
                this.log.info("Isomorphic PreCache disabled in config - not precaching.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            cachingFinished = true;
            return;
        }
    }

    public void preLoadDataSources() throws Exception {
        String[] dsNames = new String[]{"DataSource", "DataSourceField", "Validator", "ValueMap", "InstantDataApp", "IDAPage", "IDAUserType", "IDAOperation", "IDAComponent", "ComponentButton", "Canvas", "Img", "Button", "ListViewer", "ListViewerField", "DynamicForm", "FormItem", "DetailViewer", "DetailViewerField", "isomorphicXML"};
        for (int i = 0; i < dsNames.length; ++i) {
            String dsName = dsNames[i];
            this.log.debug("Preloading DataSource: " + dsName);
            DataSource ds = DataSourceManager.getDataSource(dsName, null);
            DataSourceManager.freeDataSource(ds);
        }
    }
}

