/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.AdvancedCriteriaHandler;
import com.isomorphic.velocity.DataSourcesHandler;
import com.isomorphic.velocity.HttpAttributeHandler;
import com.isomorphic.velocity.HttpParameterHandler;
import com.isomorphic.velocity.ISCReferenceInsertionEventHandler;
import com.isomorphic.velocity.ResponseDataHandler;
import com.isomorphic.velocity.ResponsesHandler;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Velocity
extends Base {
    private static Logger log = new Logger(Velocity.class.getName());
    private static VelocityEngine vEngine;
    private static Boolean haveVelocityTools;
    private static Object toolManager;

    public static synchronized VelocityEngine getEngine() throws Exception {
        if (vEngine != null) {
            return vEngine;
        }
        Properties velocityEngineDefaults = new Properties();
        velocityEngineDefaults.put("file.resource.loader.path", "");
        String defaultLogSystems = DataTools.join(new String[]{"org.apache.velocity.runtime.log.Log4JLogChute", "org.apache.velocity.runtime.log.CommonsLogLogChute", "org.apache.velocity.runtime.log.JdkLogChute", "org.apache.velocity.slf4j.Slf4jLogChute"}, ",");
        velocityEngineDefaults.put("runtime.log.logsystem.class", defaultLogSystems);
        velocityEngineDefaults.put("runtime.log.logsystem.log4j.logger", "org.apache.Velocity");
        Properties velocityEngineProperties = new Properties(velocityEngineDefaults);
        ISCFile velocityConfigFile = ISCFile.newInstance(DataTools.resourceFromClassLoader("velocity.properties"));
        if (velocityConfigFile.exists()) {
            log.info("Applying Velocity Engine configuration from: " + velocityConfigFile.getCanonicalPath());
            velocityEngineProperties.load(velocityConfigFile.getInputStream());
        }
        log.debug("Velocity config: " + DataTools.prettyPrint(velocityEngineProperties));
        vEngine = new VelocityEngine();
        vEngine.init(velocityEngineProperties);
        return vEngine;
    }

    public static synchronized Context getContext(Map props) {
        Context toolContext = null;
        if (config.getBoolean((Object)"velocity.tools.enabled", true)) {
            if (haveVelocityTools == null) {
                try {
                    toolManager = Reflection.instantiateClass("org.apache.velocity.tools.ToolManager");
                    Reflection.invokeMethod(toolManager, "setVelocityEngine", Velocity.getEngine());
                    haveVelocityTools = new Boolean(true);
                    log.info("Velocity Tools available, support enabled.");
                }
                catch (Exception e) {
                    haveVelocityTools = new Boolean(false);
                    log.info("Velocity Tools not available - using standard Velocity Contexts.");
                }
            }
            if (haveVelocityTools.booleanValue()) {
                try {
                    toolContext = (Context)Reflection.invokeMethod(toolManager, "createContext");
                }
                catch (Exception e) {
                    log.error((Object)"Unable to initialize Velocity ToolManager - using standard Velocity Context instead", e);
                }
            }
        }
        VelocityContext vContext = props == null ? new VelocityContext(toolContext) : new VelocityContext(props, toolContext);
        return vContext;
    }

    public static synchronized Object evaluateTemplateFile(String fileName, Map parameters) throws Exception {
        ISCFile file = ISCFile.newInstance(DataTools.makePathAbsolute(fileName));
        return Velocity.evaluate(file.getAsString(), parameters);
    }

    public static synchronized String evaluateTemplateFileAsString(String fileName, Map parameters) throws Exception {
        Object obj = Velocity.evaluateTemplateFile(fileName, parameters);
        return obj == null ? null : obj.toString();
    }

    public static synchronized String evaluateAsString(String template, Map parameters) throws Exception {
        Object obj = Velocity.evaluate(template, parameters);
        return obj == null ? null : obj.toString();
    }

    public static synchronized Object evaluate(String template, Map parameters) throws Exception {
        return Velocity.evaluate(template, parameters, "notProvided", null, false, false);
    }

    public static synchronized String evaluateAsString(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues) throws Exception {
        return Velocity.evaluateAsString(template, parameters, operationName, ds, quoteValues, false);
    }

    public static synchronized String evaluateAsString(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull) throws Exception {
        Object obj = Velocity.evaluate(template, parameters, operationName, ds, quoteValues, failureMeansNull);
        return obj == null ? null : obj.toString();
    }

    public static synchronized Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues) throws Exception {
        return Velocity.evaluate(template, parameters, operationName, ds, quoteValues, false);
    }

    public static synchronized Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull) throws Exception {
        if (template == null) {
            throw new NullPointerException("The template String provided for Velocity evaluation is null. Operation name is '" + operationName + "'");
        }
        StringWriter out = new StringWriter();
        Context context = Velocity.getContext(parameters);
        ISCReferenceInsertionEventHandler handler = new ISCReferenceInsertionEventHandler(context, ds, quoteValues);
        if (!Velocity.getEngine().evaluate(context, (Writer)out, operationName, template)) {
            return null;
        }
        if (handler.foundObject != null && handler.foundObject.toString().equals(out.toString())) {
            return handler.foundObject;
        }
        if (failureMeansNull && handler.nullReferences && template.equals(out.toString())) {
            return null;
        }
        return out.toString();
    }

    public static synchronized Boolean evaluateBooleanExpression(String template, Map parameters) throws Exception {
        return Velocity.evaluateBooleanExpression(template, parameters, "notProvided", null);
    }

    public static synchronized Boolean evaluateBooleanExpression(String template, Map parameters, String operationName, DataSource ds) throws Exception {
        Object obj2 = null;
        Object obj = Velocity.evaluate(template, parameters, operationName, ds, true, false);
        if (!(obj != null && (obj instanceof Boolean || obj.toString().trim().toLowerCase().equals("true") || obj.toString().trim().toLowerCase().equals("false") || obj.toString().trim().toLowerCase().equals("'true'") || obj.toString().trim().toLowerCase().equals("'false'")))) {
            String postEval = obj.toString();
            if (template.indexOf("'true'") == -1) {
                postEval = postEval.replaceAll("'true'", "true");
            }
            if (template.indexOf("'false'") == -1) {
                postEval = postEval.replaceAll("'false'", "false");
            }
            String wrappedTemplate = "#if(" + postEval + ") true #else false #end";
            try {
                obj = Velocity.evaluate(wrappedTemplate, parameters, operationName, ds, true, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj.toString().trim().toLowerCase().equals("true")) {
                return Boolean.TRUE;
            }
            if (obj.toString().trim().toLowerCase().equals("'true'")) {
                return Boolean.TRUE;
            }
            if (obj.toString().trim().toLowerCase().equals("false")) {
                return Boolean.FALSE;
            }
            if (obj.toString().trim().toLowerCase().equals("'false'")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static Map<Object, Object> getStandardContextMap(DSRequest dsReq) {
        return Velocity.getStandardContextMap(dsReq, null);
    }

    public static Map<Object, Object> getStandardContextMap(DSRequest dsReq, String fieldName) {
        if (dsReq == null) {
            return new HashMap<Object, Object>();
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (dsReq.getDsTransaction() != null) {
            context.putAll(dsReq.getDsTransaction().getTemplateContext());
            context.put("responseData", new ResponseDataHandler(dsReq.getDsTransaction()));
            context.put("responses", new ResponsesHandler(dsReq.getDsTransaction()));
        } else {
            Date currentDate = new Date();
            context.put("currentDate", currentDate);
            context.put("transactionDate", currentDate);
        }
        HashMap criteria = dsReq.getCriteria() != null ? new HashMap(dsReq.getCriteria()) : new HashMap();
        HashMap values = dsReq.getValues() != null ? new HashMap(dsReq.getValues()) : new HashMap();
        context.put("criteria", criteria);
        context.put("values", values);
        context.put("dsRequest", dsReq);
        context.put("primaryDSRequest", dsReq.getPrimaryDSRequest());
        context.put("dataSources", new DataSourcesHandler(dsReq));
        context.put("advancedCriteria", new AdvancedCriteriaHandler(dsReq));
        context.putAll(Velocity.getServletContextMap(dsReq.context));
        context.put("util", new DataTools());
        context.put("userId", dsReq.getUserId());
        Velocity.setMasterIdHandler(context, dsReq, fieldName);
        if (dsReq.getTemplateContext() != null) {
            for (Object subCriteria : dsReq.getTemplateContext().keySet()) {
                String key = (String)subCriteria;
                if (context.get(key) != null) {
                    log.warning("DSRequest-specified a template context variable: " + key + " collides with derived key of the same name - using the DSRequest-specified value.");
                }
                context.put(key, dsReq.getTemplateContext().get(key));
            }
        }
        return context;
    }

    public static void setMasterIdHandler(Map context, DSRequest dsReq, String fieldName) {
        if (fieldName == null) {
            return;
        }
        try {
            context.put("masterId", dsReq.getMasterId(fieldName, false));
        }
        catch (Exception e) {
            log.warn("Error trying to obtain masterId for DataSource " + dsReq.getDataSourceName() + ", field " + fieldName);
        }
    }

    public static Map getServletContextMap(RPCManager rpc) {
        if (rpc == null) {
            return new HashMap();
        }
        return Velocity.getServletContextMap(rpc.getContext());
    }

    public static Map getServletContextMap(RequestContext reqContext) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        if (reqContext != null) {
            escRequest = new ServletRequestAttributeMapFacade((HttpServletRequest)reqContext.request);
            if (reqContext.request != null) {
                escSession = new SessionAttributeMapFacade(reqContext.request.getSession());
            }
        }
        context.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        context.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        context.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (escRequest != null) {
            context.put("servletRequest", escRequest);
        }
        if (escSession != null) {
            context.put("session", escSession);
        }
        return context;
    }

    public static Map getServletContextMap(HttpServletRequest req) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        escRequest = new ServletRequestAttributeMapFacade(req);
        if (req != null) {
            escSession = new SessionAttributeMapFacade(req.getSession());
        }
        context.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        context.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        context.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (escRequest != null) {
            context.put("servletRequest", escRequest);
        }
        if (escSession != null) {
            context.put("session", escSession);
        }
        return context;
    }

    static {
        haveVelocityTools = null;
        toolManager = null;
    }
}

