/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSFileSpec {
    private static Logger log = new Logger(DSFileSpec.class.getName());
    protected String dsName;
    protected String dsFileName;
    protected String dsFileType;
    protected String dsFileFormat;
    protected DSRequest requestContext;
    private DataSource ds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() throws Exception {
        if (this.ds == null) {
            DataStructCache.disableDsPaths();
            try {
                if (this.requestContext == null) {
                    this.ds = DataSourceManager.getDataSource(this.dsName);
                } else {
                    this.ds = this.requestContext.getCachedDataSourceInstance(this.dsName);
                    if (this.ds == null) {
                        this.ds = DataSourceManager.getDataSource(this.dsName, this.requestContext);
                        this.requestContext.cacheDataSourceInstance(this.dsName, this.ds);
                    }
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DataStructCache.enableDsPaths();
                throw throwable;
            }
            DataStructCache.enableDsPaths();
            {
            }
        }
        return this.ds;
    }

    private void freeDataSource() {
        if (this.requestContext == null) {
            DataSourceManager.freeDataSource(this.ds);
            this.ds = null;
        }
    }

    public DSFileSpec(String dsName, String dsFileName) {
        this.dsName = dsName;
        this.dsFileName = dsFileName;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType) {
        this(dsName, dsFileName);
        this.dsFileType = dsFileType;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType, String dsFileFormat) {
        this(dsName, dsFileName, dsFileType);
        this.dsFileFormat = dsFileFormat;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType, String dsFileFormat, DSRequest request) {
        this(dsName, dsFileName, dsFileType, dsFileFormat);
        this.requestContext = request;
    }

    public DSFileSpec(Map record) {
        this.dsFileName = (String)record.get("fileName");
        this.dsFileType = (String)record.get("fileType");
        this.dsFileFormat = (String)record.get("fileFormat");
    }

    public DSFileSpec(String dsName, Map record) {
        this(record);
        this.dsName = dsName;
    }

    public DSFileSpec(String dsName, Map record, DSRequest request) {
        this(record);
        this.dsName = dsName;
        this.requestContext = request;
    }

    public DSFileSpec(String url) {
        this(url, (DSRequest)null);
    }

    public DSFileSpec(String url, DSRequest request) {
        String fullPath;
        String remainder;
        this.requestContext = request;
        if (url.startsWith("ds://")) {
            remainder = StringUtils.removeStart((String)url, (String)"ds://");
            this.dsName = StringUtils.substringBefore((String)remainder, (String)"/");
            fullPath = StringUtils.substringAfter((String)remainder, (String)"/");
        } else if (url.startsWith("ds:/")) {
            remainder = StringUtils.removeStart((String)url, (String)"ds:/");
            this.dsName = StringUtils.substringBefore((String)remainder, (String)"/");
            fullPath = StringUtils.substringAfter((String)remainder, (String)"/");
        } else {
            fullPath = url;
        }
        Map<String, Object> parsed = ISCFile.parseFileExtensions(fullPath);
        this.dsFileName = (String)parsed.get("fileName");
        this.dsFileType = (String)parsed.get("fileType");
        this.dsFileFormat = (String)parsed.get("fileFormat");
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String name) {
        this.dsName = name;
    }

    public DSRequest getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(DSRequest context) {
        this.requestContext = context;
    }

    public String getFileName() {
        return this.dsFileName;
    }

    public void setFileName(String name) {
        this.dsFileName = name;
    }

    public String getFileType() {
        return this.dsFileType;
    }

    public void setFileType(String type) {
        this.dsFileType = type;
    }

    public String getFileFormat() {
        return this.dsFileFormat;
    }

    public void setFileFormat(String format) {
        this.dsFileFormat = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        try {
            List<Map<String, Object>> results = this.getDataSource().removeFile(this);
            boolean bl = results != null && results.size() > 0;
            Object var4_5 = null;
            this.freeDataSource();
            return bl;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                boolean bl = false;
                Object var4_6 = null;
                this.freeDataSource();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        try {
            boolean bl = this.getDataSource().hasFile(this);
            Object var4_3 = null;
            this.freeDataSource();
            return bl;
        }
        catch (Exception ex) {
            try {
                boolean bl = false;
                Object var4_4 = null;
                this.freeDataSource();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReader() {
        try {
            Reader reader = this.getDataSource().getFile(this);
            Object var4_3 = null;
            this.freeDataSource();
            return reader;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                Reader reader = null;
                Object var4_4 = null;
                this.freeDataSource();
                return reader;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        try {
            InputStream inputStream = this.getDataSource().getFileAsInputStream(this);
            Object var4_3 = null;
            this.freeDataSource();
            return inputStream;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                InputStream inputStream = null;
                Object var4_4 = null;
                this.freeDataSource();
                return inputStream;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    public Writer getWriter() {
        return new DSFileSpecWriter();
    }

    public OutputStream getOutputStream() {
        return new DSFileSpecOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(Object contents) throws Exception {
        try {
            this.getDataSource().saveFile(this, contents);
            Object var3_2 = null;
            this.freeDataSource();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.freeDataSource();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        try {
            long l = this.getDataSource().getFileSize(this);
            Object var5_3 = null;
            this.freeDataSource();
            return l;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                long l = -1L;
                Object var5_4 = null;
                this.freeDataSource();
                return l;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        try {
            long l = this.getDataSource().getFileLastModified(this);
            Object var5_3 = null;
            this.freeDataSource();
            return l;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                long l = 0L;
                Object var5_4 = null;
                this.freeDataSource();
                return l;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    public boolean setLastModified(long time) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTo(DSFileSpec destination) {
        try {
            this.getDataSource().renameFile(this, destination);
            boolean bl = true;
            Object var5_4 = null;
            this.freeDataSource();
            return bl;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                boolean bl = false;
                Object var5_5 = null;
                this.freeDataSource();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> readAttributes() throws Exception {
        List<Map<String, Object>> list;
        block4: {
            try {
                list = this.getDataSource().listFiles(this.getPrimaryKeys(), this.requestContext);
                if (list.size() != 0) break block4;
                Map<String, Object> map = null;
                Object var4_4 = null;
                this.freeDataSource();
                return map;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
        if (list.size() > 1) {
            log.warn("readAttributes found multiple files, returning first");
        }
        Map<String, Object> map = list.get(0);
        Object var4_5 = null;
        this.freeDataSource();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        try {
            List<Map<String, Object>> results;
            List<Map<String, Object>> list = results = this.getDataSource().listFiles(criteria, request);
            Object var6_5 = null;
            this.freeDataSource();
            return list;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.freeDataSource();
            throw throwable;
        }
    }

    public List<DSFileSpec> findChildren(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        List<Map<String, Object>> attributes = this.findChildAttributes(criteria, request);
        ArrayList<DSFileSpec> results = new ArrayList<DSFileSpec>(attributes.size());
        for (Map map : attributes) {
            results.add(new DSFileSpec(this.dsName, map, request));
        }
        return results;
    }

    public DSFileSpec getChild(Map<String, Object> primaryKeys, DSRequest request) {
        return new DSFileSpec(this.dsName, primaryKeys, request);
    }

    public Map<String, Object> getPrimaryKeys() {
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        String fileName = this.getFileName();
        String fileType = this.getFileType();
        String fileFormat = this.getFileFormat();
        if (fileName != null) {
            primaryKeys.put("fileName", fileName);
        }
        if (fileType != null) {
            primaryKeys.put("fileType", fileType);
        }
        if (fileFormat != null) {
            primaryKeys.put("fileFormat", fileFormat);
        }
        return primaryKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.dsName != null) {
            sb.append("ds://");
            sb.append(this.dsName);
        }
        if (this.dsFileName != null) {
            sb.append('/');
            sb.append(this.dsFileName);
            if (this.dsFileType != null) {
                sb.append('.');
                sb.append(this.dsFileType);
            }
            if (this.dsFileFormat != null) {
                sb.append('.');
                sb.append(this.dsFileFormat);
            }
        }
        return sb.toString();
    }

    protected class DSFileSpecOutputStream
    extends ByteArrayOutputStream {
        private boolean flushed = false;

        protected DSFileSpecOutputStream() {
        }

        public void flush() throws IOException {
            super.flush();
            this.flushed = true;
            try {
                DSFileSpec.this.saveFile(this.toByteArray());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void close() throws IOException {
            if (!this.flushed) {
                this.flush();
            }
            super.close();
        }
    }

    protected class DSFileSpecWriter
    extends StringWriter {
        private boolean flushed = false;

        protected DSFileSpecWriter() {
        }

        public void flush() {
            super.flush();
            this.flushed = true;
            try {
                DSFileSpec.this.saveFile(this.toString());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void close() throws IOException {
            if (!this.flushed) {
                this.flush();
            }
            super.close();
        }
    }
}

