/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.util.LocaleMessage;
import com.isomorphic.xml.XML;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.w3c.dom.Element;

public class ValueMap
extends BasicDataSource {
    private static Logger log = new Logger(ValueMap.class.getName());

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data instanceof Map) {
            return data;
        }
        if (data instanceof List) {
            return data;
        }
        if (!(data instanceof Element)) {
            return data;
        }
        Element element = (Element)data;
        LinkedMap valueMap = new LinkedMap();
        List children = XML.getElementChildren(element);
        boolean gotIDMapping = false;
        if (element.hasAttributes()) {
            gotIDMapping = true;
            XML.addAttributesToMap(element, (Map)valueMap);
        }
        for (Element child : children) {
            String ID = XML.getAttribute(child, "ID");
            if (ID == null) {
                ID = XML.getAttribute(child, "id");
            }
            Object value = null;
            boolean i18n = false;
            List valueElements = XML.getElementChildren(child);
            LocaleMessage localeMessage = XML.toLocaleMessage(child, context);
            if (localeMessage != null) {
                value = localeMessage;
                i18n = true;
            }
            if (!i18n) {
                value = !valueElements.isEmpty() ? DataSource.recordsFromXML(valueElements) : XML.toSimpleValue(child);
            }
            if (ID != null && value != null) {
                gotIDMapping = true;
                valueMap.put(ID, value);
                continue;
            }
            if (ID != null) {
                valueMap.put(ID, ID);
                continue;
            }
            if (value != null) {
                valueMap.put(value, value);
                continue;
            }
            valueMap.put("", "");
        }
        if (gotIDMapping) {
            return valueMap;
        }
        return new ArrayList(valueMap.values());
    }
}

