/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISCUrlFile
extends ISCFile {
    private static Logger log = new Logger(ISCUrlFile.class.getName());
    protected URL url;
    private static Boolean forceCloseConnection = null;

    protected ISCUrlFile(String filename, DSRequest request, boolean constructURL) throws IOException {
        super(filename, request);
        if (constructURL) {
            this.url = new URL(filename);
        }
    }

    public ISCUrlFile(String filename, DSRequest request) throws IOException {
        this(filename, request, true);
    }

    public ISCUrlFile(String path) throws IOException {
        this(path, null);
    }

    public ISCUrlFile(URL url, DSRequest request) {
        super(null, request);
        this.url = url;
    }

    public ISCUrlFile(URL url) {
        this(url, null);
    }

    @Override
    public Object getNativeHandler() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        block15: {
            InputStream is;
            block14: {
                if (this.url == null) {
                    return false;
                }
                is = null;
                is = this.getInputStream();
                if (is == null) break block14;
                boolean bl = true;
                Object var4_4 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
            Object var4_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block15;
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (IOException iOException) {
                    Object var4_6 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block15;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    @Override
    public String getCanonicalPath() {
        if (this.filename != null) {
            return this.filename;
        }
        return this.url.toExternalForm();
    }

    @Override
    public boolean canRead() {
        return this.url != null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.url == null) {
            return null;
        }
        return this.url.openConnection().getInputStream();
    }

    @Override
    public long length() throws IOException {
        if (this.url == null) {
            return 0L;
        }
        return this.url.openConnection().getContentLength();
    }

    @Override
    public boolean isURL() {
        try {
            if (this.url != null && this.url.openConnection() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isJarURL() {
        block12: {
            if (!this.isURL()) {
                return false;
            }
            inputStream = null;
            try {
                try {
                    url = new URL(this.url.toString());
                    connection = url.openConnection();
                    inputStream = connection.getInputStream();
                    if (!(connection instanceof JarURLConnection)) break block12;
                    var4_6 = true;
                    var6_7 = null;
                    if (inputStream == null) return var4_6;
                }
                catch (IOException e) {
                    var3_5 = false;
                    var6_9 = null;
                    if (inputStream == null) return var3_5;
                    try {
                        inputStream.close();
                        return var3_5;
                    }
                    catch (Exception var7_13) {
                        // empty catch block
                    }
                    return var3_5;
                }
            }
            catch (Throwable var5_15) {
                var6_10 = null;
                if (inputStream == null) throw var5_15;
                ** try [egrp 2[TRYBLOCK] [5 : 80->87)] { 
lbl31:
                // 1 sources

                inputStream.close();
                throw var5_15;
lbl33:
                // 1 sources

                catch (Exception var7_14) {
                    // empty catch block
                }
                throw var5_15;
            }
            try {}
            catch (Exception var7_11) {
                // empty catch block
                return var4_6;
            }
            inputStream.close();
            return var4_6;
        }
        var6_8 = null;
        if (inputStream == null) return false;
        try {}
        catch (Exception var7_12) {}
        inputStream.close();
        return false;
        return false;
    }

    @Override
    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) throws IOException {
        if (request == null) {
            request = this.requestContext;
        }
        return this.getChild(ISCFile.expandFileExtensions(primaryKeys), request);
    }

    @Override
    public ISCFile getChild(String path, DSRequest request) throws IOException {
        if (request == null) {
            request = this.requestContext;
        }
        URL child = new URL(this.url, path);
        return new ISCUrlFile(this.url, request);
    }

    @Override
    public long lastModified() throws IOException {
        Config config;
        if (this.isJarURL() && (config = Config.getGlobal()) != null && config.getBoolean((Object)"file.permacacheJarURLs", false)) {
            return 0L;
        }
        if (this.url == null) {
            return 0L;
        }
        URLConnection urlConnection = this.url.openConnection();
        long lastModified = urlConnection.getLastModified();
        if (this.forceCloseConnection()) {
            try {
                urlConnection.getInputStream().close();
            }
            catch (Exception e) {
                log.warn((Object)"Exception during file connection closure", e);
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceCloseConnection() {
        if (forceCloseConnection != null) return forceCloseConnection;
        Class<ISCUrlFile> clazz = ISCUrlFile.class;
        synchronized (ISCUrlFile.class) {
            if (forceCloseConnection != null) return forceCloseConnection;
            Boolean flag = null;
            if (Config.getGlobal() != null) {
                flag = Config.getGlobal().getBoolean("file.forceCloseURLConnection");
            }
            if (flag == null) {
                Class wlVersion = null;
                try {
                    wlVersion = Reflection.classForName("weblogic.common.internal.Version");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                forceCloseConnection = wlVersion != null ? Boolean.TRUE : Boolean.FALSE;
            } else {
                forceCloseConnection = flag;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return forceCloseConnection;
        }
    }
}

