/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.hibernate.HibernateDSGenerator;
import com.isomorphic.hibernate.HibernateDataSource;
import com.isomorphic.jpa.JPA2DataSource;
import com.isomorphic.jpa.JPADataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.tools.BatchUpload;
import com.isomorphic.tools.DataSourceTools;
import com.isomorphic.tools.SQLImport;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinRPC
extends com.isomorphic.rpc.BuiltinRPC {
    public static DataSource getDataSourceFromTable(String tableName, String serverType, String dbName, String ID) throws Exception {
        return BuiltinRPC.getDataSourceFromTable(tableName, serverType, dbName, ID, null);
    }

    public static DataSource getDataSourceFromTable(String tableName, String serverType, String dbName, String ID, Map properties) throws Exception {
        if (ID == null) {
            ID = tableName;
        }
        DataSource ds = null;
        if ("hibernate".equals(serverType)) {
            ds = HibernateDSGenerator.fromTable((String)tableName, null, (String)ID);
        } else {
            Connection conn = SQLConnectionManager.getConnection((String)dbName);
            ds = SQLDataSource.fromTable((Connection)conn, (String)tableName, null, (String)ID, (String)"sql", (String)dbName, (Map)properties);
            SQLConnectionManager.free((Connection)conn);
        }
        return ds;
    }

    public static String getDataSourceJSONFromTable(String tableName, String serverType, String dbName, String ID, Map properties) throws Exception {
        DataSource ds = BuiltinRPC.getDataSourceFromTable(tableName, serverType, dbName, ID, properties);
        ds.getConfig().remove("__autoConstruct");
        StringWriter sw = new StringWriter();
        JSTranslater jst = JSTranslater.get();
        jst.enablePrettyPrinting(false);
        ds.toJSON((Writer)sw, jst);
        return sw.toString();
    }

    public static DataSource getDataSourceFromHibernateMapping(String entityName, String ID) throws Exception {
        if (ID == null) {
            ID = entityName;
        }
        return HibernateDSGenerator.fromMapping((String)entityName, (String)ID);
    }

    public static String getDataSourceJSONFromHibernateMapping(String entityName, String ID) throws Exception {
        DataSource ds = BuiltinRPC.getDataSourceFromHibernateMapping(entityName, ID);
        ds.getConfig().remove("__autoConstruct");
        StringWriter sw = new StringWriter();
        JSTranslater jst = JSTranslater.get();
        jst.enablePrettyPrinting(false);
        ds.toJSON((Writer)sw, jst);
        return sw.toString();
    }

    public static List getTables(String serverType, String dbName, boolean includeTables, boolean includeViews, String catalog, String schema, List include, List exclude) throws Exception {
        ArrayList<String> types = new ArrayList<String>();
        if (includeTables) {
            types.add("TABLE");
        }
        if (includeViews) {
            types.add("VIEW");
        }
        Connection conn = null;
        conn = "hibernate".equals(serverType) ? HibernateDataSource.getConnection() : SQLConnectionManager.getConnection((String)dbName);
        SQLMetaData md = new SQLMetaData(conn);
        List tables = md.getTableNamesAndRemarks(catalog, schema, types);
        if (include != null && include.size() > 0 || exclude != null && exclude.size() > 0) {
            Iterator i = tables.iterator();
            block0: while (i.hasNext()) {
                int j;
                Map map = (Map)i.next();
                String table = (String)map.get("TABLE_NAME");
                boolean match = false;
                if (table != null && include != null) {
                    for (j = 0; j < include.size(); ++j) {
                        if (table.toLowerCase().indexOf(include.get(j).toString().toLowerCase()) == -1) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        i.remove();
                    }
                }
                if (table == null || exclude == null) continue;
                for (j = 0; j < exclude.size(); ++j) {
                    if (table.toLowerCase().indexOf(exclude.get(j).toString().toLowerCase()) == -1) continue;
                    i.remove();
                    continue block0;
                }
            }
        }
        if ("hibernate".equals(serverType)) {
            HibernateDataSource.freeConnection((Connection)conn);
        } else {
            SQLConnectionManager.free((Connection)conn);
        }
        return tables;
    }

    public static List getFieldsFromTable(String tableName, String schema, String serverType, String dbName) throws Exception {
        Connection conn = null;
        conn = "hibernate".equals(serverType) ? HibernateDataSource.getConnection() : SQLConnectionManager.getConnection((String)dbName);
        List fields = SQLDataSource.getFieldsFromTable((Connection)conn, (String)tableName, (String)schema);
        if ("hibernate".equals(serverType)) {
            HibernateDataSource.freeConnection((Connection)conn);
        } else {
            SQLConnectionManager.free((Connection)conn);
        }
        return fields;
    }

    public static List getBeanFields(String className) throws Exception {
        return Reflection.getBeanFields((String)className);
    }

    public static List getHibernateBeans(List include, List exclude, boolean excludeNullMappings) throws Exception {
        List mappings = HibernateDSGenerator.getMappedClasses((boolean)excludeNullMappings);
        if (include != null && include.size() > 0 || exclude != null && exclude.size() > 0) {
            Iterator i = mappings.iterator();
            block0: while (i.hasNext()) {
                int j;
                Map map = (Map)i.next();
                String entity = (String)map.get("entityName");
                boolean match = false;
                if (entity != null && include != null) {
                    for (j = 0; j < include.size(); ++j) {
                        if (entity.toLowerCase().indexOf(include.get(j).toString().toLowerCase()) == -1) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        i.remove();
                    }
                }
                if (entity == null || exclude == null) continue;
                for (j = 0; j < exclude.size(); ++j) {
                    if (entity.toLowerCase().indexOf(exclude.get(j).toString().toLowerCase()) == -1) continue;
                    i.remove();
                    continue block0;
                }
            }
        }
        return mappings;
    }

    public static Map getDatabaseProductNameAndVersion(String serverType, String dbName) throws Exception {
        Connection conn = null;
        conn = "hibernate".equals(serverType) ? HibernateDataSource.getConnection() : SQLConnectionManager.getConnection((String)dbName);
        SQLMetaData md = new SQLMetaData(conn);
        Map map = md.getProductNameAndVersion();
        if ("hibernate".equals(serverType)) {
            HibernateDataSource.freeConnection((Connection)conn);
        } else {
            SQLConnectionManager.free((Connection)conn);
        }
        return map;
    }

    public static void setAttributes(String scope, Object attributes, String prefix, HttpServletRequest req) throws Exception {
        ArrayList<Object> attrList;
        Object rawAttrs = attributes;
        HashSet<String> iscAttrs = null;
        if ("session".equals(scope)) {
            Object iscAttrObj = req.getSession().getAttribute("_$iscAttrs");
            if (iscAttrObj != null && !(iscAttrObj instanceof Set)) {
                log.warn((Object)"Session attribute '_$iscAttrs' already exists, and is not a Set");
                return;
            }
            if (iscAttrObj != null && !((Set)iscAttrObj).contains("SmartClient Attribute Marker")) {
                log.warn((Object)"Session attribute '_$iscAttrs' already exists, marker is missing");
                return;
            }
            if (iscAttrObj == null) {
                iscAttrs = new HashSet<String>();
                iscAttrs.add("SmartClient Attribute Marker");
            } else {
                iscAttrs = (HashSet<String>)iscAttrObj;
            }
        }
        if (!(rawAttrs instanceof List)) {
            attrList = new ArrayList<Object>();
            attrList.add(rawAttrs);
        } else {
            attrList = (ArrayList<Object>)rawAttrs;
        }
        for (Map map : attrList) {
            String name = (String)map.get("name");
            String type = (String)map.get("type");
            Object value = map.get("value");
            if (name == null) {
                if (map.size() == 1) {
                    name = (String)map.keySet().toArray()[0];
                    value = map.get(name);
                }
            } else if ("boolean".equals(type)) {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                if (!(value instanceof Boolean)) {
                    value = new Boolean(value.toString());
                }
            } else if ("integer".equals(type) || "intEnum".equals(type) || "sequence".equals(type)) {
                if (!(value instanceof Integer)) {
                    try {
                        value = new Integer(value.toString());
                    }
                    catch (NumberFormatException ignored) {
                        value = value.toString();
                    }
                }
            } else if ("float".equals(type)) {
                if (!(value instanceof Double)) {
                    try {
                        value = new Double(value.toString());
                    }
                    catch (NumberFormatException ignored) {
                        value = value.toString();
                    }
                }
            } else if ("date".equals(type)) {
                if (!(value instanceof Date)) {
                    value = new SimpleDateFormat().parse(value.toString());
                }
            } else if (value != null) {
                value = value.toString();
            }
            if (prefix != null) {
                name = prefix + name;
            }
            if ("session".equals(scope)) {
                req.getSession().setAttribute(name, value);
                iscAttrs.add(name);
                continue;
            }
            req.setAttribute(name, value);
        }
        if ("session".equals(scope)) {
            req.getSession().setAttribute("_$iscAttrs", iscAttrs);
        }
    }

    public void clearAttributes(HttpSession session) throws Exception {
        Object iscAttrObj = session.getAttribute("_$iscAttrs");
        if (iscAttrObj == null) {
            log.warn((Object)"clearAttributes - no attribute named '_$iscAttrs' was found in session scope");
            return;
        }
        if (!(iscAttrObj instanceof Set)) {
            log.warn((Object)"clearAttributes - _$iscAttrs is not a Set");
            return;
        }
        Set iscAttrs = (Set)iscAttrObj;
        if (!iscAttrs.contains("SmartClient Attribute Marker")) {
            log.warn((Object)"clearAttributes - marker is missing from _$iscAttrs");
            return;
        }
        iscAttrs.remove("SmartClient Attribute Marker");
        for (String attrName : iscAttrs) {
            session.removeAttribute(attrName);
        }
        session.removeAttribute("_$iscAttrs");
    }

    public static List getAttributes(HttpServletRequest req) throws Exception {
        ArrayList attrs = new ArrayList();
        Object iscAttrObj = req.getSession().getAttribute("_$iscAttrs");
        if (iscAttrObj == null) {
            log.warn((Object)"getAttributes - no attribute named '_$iscAttrs' was found in session");
            return null;
        }
        if (!(iscAttrObj instanceof Set)) {
            log.warn((Object)"getAttributes - _$iscAttrs is not a Set");
            return null;
        }
        Set iscAttrs = (Set)iscAttrObj;
        if (!iscAttrs.contains("SmartClient Attribute Marker")) {
            log.warn((Object)"getAttributes - marker is missing from _$iscAttrs");
            return null;
        }
        for (String attrName : iscAttrs) {
            if ("SmartClient Attribute Marker".equals(attrName)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object attrVal = req.getSession().getAttribute(attrName);
            map.put(attrName, attrVal);
            attrs.add(map);
        }
        return attrs;
    }

    public static Map getAttribute(String scope, String attrName, HttpServletRequest req) throws Exception {
        Object attrVal;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("session".equals(scope)) {
            Object iscAttrObj = req.getSession().getAttribute("_$iscAttrs");
            if (iscAttrObj == null) {
                log.warn((Object)"getAttribute - no attribute named '_$iscAttrs' was found in session");
                return null;
            }
            if (!(iscAttrObj instanceof Set)) {
                log.warn((Object)"getAttribute - _$iscAttrs is not a Set");
                return null;
            }
            Set iscAttrs = (Set)iscAttrObj;
            if (!iscAttrs.contains("SmartClient Attribute Marker")) {
                log.warn((Object)"getAttribute - marker is missing from _$iscAttrs");
                return null;
            }
            if (!iscAttrs.contains(attrName)) {
                log.warn((Object)("getAttribute - attempted to retrieve attribute " + attrName + ", which was not originally populated bby the client"));
                map.put("error", "You cannot retrieve an attribute you did not set");
                return map;
            }
            attrVal = req.getSession().getAttribute(attrName);
        } else {
            attrVal = req.getAttribute(attrName);
        }
        map.put(attrName, attrVal);
        return map;
    }

    public static RPCResponse getDataSourceConfigFromJavaClass(String className) throws Exception {
        Object dsConfig = null;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            dsConfig = DataSourceTools._getDataSourceConfigFromJavaClass(className);
        }
        catch (ClassNotFoundException e) {
            dsConfig = "Class not found " + className;
        }
        responseData.put("dsConfig", dsConfig);
        return new RPCResponse(responseData);
    }

    public static RPCResponse loadDataSource(String dsName) throws Exception {
        return new RPCResponse((Object)DataSourceManager.get((String)dsName));
    }

    public static RPCResponse dsFromXML(String xml) throws Exception {
        return new RPCResponse((Object)DataSource.fromXML((String)xml));
    }

    public static RPCResponse dsConfigFromXML(String xml) throws Exception {
        return new RPCResponse((Object)DataSource.fromXML((String)xml).getConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getDefinedDataSourceIdentifiers() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List dsList = SQLImport.getFullDSList(config.getCommaSeparatedList((Object)"project.datasources", new ArrayList()));
        Config dsConfig = config.getSubtree("datasources");
        for (String key : dsConfig.keySet()) {
            String dsName;
            if (!key.endsWith(".location") || dsList.contains(dsName = key.substring(0, key.indexOf(".")))) continue;
            dsList.add(dsName);
        }
        for (String dsName : dsList) {
            result.add(dsName);
            String defaultAuditId = "audit_" + dsName;
            DataSource ds = null;
            try {
                ds = DataSourceManager.getDataSource((String)dsName, null);
                if (ds == null) {
                    log.warn((Object)("Couldn't load config-defined datasource: " + dsName));
                    continue;
                }
                if (!Boolean.TRUE.equals(ds.getConfig().get("audit"))) continue;
                String overriddenId = (String)ds.getConfig().get("auditDataSourceID");
                result.add(overriddenId != null ? overriddenId : defaultAuditId);
            }
            catch (Exception e) {
                log.warn((Object)("Error looking up audit datasource on datasource with id '" + dsName + "'"), (Throwable)e);
            }
            finally {
                try {
                    DataSourceManager.freeDataSource((DataSource)ds);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDefinedDataSourcesAsList() throws Exception {
        Set<String> dsList = BuiltinRPC.getDefinedDataSourceIdentifiers();
        ArrayList dsRows = new ArrayList();
        for (String dsName : dsList) {
            log.debug((Object)("Loading DS: " + dsName));
            HashMap<String, Object> dsRow = new HashMap<String, Object>();
            DataSource ds = null;
            try {
                String dsType;
                block29: {
                    Map so;
                    Object serverConstructor;
                    ds = DataSourceManager.getDataSource((String)dsName, null);
                    if (ds == null) {
                        log.warn((Object)("Couldn't load config-defined datasource: " + dsName));
                        continue;
                    }
                    dsRow.put("dsName", dsName);
                    dsType = ds.getType();
                    if (dsType == null) {
                        dsType = "generic";
                    }
                    if ((serverConstructor = ds.getConfig().get("serverConstructor")) != null) {
                        try {
                            Class<?> c = Class.forName(String.valueOf(serverConstructor));
                            if (SQLDataSource.class.isAssignableFrom(c) && !c.equals(SQLDataSource.class)) {
                                dsType = c.getSimpleName() + " (SQLDataSource)";
                                break block29;
                            }
                            if (HibernateDataSource.class.isAssignableFrom(c) && !c.equals(HibernateDataSource.class)) {
                                dsType = c.getSimpleName() + " (HibernateDataSource)";
                                break block29;
                            }
                            if (JPADataSource.class.isAssignableFrom(c) && !c.equals(JPADataSource.class) && !c.equals(JPA2DataSource.class)) {
                                dsType = c.getSimpleName() + " (JPADataSource)";
                                break block29;
                            }
                            throw new Exception();
                        }
                        catch (Exception e) {
                            dsType = "generic";
                        }
                    } else if (dsType.equals("generic") && ((so = ds.getServerObjectConfig()) != null || !DataTools.getProperty((List)ds.getOperationBindings(), (Object)"serverObject").isEmpty())) {
                        dsType = "dmi";
                    }
                }
                boolean usesSCServerProtocol = ds.usesSCServerProtocol();
                dsRow.put("usesSCServerProtocol", usesSCServerProtocol);
                if (!usesSCServerProtocol) {
                    Map cfg = ds.getConfig();
                    dsRow.put("serviceNamespace", cfg.get("serviceNamespace"));
                    dsRow.put("constructor", cfg.get("constructor"));
                    dsRow.put("dataProtocol", cfg.get("dataProtocol"));
                }
                dsRow.put("dsType", dsType);
                String configFilename = ds.getConfigFilename();
                if (configFilename == null) {
                    configFilename = "In Memory";
                }
                dsRow.put("filename", configFilename);
                String testFilename = ds.getTestFileName();
                if (testFilename != null) {
                    dsRow.put("testData", "yes");
                    dsRow.put("testDataFilename", testFilename);
                } else {
                    dsRow.put("testData", "no");
                    dsRow.put("testDataFilename", "N/A");
                }
                dsRows.add(dsRow);
            }
            catch (Exception e) {
                log.error((Object)("Couldn't load DataSource: " + dsName), (Throwable)e);
            }
            finally {
                try {
                    DataSourceManager.freeDataSource((DataSource)ds);
                }
                catch (Exception exception) {}
            }
        }
        return dsRows;
    }

    public static RPCResponse getDefinedDataSources(RequestContext context) throws Exception {
        RPCResponse result = new RPCResponse();
        String webRoot = RequestContext.config.getPath("webRoot");
        if (DataTools.isContainerIOPath((String)webRoot)) {
            result.setStatus(-1);
            result.setData((Object)"Container IO");
            return result;
        }
        result.setData((Object)BuiltinRPC.getDefinedDataSourcesAsList());
        return result;
    }

    public RPCResponse importData(RequestContext context, Object values) throws Exception {
        DSRequest request = new DSRequest("batchUpload", "update");
        request.setValues(values);
        request.setRequestContext(context);
        DSResponse response = BatchUpload.internalBatchUpload(request, true);
        return new RPCResponse(response.getData());
    }

    public RPCResponse checkForTestData(RequestContext context, Object values) throws Exception {
        String dsName = (String)((Map)values).get("dsName");
        DSRequest request = new DSRequest();
        request.setRequestContext(context);
        DataSource ds = DataSourceManager.getDataSource((String)dsName, (DSRequest)request);
        String fileName = ds.getTestFileName();
        return new RPCResponse((Object)(fileName != null && fileName.length() > 0 && new File(fileName).exists() ? 1 : 0));
    }
}

