/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.net.URL;
import java.util.Map;

public class HtmlMeta
extends HtmlElement {
    public static final String TAG_NAME = "meta";

    HtmlMeta(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        if ("set-cookie".equalsIgnoreCase(this.getHttpEquivAttribute())) {
            this.performSetCookie();
        }
    }

    protected void performSetCookie() {
        SgmlPage page = this.getPage();
        WebClient client = page.getWebClient();
        URL url = page.getUrl();
        client.addCookie(this.getContentAttribute(), url, this);
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    public final String getHttpEquivAttribute() {
        return this.getAttribute("http-equiv");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getContentAttribute() {
        return this.getAttribute("content");
    }

    public final String getSchemeAttribute() {
        return this.getAttribute("scheme");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_FRAMESET_INLINE)) {
            return HtmlElement.DisplayStyle.INLINE;
        }
        return HtmlElement.DisplayStyle.NONE;
    }
}

