/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSelectElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.IE)})})
public class HTMLOptionsCollection
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private HtmlSelect htmlSelect_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLOptionsCollection() {
    }

    public HTMLOptionsCollection(SimpleScriptable parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_SELECT_CLASS_NAME)) {
            return "HTMLSelectElement";
        }
        return super.getClassName();
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0) {
            if (index < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_ITEM_THROWS_IF_NEGATIVE)) {
                throw Context.reportRuntimeError((String)("Invalid index for option collection: " + index));
            }
            return Context.getUndefinedValue();
        }
        if (index >= this.htmlSelect_.getOptionSize()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_NULL_FOR_OUTSIDE)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return this.getScriptableFor(this.htmlSelect_.getOption(index));
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, (String)name)) {
            ScriptableObject.putProperty((Scriptable)parent, (String)name, (Object)value);
        } else {
            super.put(name, start, value);
        }
    }

    @Override
    public Object getWithFallback(String name) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_CHILDNODES_PROPERTY) && "childNodes".equals(name)) {
            return NOT_FOUND;
        }
        if (this.htmlSelect_ == null) {
            return NOT_FOUND;
        }
        HTMLSelectElement select = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        return ScriptableObject.getProperty((Scriptable)select, (String)name);
    }

    @JsxFunction
    public Object item(int index) {
        return this.get(index, null);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = (HtmlOption)option.getDomNodeOrNull();
            if (index >= this.getLength()) {
                this.setLength(index);
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
    }

    @JsxGetter
    public int getLength() {
        return this.htmlSelect_.getOptionSize();
    }

    @JsxSetter
    public void setLength(int newLength) {
        if (newLength < 0) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_IGNORE_NEGATIVE_LENGTH)) {
                return;
            }
            throw Context.reportRuntimeError((String)"Length is negative");
        }
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)HTMLParser.getFactory("option").createElement(this.htmlSelect_.getPage(), "option", null);
                this.htmlSelect_.appendOption(option);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_DONT_ADD_EMPTY_TEXT_CHILD_WHEN_EXPANDING)) continue;
                option.appendChild(new DomText(option.getPage(), ""));
            }
        }
    }

    @JsxFunction
    public void add(Object newOptionObject, Object beforeOptionObject) {
        int index = this.getLength();
        HtmlOption htmlOption = (HtmlOption)((HTMLOptionElement)newOptionObject).getDomNodeOrNull();
        HtmlOption beforeOption = null;
        if (beforeOptionObject instanceof Number) {
            index = (Integer)Context.jsToJava((Object)beforeOptionObject, Integer.class);
            if (index < 0 || index >= this.getLength()) {
                this.htmlSelect_.appendOption(htmlOption);
                return;
            }
            beforeOption = (HtmlOption)((HTMLOptionElement)this.item(index)).getDomNodeOrDie();
        } else if (beforeOptionObject instanceof HTMLOptionElement && (beforeOption = (HtmlOption)((HTMLOptionElement)beforeOptionObject).getDomNodeOrDie()).getParentNode() != this.htmlSelect_) {
            throw new EvaluatorException("Unknown option.");
        }
        if (null == beforeOption) {
            this.htmlSelect_.appendOption(htmlOption);
            return;
        }
        beforeOption.insertBefore(htmlOption);
    }

    @JsxFunction
    public void remove(int index) {
        int idx = index;
        BrowserVersion browser = this.getBrowserVersion();
        if (idx < 0) {
            if (browser.hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_IGNORE_IF_INDEX_NEGATIVE)) {
                return;
            }
            if (index < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_THROWS_IF_NEGATIV)) {
                throw Context.reportRuntimeError((String)("Invalid index for option collection: " + index));
            }
        }
        if ((idx = Math.max(idx, 0)) >= this.getLength()) {
            if (browser.hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_IGNORE_IF_INDEX_TOO_LARGE)) {
                return;
            }
            idx = 0;
        }
        this.htmlSelect_.removeOption(idx);
    }
}

