/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLActiveXObjectFactory;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.WebResponseWrapper;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

@JsxClass
public class XMLHttpRequest
extends EventTarget {
    private static final Log LOG = LogFactory.getLog(XMLHttpRequest.class);
    public static final int STATE_UNSENT = 0;
    public static final int STATE_OPENED = 1;
    public static final int STATE_HEADERS_RECEIVED = 2;
    public static final int STATE_LOADING = 3;
    public static final int STATE_DONE = 4;
    private static final String HEADER_ORIGIN = "Origin";
    private static final char REQUEST_HEADERS_SEPARATOR = ',';
    private static final String HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ALLOW_ORIGIN_ALL = "*";
    private static final String[] ALL_PROPERTIES_ = new String[]{"onreadystatechange", "readyState", "responseText", "responseXML", "status", "statusText", "abort", "getAllResponseHeaders", "getResponseHeader", "open", "send", "setRequestHeader"};
    private static Collection<String> PROHIBITED_HEADERS_ = Arrays.asList("accept-charset", "accept-encoding", "connection", "content-length", "cookie", "cookie2", "content-transfer-encoding", "date", "expect", "host", "keep-alive", "referer", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "via");
    private int state_;
    private Function stateChangeHandler_;
    private Function loadHandler_;
    private Function errorHandler_;
    private WebRequest webRequest_;
    private boolean async_;
    private int jobID_;
    private WebResponse webResponse_;
    private String overriddenMimeType_;
    private HtmlPage containingPage_;
    private final boolean caseSensitiveProperties_;
    private boolean withCredentials_;

    @JsxConstructor
    public XMLHttpRequest() {
        this(true);
    }

    public XMLHttpRequest(boolean caseSensitiveProperties) {
        this.caseSensitiveProperties_ = caseSensitiveProperties;
        this.state_ = 0;
    }

    @JsxGetter
    public Function getOnreadystatechange() {
        return this.stateChangeHandler_;
    }

    @JsxSetter
    public void setOnreadystatechange(Function stateChangeHandler) {
        this.stateChangeHandler_ = stateChangeHandler;
        if (this.state_ == 1) {
            this.setState(this.state_, null);
        }
    }

    private void setState(int state, Context context) {
        boolean triggerOnload;
        boolean triggerForSyncCompleted;
        this.state_ = state;
        BrowserVersion browser = this.getBrowserVersion();
        boolean noTriggerForSync = browser.hasFeature(BrowserVersionFeatures.XHR_ONREADYSTATECANGE_SYNC_REQUESTS_NOT_TRIGGERED);
        boolean bl = triggerForSyncCompleted = state == 4 && browser.hasFeature(BrowserVersionFeatures.XHR_ONREADYSTATECANGE_SYNC_REQUESTS_COMPLETED);
        if (this.stateChangeHandler_ != null && (this.async_ || !noTriggerForSync || triggerForSyncCompleted)) {
            Scriptable scope = this.stateChangeHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling onreadystatechange handler for state " + state));
            }
            Object[] params = ArrayUtils.EMPTY_OBJECT_ARRAY;
            if (browser.hasFeature(BrowserVersionFeatures.XHR_ONREADYSTATECHANGE_WITH_EVENT_PARAM)) {
                params = new Object[1];
                Event event = new Event(this, "readystatechange");
                params[0] = event;
            }
            jsEngine.callFunction(this.containingPage_, this.stateChangeHandler_, scope, (Scriptable)this, params);
            if (LOG.isDebugEnabled()) {
                if (context == null) {
                    context = Context.getCurrentContext();
                }
                LOG.debug((Object)("onreadystatechange handler: " + context.decompileFunction(this.stateChangeHandler_, 4)));
                LOG.debug((Object)("Calling onreadystatechange handler for state " + state + ". Done."));
            }
        }
        if ((triggerOnload = browser.hasFeature(BrowserVersionFeatures.XHR_TRIGGER_ONLOAD_ON_COMPLETED)) && this.loadHandler_ != null && state == 4) {
            Scriptable scope = this.loadHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction(this.containingPage_, this.loadHandler_, scope, (Scriptable)this, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Function getOnload() {
        return this.loadHandler_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void setOnload(Function loadHandler) {
        this.loadHandler_ = loadHandler;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF)})
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    private void processError(Context context) {
        if (this.errorHandler_ != null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ERRORHANDLER_NOT_SUPPORTED)) {
            Scriptable scope = this.errorHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Calling onerror handler");
            }
            jsEngine.callFunction(this.containingPage_, this.errorHandler_, (Scriptable)this, scope, ArrayUtils.EMPTY_OBJECT_ARRAY);
            if (LOG.isDebugEnabled()) {
                if (context == null) {
                    context = Context.getCurrentContext();
                }
                LOG.debug((Object)("onerror handler: " + context.decompileFunction(this.errorHandler_, 4)));
                LOG.debug((Object)"Calling onerror handler done.");
            }
        }
    }

    @JsxGetter
    public int getReadyState() {
        return this.state_;
    }

    @JsxGetter
    public String getResponseText() {
        if (this.state_ == 0 || this.state_ == 1) {
            return "";
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getContentAsString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"XMLHttpRequest.responseText was retrieved before the response was available.");
        }
        return "";
    }

    @JsxGetter
    public Object getResponseXML() {
        if (this.webResponse_ == null) {
            return null;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            return null;
        }
        String contentType = this.webResponse_.getContentType();
        if (contentType.isEmpty() || contentType.contains("xml")) {
            WebWindow webWindow = this.getWindow().getWebWindow();
            try {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_RESPONSE_XML_IS_ACTIVEXOBJECT)) {
                    XmlPage page = new XmlPage(this.webResponse_, webWindow, true, false);
                    MSXMLActiveXObjectFactory factory = webWindow.getWebClient().getMSXMLActiveXObjectFactory();
                    XMLDOMDocument document = (XMLDOMDocument)factory.create("Microsoft.XMLDOM", webWindow);
                    document.setDomNode(page);
                    return document;
                }
                XmlPage page = new XmlPage(this.webResponse_, webWindow);
                XMLDocument document = new XMLDocument();
                document.setPrototype(this.getPrototype(document.getClass()));
                document.setParentScope(this.getWindow());
                document.setDomNode(page);
                return document;
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed parsing XML document " + this.webResponse_.getWebRequest().getUrl() + ": " + e.getMessage()));
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("XMLHttpRequest.responseXML was called but the response is " + this.webResponse_.getContentType()));
        }
        return null;
    }

    @JsxGetter
    public int getStatus() {
        if (this.state_ == 0 || this.state_ == 1) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_STATUS_THROWS_EXCEPTION_WHEN_UNSET)) {
                throw Context.reportRuntimeError((String)"status not set");
            }
            return 0;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        LOG.error((Object)("XMLHttpRequest.status was retrieved without a response available (readyState: " + this.state_ + ")."));
        return 0;
    }

    @JsxGetter
    public String getStatusText() {
        if (this.state_ == 0 || this.state_ == 1) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_STATUS_THROWS_EXCEPTION_WHEN_UNSET)) {
                throw Context.reportRuntimeError((String)"statusText not set");
            }
            return "";
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        LOG.error((Object)("XMLHttpRequest.statusText was retrieved without a response available (readyState: " + this.state_ + ")."));
        return null;
    }

    @JsxFunction
    public void abort() {
        this.getWindow().getWebWindow().getJobManager().stopJob(this.jobID_);
    }

    @JsxFunction
    public String getAllResponseHeaders() {
        if (this.state_ == 0 || this.state_ == 1) {
            return null;
        }
        if (this.webResponse_ != null) {
            StringBuilder buffer = new StringBuilder();
            for (NameValuePair header : this.webResponse_.getResponseHeaders()) {
                buffer.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            }
            return buffer.toString();
        }
        LOG.error((Object)("XMLHttpRequest.getAllResponseHeaders() was called without a response available (readyState: " + this.state_ + ")."));
        return null;
    }

    @JsxFunction
    public String getResponseHeader(String headerName) {
        if (this.state_ == 0 || this.state_ == 1) {
            return null;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getResponseHeaderValue(headerName);
        }
        LOG.error((Object)("XMLHttpRequest.getAllResponseHeaders(..) was called without a response available (readyState: " + this.state_ + ")."));
        return null;
    }

    @JsxFunction
    public void open(String method, Object urlParam, Object asyncParam, Object user, Object password) {
        if ((urlParam == null || "".equals(urlParam)) && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_OPEN_ALLOW_EMTPY_URL)) {
            throw Context.reportRuntimeError((String)"URL for XHR.open can't be empty!");
        }
        boolean async = true;
        if (asyncParam != Undefined.instance) {
            async = ScriptRuntime.toBoolean((Object)asyncParam);
        }
        if (!async && this.getWithCredentials() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_OPEN_WITHCREDENTIALS_TRUE_IN_SYNC_EXCEPTION)) {
            throw Context.reportRuntimeError((String)"open() in sync mode is not possible because 'withCredentials' is set to true");
        }
        String url = Context.toString((Object)urlParam);
        this.containingPage_ = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            boolean userIsNull;
            URL fullUrl = this.containingPage_.getFullyQualifiedUrl(url);
            URL originUrl = this.containingPage_.getFullyQualifiedUrl("");
            if (!this.isAllowCrossDomainsFor(originUrl, fullUrl)) {
                throw Context.reportRuntimeError((String)"Access to restricted URI denied");
            }
            WebRequest request = new WebRequest(fullUrl, this.getBrowserVersion().getXmlHttpRequestAcceptHeader());
            request.setCharset("UTF-8");
            request.setAdditionalHeader("Referer", this.containingPage_.getUrl().toExternalForm());
            if (!this.isSameOrigin(originUrl, fullUrl) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ORIGIN_HEADER)) {
                StringBuilder origin = new StringBuilder().append(originUrl.getProtocol()).append("://").append(originUrl.getHost());
                if (originUrl.getPort() != -1) {
                    origin.append(':').append(originUrl.getPort());
                }
                request.setAdditionalHeader(HEADER_ORIGIN, origin.toString());
            }
            try {
                request.setHttpMethod(HttpMethod.valueOf(method.toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException e) {
                LOG.info((Object)("Incorrect HTTP Method '" + method + "'"));
                return;
            }
            boolean bl = userIsNull = null == user || Undefined.instance == user;
            if (!userIsNull) {
                String userCred = user.toString();
                boolean passwordIsNull = null == password || Undefined.instance == password;
                String passwordCred = "";
                if (!passwordIsNull) {
                    passwordCred = password.toString();
                }
                request.setCredentials((Credentials)new UsernamePasswordCredentials(userCred, passwordCred));
            }
            this.webRequest_ = request;
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Unable to initialize XMLHttpRequest using malformed URL '" + url + "'."));
            return;
        }
        this.async_ = async;
        this.setState(1, null);
    }

    private boolean isAllowCrossDomainsFor(URL originUrl, URL newUrl) {
        BrowserVersion browser = this.getBrowserVersion();
        return !browser.hasFeature(BrowserVersionFeatures.XHR_NO_CROSS_ORIGIN_TO_ABOUT) || !"about".equals(newUrl.getProtocol());
    }

    private boolean isSameOrigin(URL originUrl, URL newUrl) {
        int newPort;
        if (!originUrl.getHost().equals(newUrl.getHost())) {
            return false;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_IGNORE_PORT_FOR_SAME_ORIGIN)) {
            return true;
        }
        int originPort = originUrl.getPort();
        if (originPort == -1) {
            originPort = originUrl.getDefaultPort();
        }
        if ((newPort = newUrl.getPort()) == -1) {
            newPort = newUrl.getDefaultPort();
        }
        return originPort == newPort;
    }

    @JsxFunction
    public void send(Object content) {
        if (this.webRequest_ == null) {
            return;
        }
        this.prepareRequest(content);
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        AjaxController ajaxController = client.getAjaxController();
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        boolean synchron = ajaxController.processSynchron(page, this.webRequest_, this.async_);
        if (synchron) {
            this.doSend(Context.getCurrentContext());
        } else {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_FIRE_STATE_OPENED_AGAIN_IN_ASYNC_MODE)) {
                this.setState(1, Context.getCurrentContext());
            }
            final Window startingScope = this.getWindow();
            HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
            ContextAction action = new ContextAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run(Context cx) {
                    Stack<Scriptable> stack = (Stack<Scriptable>)cx.getThreadLocal((Object)"startingScope");
                    if (null == stack) {
                        stack = new Stack<Scriptable>();
                        cx.putThreadLocal((Object)"startingScope", stack);
                    }
                    stack.push(startingScope);
                    try {
                        XMLHttpRequest.this.doSend(cx);
                    }
                    finally {
                        stack.pop();
                    }
                    return null;
                }
            };
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavascriptXMLHttpRequestJob(cf, action);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Starting XMLHttpRequest thread for asynchronous request");
            }
            this.jobID_ = this.getWindow().getWebWindow().getJobManager().addJob(job, page);
        }
    }

    private void prepareRequest(Object content) {
        String body;
        if (!(content == null || HttpMethod.POST != this.webRequest_.getHttpMethod() && HttpMethod.PUT != this.webRequest_.getHttpMethod() || Context.getUndefinedValue().equals(content) || (body = Context.toString((Object)content)).length() <= 0)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting request body to: " + body));
            }
            this.webRequest_.setRequestBody(body);
        }
    }

    private void doSend(Context context) {
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        try {
            boolean crossOriginResourceSharing;
            String originHeaderValue = this.webRequest_.getAdditionalHeaders().get(HEADER_ORIGIN);
            boolean bl = crossOriginResourceSharing = originHeaderValue != null;
            if (crossOriginResourceSharing && this.isPreflight()) {
                WebRequest preflightRequest = new WebRequest(this.webRequest_.getUrl(), HttpMethod.OPTIONS);
                preflightRequest.setAdditionalHeader(HEADER_ORIGIN, originHeaderValue);
                preflightRequest.setAdditionalHeader(HEADER_ACCESS_CONTROL_REQUEST_METHOD, this.webRequest_.getHttpMethod().name());
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
                    String name = header.getKey().toLowerCase(Locale.ENGLISH);
                    if (!this.isPreflightHeader(name, header.getValue())) continue;
                    if (builder.length() != 0) {
                        builder.append(',');
                    }
                    builder.append(name);
                }
                preflightRequest.setAdditionalHeader(HEADER_ACCESS_CONTROL_REQUEST_HEADERS, builder.toString());
                WebResponse preflightResponse = wc.loadWebResponse(preflightRequest);
                if (!this.isPreflightAuthorized(preflightResponse)) {
                    this.setState(2, context);
                    this.setState(3, context);
                    this.setState(4, context);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No permitted request for URL " + this.webRequest_.getUrl()));
                    }
                    Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("No permitted \"Access-Control-Allow-Origin\" header."));
                    return;
                }
            }
            WebResponse webResponse = wc.loadWebResponse(this.webRequest_);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Web response loaded successfully.");
            }
            boolean allowOriginResponse = true;
            if (crossOriginResourceSharing) {
                String value = webResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN);
                allowOriginResponse = originHeaderValue.equals(value);
                if (this.getWithCredentials()) {
                    allowOriginResponse = allowOriginResponse || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_WITHCREDENTIALS_ALLOW_ORIGIN_ALL) && ALLOW_ORIGIN_ALL.equals(value);
                    value = webResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS);
                    allowOriginResponse = allowOriginResponse && Boolean.parseBoolean(value);
                } else {
                    boolean bl2 = allowOriginResponse = allowOriginResponse || ALLOW_ORIGIN_ALL.equals(value);
                }
            }
            if (allowOriginResponse) {
                if (this.overriddenMimeType_ == null) {
                    this.webResponse_ = webResponse;
                } else {
                    int index = this.overriddenMimeType_.toLowerCase().indexOf("charset=");
                    String charsetString = "";
                    if (index != -1) {
                        charsetString = this.overriddenMimeType_.substring(index + "charset=".length());
                    }
                    final String charset = !charsetString.isEmpty() ? charsetString : null;
                    this.webResponse_ = new WebResponseWrapper(webResponse){

                        @Override
                        public String getContentType() {
                            return XMLHttpRequest.this.overriddenMimeType_;
                        }

                        @Override
                        public String getContentCharset() {
                            if (charset != null) {
                                return charset;
                            }
                            return super.getContentCharset();
                        }
                    };
                }
            }
            if (!allowOriginResponse) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No permitted \"Access-Control-Allow-Origin\" header for URL " + this.webRequest_.getUrl()));
                }
                throw new IOException("No permitted \"Access-Control-Allow-Origin\" header.");
            }
            this.setState(2, context);
            this.setState(3, context);
            this.setState(4, context);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IOException: returning a network error response.", (Throwable)e);
            }
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_);
            this.setState(2, context);
            this.setState(4, context);
            if (this.async_) {
                this.processError(context);
            }
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    private boolean isPreflight() {
        HttpMethod method = this.webRequest_.getHttpMethod();
        if (method != HttpMethod.GET && method != HttpMethod.PUT && method != HttpMethod.HEAD) {
            return true;
        }
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            if (!this.isPreflightHeader(header.getKey().toLowerCase(Locale.ENGLISH), header.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isPreflightAuthorized(WebResponse preflightResponse) {
        String originHeader = preflightResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN);
        if (!ALLOW_ORIGIN_ALL.equals(originHeader) && !this.webRequest_.getAdditionalHeaders().get(HEADER_ORIGIN).equals(originHeader)) {
            return false;
        }
        String headersHeader = preflightResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_HEADERS);
        headersHeader = headersHeader == null ? "" : headersHeader.toLowerCase(Locale.ENGLISH);
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            String key = header.getKey().toLowerCase(Locale.ENGLISH);
            if (!this.isPreflightHeader(key, header.getValue()) || headersHeader.contains(key)) continue;
            return false;
        }
        return true;
    }

    private boolean isPreflightHeader(String name, String value) {
        if ("content-type".equals(name)) {
            String lcValue = value.toLowerCase(Locale.ENGLISH);
            return !FormEncodingType.URL_ENCODED.getName().equals(lcValue) && !FormEncodingType.MULTIPART.getName().equals(lcValue) && !"text/plain".equals(lcValue) && !lcValue.startsWith("text/plain;charset=");
        }
        return !"accept".equals(name) && !"accept-language".equals(name) && !"content-language".equals(name) && !"referer".equals(name) && !"accept-encoding".equals(name) && !"origin".equals(name);
    }

    @JsxFunction
    public void setRequestHeader(String name, String value) {
        if (!XMLHttpRequest.isAuthorizedHeader(name)) {
            LOG.warn((Object)("Ignoring XMLHttpRequest.setRequestHeader for " + name + ": it is a restricted header"));
            return;
        }
        if (this.webRequest_ == null) {
            throw Context.reportRuntimeError((String)"The open() method must be called before setRequestHeader().");
        }
        this.webRequest_.setAdditionalHeader(name, value);
    }

    static boolean isAuthorizedHeader(String name) {
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (PROHIBITED_HEADERS_.contains(nameLowerCase)) {
            return false;
        }
        return !nameLowerCase.startsWith("proxy-") && !nameLowerCase.startsWith("sec-");
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void overrideMimeType(String mimeType) {
        this.overriddenMimeType_ = mimeType;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public boolean getWithCredentials() {
        return this.withCredentials_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void setWithCredentials(boolean withCredentials) {
        if (!this.async_ && this.state_ != 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_WITHCREDENTIALS_NOT_WRITEABLE_IN_SYNC_EXCEPTION)) {
            throw Context.reportRuntimeError((String)"Property 'withCredentials' not writable in sync mode.");
        }
        this.withCredentials_ = withCredentials;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        super.put(name, start, value);
    }

    private static final class NetworkErrorWebResponse
    extends WebResponse {
        private final WebRequest request_;

        private NetworkErrorWebResponse(WebRequest webRequest) {
            super(null, null, 0L);
            this.request_ = webRequest;
        }

        @Override
        public int getStatusCode() {
            return 0;
        }

        @Override
        public String getStatusMessage() {
            return "";
        }

        @Override
        public String getContentType() {
            return "";
        }

        @Override
        public String getContentAsString() {
            return "";
        }

        @Override
        public String getContentAsString(String encoding) {
            return "";
        }

        @Override
        public InputStream getContentAsStream() {
            return null;
        }

        @Override
        public List<NameValuePair> getResponseHeaders() {
            return Collections.emptyList();
        }

        @Override
        public String getResponseHeaderValue(String headerName) {
            return "";
        }

        @Override
        public long getLoadTime() {
            return 0L;
        }

        @Override
        public String getContentCharset() {
            return "";
        }

        @Override
        public String getContentCharsetOrNull() {
            return "";
        }

        @Override
        public WebRequest getWebRequest() {
            return this.request_;
        }
    }
}

