/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml.services.SmartClientOperations;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.services.SmartClientOperations.SmartClientOperationsPort;
import com.isomorphic.xml.services.SmartClientOperations.StatusCode;
import com.isomorphic.xml.services.SmartClientOperations.TransactionRequest;
import com.isomorphic.xml.services.SmartClientOperations.TransactionResponse;
import com.isomorphic.xml.services.SmartClientOperations.XMLRequest;
import com.isomorphic.xml.services.SmartClientOperations.XMLResponse;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Element;

public class SmartClientOperationsBindingImpl
implements SmartClientOperationsPort {
    private static Logger log = new Logger(SmartClientOperationsBindingImpl.class.getName());

    public XMLResponse fetch(XMLRequest dsRequest) throws RemoteException {
        return this.executeXMLRequest(dsRequest, "fetch");
    }

    public XMLResponse add(XMLRequest dsRequest) throws RemoteException {
        return this.executeXMLRequest(dsRequest, "add");
    }

    public XMLResponse remove(XMLRequest dsRequest) throws RemoteException {
        return this.executeXMLRequest(dsRequest, "remove");
    }

    public XMLResponse update(XMLRequest dsRequest) throws RemoteException {
        return this.executeXMLRequest(dsRequest, "update");
    }

    public TransactionResponse executeTransaction(TransactionRequest transaction) throws RemoteException {
        TransactionResponse transactionResponse = new TransactionResponse();
        transactionResponse.setTransactionNum(transaction.getTransactionNum());
        XMLRequest[] xmlRequests = transaction.getOperations();
        XMLResponse[] xmlResponses = new XMLResponse[xmlRequests.length];
        for (int i = 0; i < xmlRequests.length; ++i) {
            xmlResponses[i] = this.executeXMLRequest(xmlRequests[i], null);
        }
        return transactionResponse;
    }

    private XMLResponse executeXMLRequest(XMLRequest xmlRequest, String operationType) {
        try {
            DSRequest dsRequest = this.xmlRequestToDSRequest(xmlRequest);
            if (operationType != null) {
                dsRequest.setOperationType(operationType);
            }
            DSResponse dsResponse = dsRequest.execute();
            return this.dsResponseToXMLResponse(dsResponse);
        }
        catch (Exception e) {
            XMLResponse xmlResponse = new XMLResponse();
            xmlResponse.setStatus(StatusCode.STATUS_FAILURE);
            MessageElement[] anyList = new MessageElement[1];
            log.error((Object)"execution error", (Throwable)e);
            try {
                anyList[0] = new MessageElement(XML.collectionsToDOM((Object)e.toString(), (String)"data"));
            }
            catch (Exception ee) {
                log.error((Object)"Can't serialize error message", (Throwable)ee);
            }
            xmlResponse.set_any(anyList);
            return xmlResponse;
        }
    }

    private DSRequest xmlRequestToDSRequest(XMLRequest xmlRequest) throws Exception {
        MessageElement any;
        MessageElement[] anyList;
        String sortBy;
        Long endRow;
        DSRequest dsRequest = new DSRequest();
        HashMap<String, String> operationConfig = new HashMap<String, String>();
        dsRequest.setOperationId(xmlRequest.getOperationId());
        Long startRow = xmlRequest.getStartRow();
        if (startRow != null) {
            dsRequest.setStartRow(startRow.longValue());
        }
        if ((endRow = xmlRequest.getEndRow()) != null) {
            dsRequest.setEndRow(endRow.longValue());
        }
        if ((sortBy = xmlRequest.getSortBy()) != null) {
            dsRequest.setSortBy((Object)sortBy);
        }
        String operationType = xmlRequest.getOperationType();
        dsRequest.setOperationType(operationType);
        operationConfig.put("operationType", operationType);
        String dsName = xmlRequest.getDataSource();
        dsRequest.setDataSourceName(dsName);
        operationConfig.put("dataSource", dsName);
        String textMatchStyle = xmlRequest.getTextMatchStyle();
        if (textMatchStyle != null) {
            operationConfig.put("textMatchStyle", textMatchStyle);
        }
        if ((anyList = xmlRequest.get_any()) != null && (any = anyList[0]) != null) {
            Object data = XML.toDSRecords((Element)any.getAsDOM());
            dsRequest.setValues(data);
            dsRequest.setCriteria(data);
        }
        dsRequest.setOperationConfig(operationConfig);
        return dsRequest;
    }

    private XMLResponse dsResponseToXMLResponse(DSResponse dsResponse) throws Exception {
        XMLResponse xmlResponse = new XMLResponse();
        if (dsResponse.getStatus() != 1) {
            int status = dsResponse.getStatus();
            StatusCode xmlStatus = null;
            if (status == 0) {
                xmlStatus = StatusCode.STATUS_SUCCESS;
            }
            if (status == -1) {
                xmlStatus = StatusCode.STATUS_FAILURE;
            }
            if (status == -4) {
                xmlStatus = StatusCode.STATUS_VALIDATION_ERROR;
            }
            xmlResponse.setStatus(xmlStatus);
        } else {
            xmlResponse.setStatus(StatusCode.STATUS_SUCCESS);
        }
        if (dsResponse.getStatus() == -4) {
            MessageElement[] anyList = new MessageElement[1];
            List errors = dsResponse.getErrors();
            log.warn((Object)("Errors: " + DataTools.prettyPrint((Object)errors)));
            String xmlErrors = XML.collectionsToXMLString((Object)errors, (String)"errors");
            log.warn((Object)("Errors as XML: " + xmlErrors));
            anyList[0] = new MessageElement(XML.collectionsToDOM((Object)errors, (String)"errors"));
            xmlResponse.set_any2(anyList);
        }
        try {
            xmlResponse.setStartRow(new Long(dsResponse.getStartRow()));
        }
        catch (Exception anyList) {
            // empty catch block
        }
        try {
            xmlResponse.setEndRow(new Long(dsResponse.getEndRow()));
        }
        catch (Exception anyList) {
            // empty catch block
        }
        try {
            xmlResponse.setTotalRows(new Long(dsResponse.getTotalRows()));
        }
        catch (Exception anyList) {
            // empty catch block
        }
        try {
            xmlResponse.setInvalidateCache(new Boolean(dsResponse.getInvalidateCache()));
        }
        catch (Exception anyList) {
            // empty catch block
        }
        Object data = dsResponse.getData();
        if (data != null) {
            MessageElement[] anyList = new MessageElement[1];
            String xmlData = XML.collectionsToXMLString((Object)data, (String)"data");
            log.warn((Object)("dataAsXML: " + xmlData));
            anyList[0] = new MessageElement(XML.collectionsToDOM((Object)data, (String)"data"));
            xmlResponse.set_any(anyList);
        } else {
            xmlResponse.set_any(new MessageElement[0]);
        }
        return xmlResponse;
    }
}

