/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.mobile;

import com.opera.core.systems.EmulationProfile;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Dimension;

public class OperaMobileEmulation
implements EmulationProfile {
    private String profileName = null;
    private Dimension resolution = new Dimension(480, 800);
    private int ppi = 233;
    private EmulationProfile.IME input = EmulationProfile.IME.TOUCH;
    private UserAgent userAgent = UserAgent.ANDROID;

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public Dimension getResolution() {
        return this.resolution;
    }

    @Override
    public int getPPI() {
        return this.ppi;
    }

    @Override
    public EmulationProfile.IME getIME() {
        return this.input;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof EmulationProfile)) {
            return false;
        }
        EmulationProfile other = (EmulationProfile)o;
        return this.getProfileName().equals(other.getProfileName()) && this.getResolution().getHeight() == other.getResolution().getHeight() && this.getResolution().getWidth() == other.getResolution().getWidth() && this.getPPI() == other.getPPI() && this.getIME() == other.getIME() && this.getUserAgent().equals(other.getUserAgent());
    }

    public String toString() {
        return String.format("EmulationProfile [profileName=%s, width=%d, height=%d, ppi=%d, ime=%s, userAgent=%s]", this.getProfileName(), this.getResolution().getWidth(), this.getPPI(), this.getResolution().getHeight(), this.getIME().toString().toLowerCase(), this.getUserAgent());
    }

    public JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("profileName", (Object)this.getProfileName());
        json.put("width", this.getResolution().getWidth());
        json.put("height", this.getResolution().getHeight());
        json.put("ppi", this.getPPI());
        json.put("ime", (Object)this.getIME().toString().toLowerCase());
        json.put("userAgent", (Object)this.getUserAgent());
        return json;
    }

    public static EmulationProfile fromJson(JSONObject json) throws JSONException {
        return OperaMobileEmulation.builder().setProfileName(String.valueOf(json.get("profileName"))).setWidth(Integer.parseInt(String.valueOf(json.get("width")))).setHeight(Integer.parseInt(String.valueOf(json.get("height")))).setPPI(Integer.parseInt(String.valueOf(json.get("ppi")))).setIME(EmulationProfile.IME.valueOf(String.valueOf(json.get("ime")).toUpperCase())).setUserAgent(UserAgent.find(String.valueOf(json.get("userAgent")))).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final OperaMobileEmulation config = new OperaMobileEmulation();

        public Builder setProfileName(String profileName) {
            this.config.profileName = profileName;
            return this;
        }

        public Builder setResolution(Dimension resolution) {
            this.config.resolution = resolution;
            return this;
        }

        public Builder setResolution(int width, int height) {
            this.setResolution(new Dimension(width, height));
            return this;
        }

        public Builder setWidth(int width) {
            this.setResolution(new Dimension(width, this.config.getResolution().getHeight()));
            return this;
        }

        public Builder setHeight(int height) {
            this.setResolution(new Dimension(this.config.getResolution().getWidth(), height));
            return this;
        }

        public Builder setPPI(int ppi) {
            this.config.ppi = ppi;
            return this;
        }

        public Builder setIME(EmulationProfile.IME ime) {
            this.config.input = ime;
            return this;
        }

        public Builder setUserAgent(UserAgent userAgent) {
            this.config.userAgent = userAgent;
            return this;
        }

        public EmulationProfile build() {
            return this.config;
        }
    }

    public static enum UserAgent {
        ANDROID("Android"),
        DESKTOP("Desktop"),
        MEEGO("MeeGo"),
        S60("S60");

        private final String uaIdentifier;

        private UserAgent(String userAgentIdentifier) {
            this.uaIdentifier = userAgentIdentifier;
        }

        public String toString() {
            return this.uaIdentifier;
        }

        public static UserAgent find(String uaString) {
            for (UserAgent agent : UserAgent.values()) {
                if (!agent.toString().equalsIgnoreCase(uaString)) continue;
                return agent;
            }
            return null;
        }
    }
}

