/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.StreamingResponseIterator;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.sql.SQLTransform;
import com.isomorphic.sql.SQLWhereClause;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.LocaleMessage;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.collections.map.LinkedMap;

public abstract class SQLDriver
extends Base {
    private static Logger log = new Logger(SQLDriver.class.getName());
    protected static Perl5Util globalPerl = new Perl5Util();
    protected String dbName = null;
    protected SQLTable table = null;
    public Connection dbConnection = null;
    protected boolean quoteColumnNames;
    protected boolean useColumnLabelInMetadata;
    protected boolean useUTCDateTimes;
    protected SQLDataSource.SequenceMode lastSequenceMode;
    public static final int NO_CONVERSION = 0;
    public static final int TO_LOWERCASE = 1;
    public static final int TO_UPPERCASE = 2;
    private static final Map EMPTY_REMAP = new HashMap();
    public static DataTypeMap iscImplementerForType = new DataTypeMap(new LinkedHashMap());
    public static DataTypeMap iscTypeForImplementer = new DataTypeMap();
    private static final String TIMING_LOG_UNPAGED_FETCH = "Unpaged fetch";
    private static final String TIMING_LOG_GET_CONNECTION = "get connection";
    private static final String TIMING_LOG_QUERY = "query";
    private static final String TIMING_LOG_SQLTRANSFORM = "SQLTransform";
    protected SimpleDateFormat logicalDateFormatter;
    protected SimpleDateFormat logicalTimeFormatter;
    protected SimpleDateFormat utcDateTimeFormatter;
    protected SimpleDateFormat localDateTimeFormatter;
    protected SimpleDateFormat utcDateTimeMsFormatter;
    protected SimpleDateFormat localDateTimeMsFormatter;
    protected boolean useDistinctForGroupBy = true;
    protected Map jdbcPKs = new HashMap();
    private static String snapshotFileNamePrefix;

    public SQLDataSource.SequenceMode getLastSequenceMode() {
        return this.lastSequenceMode;
    }

    public void setLastSequenceMode(SQLDataSource.SequenceMode sequenceMode) {
        this.lastSequenceMode = sequenceMode;
    }

    protected void initDateFormatters() {
        String timeFormat;
        String dateFormat;
        String dateTimeMsFormat;
        String dateTimeFormat = config.getString((Object)("sql." + SQLDriver.getDBType(this.dbName) + ".defaultDateTimeFormat"));
        if (dateTimeFormat == null) {
            dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        }
        if ((dateTimeMsFormat = config.getString((Object)("sql." + SQLDriver.getDBType(this.dbName) + ".defaultDateTimeFormatWithMilliseconds"))) == null) {
            dateTimeMsFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if ((dateFormat = config.getString((Object)("sql." + SQLDriver.getDBType(this.dbName) + ".defaultDateFormat"))) == null) {
            dateFormat = "yyyy-MM-dd";
        }
        if ((timeFormat = config.getString((Object)("sql." + SQLDriver.getDBType(this.dbName) + ".defaultTimeFormat"))) == null) {
            timeFormat = dateTimeFormat;
        }
        this.utcDateTimeFormatter = new SimpleDateFormat(dateTimeFormat);
        this.utcDateTimeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.localDateTimeFormatter = new SimpleDateFormat(dateTimeFormat);
        this.utcDateTimeMsFormatter = new SimpleDateFormat(dateTimeMsFormat);
        this.utcDateTimeMsFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.localDateTimeMsFormatter = new SimpleDateFormat(dateTimeMsFormat);
        this.logicalDateFormatter = new SimpleDateFormat(dateFormat);
        this.logicalTimeFormatter = new SimpleDateFormat(timeFormat);
    }

    protected SimpleDateFormat getLocalDateTimeFormatter() {
        return this.localDateTimeFormatter;
    }

    protected SimpleDateFormat getUTCDateTimeFormatter() {
        return this.utcDateTimeFormatter;
    }

    protected SimpleDateFormat getLocalDateTimeMsFormatter() {
        return this.localDateTimeMsFormatter;
    }

    protected SimpleDateFormat getUTCDateTimeMsFormatter() {
        return this.utcDateTimeMsFormatter;
    }

    protected SimpleDateFormat getLogicalDateFormatter() {
        return this.logicalDateFormatter;
    }

    protected SimpleDateFormat getLogicalTimeFormatter() {
        return this.logicalTimeFormatter;
    }

    public String openQuote() {
        return "\"";
    }

    public String closeQuote() {
        return "\"";
    }

    public String getQualifiedSchemaSeparator() {
        return ".";
    }

    public String sequencePrefix() {
        return config.getString((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.prefix"), "");
    }

    public String sequenceSuffix() {
        return config.getString((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.suffix"), "");
    }

    public int maxSequenceNameLength() {
        return config.getInt((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.maxLength"), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeConnection() {
        block9: {
            try {
                if (this.dbConnection == null) break block9;
                Connection connection = this.dbConnection;
                synchronized (connection) {
                    if (!this.dbConnection.isClosed()) {
                        log.debug((Object)("Freeing SQLDriver dbConnection " + this.dbConnection.hashCode() + " for SQLDriver instance " + ((Object)((Object)this)).hashCode()));
                        SQLConnectionManager.free(this.dbConnection);
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception freeing the SQLDriver dbConnection", (Throwable)e);
            }
            finally {
                this.dbConnection = null;
            }
        }
    }

    public void finalize() throws Throwable {
        this.freeConnection();
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public Connection getOrCreateConnection() throws SQLException {
        if (this.dbConnection == null) {
            this.dbConnection = SQLConnectionManager.getConnection(this.dbName);
        }
        return this.dbConnection;
    }

    public SQLDriver(String dbName, SQLTable table) throws Exception {
        this.dbName = dbName;
        this.table = table;
        this.quoteColumnNames = config.getBoolean((Object)("sql." + config.getString((Object)("sql." + dbName + ".database.type")) + ".quoteColumnNames"), false);
        this.useColumnLabelInMetadata = config.getBoolean((Object)("sql." + config.getString((Object)("sql." + dbName + ".database.type")) + ".useColumnLabelInMetadata"), false);
        this.useUTCDateTimes = config.getBoolean((Object)("sql." + dbName + ".useUTCDateTimes"), false);
        this.initDateFormatters();
    }

    public SQLDriver(String dbName) throws Exception {
        this(dbName, null);
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBType() {
        return SQLDriver.getDBType(this.dbName);
    }

    public boolean useColumnLabelInMetadata() {
        return this.useColumnLabelInMetadata;
    }

    public static String getDBType(String dbName) {
        return config.getString((Object)("sql." + dbName + ".database.type"));
    }

    public SQLTable getTable() {
        return this.table;
    }

    public static SQLDriver instance() throws Exception {
        return SQLDriver.instance(Config.getGlobal().getString((Object)"sql.defaultDatabase"));
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return (SQLDriver)((Object)Reflection.invokeStaticMethod((String)SQLDriver.implementerClassForDB(dbName), (String)"instance", (Object)dbName, (Object)((Object)table)));
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return (SQLDriver)((Object)Reflection.invokeStaticMethod((String)SQLDriver.implementerClassForDB(dbName), (String)"instance", (Object)dbName));
    }

    public static SQLDriver instance(String dbName, String dbType) throws Exception {
        return (SQLDriver)((Object)Reflection.invokeStaticMethod((String)SQLDriver.implementerClassForDBType(dbType), (String)"instance", (Object)dbName));
    }

    public static SQLDriver instance(String dbName, String dbType, SQLTable table) throws Exception {
        return (SQLDriver)((Object)Reflection.invokeStaticMethod((String)SQLDriver.implementerClassForDBType(dbType), (String)"instance", (Object)dbName, (Object)((Object)table)));
    }

    protected static String implementerClassForDB(String dbName) throws Exception {
        String implementerClass;
        String dbType = null;
        dbType = "::hibernate::".equals(dbName) ? "::hibernate::" : config.getString((Object)("sql." + dbName + ".database.type"));
        if (dbType == null) {
            SQLConnectionManager.free(SQLConnectionManager.getConnection(dbName));
            dbType = config.getString((Object)("sql." + dbName + ".database.type"));
        }
        if ((implementerClass = iscImplementerForType.getString((Object)dbType)) == null) {
            throw new Exception("Unable to find implementer for database: " + dbName + " - declared to be type: " + dbType);
        }
        return implementerClass;
    }

    protected static String implementerClassForDBType(String dbType) throws Exception {
        String implementerClass = iscImplementerForType.getString((Object)dbType);
        if (implementerClass == null) {
            throw new Exception("Unable to find implementer for database type: " + dbType);
        }
        return implementerClass;
    }

    public static List getTransformedResults(String query, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, null, req);
    }

    public static List getTransformedResults(String query, String dbName, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, null, dbName, null, req);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, conn, dbName, driver, null, req, null);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, List dataSources, DSRequest req, DSResponse resp) throws Exception {
        return SQLDriver.getTransformedResults(query, conn, dbName, driver, dataSources, null, req, resp);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, List dataSources, Map opConfig, DSRequest req, DSResponse result) throws Exception {
        Connection workingConn;
        boolean closeConnection = false;
        boolean userOrAutoTransaction = true;
        Connection userOrAutoConn = null;
        if (req != null) {
            req.recordTimingData(TIMING_LOG_UNPAGED_FETCH, DSRequest.TimingLogType.START);
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
            if (req.getDsTransaction() != null) {
                SQLDataSource ds = (SQLDataSource)req.getDataSource();
                userOrAutoConn = ds.getTransactionalConnection(req);
            }
        }
        if (userOrAutoConn == null) {
            if (dbName == null) {
                dbName = config.getString((Object)"sql.defaultDatabase");
            }
            if (conn == null) {
                if (driver != null && driver.dbConnection != null) {
                    conn = driver.dbConnection;
                    closeConnection = false;
                }
                if (conn == null) {
                    conn = SQLConnectionManager.getConnection(dbName);
                    closeConnection = true;
                }
                if (driver != null && driver.dbConnection == null) {
                    driver.dbConnection = conn;
                    closeConnection = false;
                }
            } else if (driver != null) {
                if (driver.dbConnection != null && driver.dbConnection != conn) {
                    SQLConnectionManager.free(driver.dbConnection);
                }
                driver.dbConnection = conn;
            }
            userOrAutoTransaction = false;
            workingConn = conn;
        } else {
            workingConn = userOrAutoConn;
        }
        if (req != null) {
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
        }
        Statement s = null;
        ResultSet rs = null;
        boolean streaming = req != null && req.shouldStreamResults();
        int batchSize = req == null ? 0 : (int)req.getBatchSize();
        try {
            if (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                log.info((Object)("Executing SQL query on '" + dbName + "' using connection '" + workingConn.hashCode() + "'"), (Object)query);
            }
            s = driver == null ? workingConn.createStatement() : driver.createFetchStatement(workingConn, streaming, batchSize);
            long start = System.currentTimeMillis();
            if (req != null) {
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
            }
            rs = s.executeQuery(query);
            if (req != null) {
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
            }
            if (streaming) {
                log.debug((Object)"Streaming the response");
                result.setData((Object)new StreamingResponseIterator(result));
                HashMap<String, Object> sContext = new HashMap<String, Object>();
                sContext.put("resultSet", rs);
                sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                sContext.put("dataSources", dataSources);
                sContext.put("opConfig", opConfig);
                sContext.put("dsRequest", req);
                result.setStreamingContext(sContext);
                result.setStartRow(req.getStartRow());
                result.setEndRow(req.getStartRow());
                result._setHasNextRecord(rs.next());
                List list = null;
                return list;
            }
            start = System.currentTimeMillis();
            if (req != null) {
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
            }
            List data = SQLTransform.toListOfMapsOrBeans(rs, SQLTransform.hasBrokenCursorAPIs(dbName), dataSources, opConfig, req);
            if (req != null) {
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
            }
            List list = data;
            return list;
        }
        catch (SQLException se) {
            if (!userOrAutoTransaction) {
                if (config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                    log.info((Object)("Execute of select: " + query + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying query."));
                }
                SQLConnectionManager.free(conn, true);
                conn = SQLConnectionManager.getNewConnection(dbName);
                if (driver != null) {
                    driver.dbConnection = conn;
                }
                s = driver == null ? conn.createStatement() : driver.createFetchStatement(conn, streaming, batchSize);
                rs = s.executeQuery(query);
                List list = SQLTransform.toListOfMapsOrBeans(rs, SQLTransform.hasBrokenCursorAPIs(dbName), dataSources, opConfig);
                return list;
            }
            throw se;
        }
        finally {
            if (!streaming) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    s.close();
                }
                catch (Exception exception) {}
                if (req != null) {
                    req.recordTimingData(TIMING_LOG_UNPAGED_FETCH, DSRequest.TimingLogType.END);
                }
            }
        }
    }

    public static Object getScalarResult(String query, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, null, req);
    }

    public static Object getScalarResult(String query, String dbName, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, null, dbName, null, req);
    }

    public static Object getScalarResult(String query, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        List list = SQLDriver.getTransformedResults(query, conn, dbName, driver, req);
        if (list == null || list.size() == 0) {
            return null;
        }
        Map map = (Map)list.get(0);
        return map.get(DataTools.getSingle((Object)map));
    }

    public static int update(String update, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, req);
    }

    public static int update(String update, String dbName, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, dbName, req);
    }

    public static int update(String update, List data, String dbName, DSRequest req) throws Exception {
        return SQLDriver.update(update, data, SQLConnectionManager.getConnection(dbName), dbName, null, req);
    }

    protected static int update(String update, List data, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        Connection workingConn;
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        boolean userOrAutoTransaction = true;
        Connection userOrAutoConn = null;
        if (req != null && req.getDsTransaction() != null) {
            SQLDataSource ds = (SQLDataSource)req.getDataSource();
            userOrAutoConn = ds.getTransactionalConnection(req);
        } else {
            log.info((Object)"DSRequest has no DSTransaction set, when testing if we should join a transaction - transaction will not be joined");
        }
        if (userOrAutoConn == null) {
            if (conn == null) {
                if (driver != null && driver.dbConnection != null) {
                    conn = driver.dbConnection;
                }
                if (conn == null) {
                    conn = SQLConnectionManager.getConnection(dbName);
                }
                if (driver != null) {
                    driver.dbConnection = conn;
                }
            } else if (driver != null) {
                if (driver.dbConnection != null && driver.dbConnection != conn) {
                    SQLConnectionManager.free(driver.dbConnection);
                }
                driver.dbConnection = conn;
            }
            userOrAutoTransaction = false;
            workingConn = conn;
        } else {
            workingConn = userOrAutoConn;
        }
        if (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
            log.info((Object)("Executing SQL query on '" + dbName + "' using connection '" + workingConn.hashCode() + "'"), (Object)update);
        }
        try {
            int ds = SQLDriver.doUpdate(update, data, workingConn, req, driver);
            return ds;
        }
        catch (SQLException se) {
            if (!userOrAutoTransaction) {
                if (config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                    log.info((Object)("Execute of update: " + update + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying update."));
                }
                SQLConnectionManager.free(conn, true);
                conn = SQLConnectionManager.getNewConnection(dbName);
                if (driver != null) {
                    driver.dbConnection = conn;
                }
                int n = SQLDriver.doUpdate(update, data, conn, req, driver);
                return n;
            }
            log.debug((Object)("FAILED to execute SQL update in '" + dbName + "' using connection'" + workingConn.hashCode() + "'"));
            throw se;
        }
        finally {
            if (!userOrAutoTransaction && driver == null) {
                SQLConnectionManager.free(conn);
            }
        }
    }

    public static int doUpdate(String update, List data, Connection conn, DSRequest req) throws SQLException {
        return SQLDriver.doUpdate(update, data, conn, req, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doUpdate(String update, List data, Connection conn, DSRequest req, SQLDriver driver) throws SQLException {
        try {
            if (req != null) {
                driver.setLastSequenceMode(((SQLDataSource)req.getDataSource()).getSequenceMode());
            } else {
                driver.setLastSequenceMode(SQLDataSource.SequenceMode.NONE);
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception getting sequenceMode: " + e.getMessage());
        }
        PreparedStatement s = driver.getPreparedStatement(conn, update, driver.getLastSequenceMode());
        try {
            int pos;
            if (data != null && !DataSource.isRemove((String)req.getOperationType())) {
                pos = 1;
                for (Object o : data) {
                    if (o instanceof InputStream) {
                        InputStream is = (InputStream)o;
                        try {
                            Method m = Reflection.findMethod((String)"java.sql.PreparedStatement", (String)"setBinaryStream", (Class[])new Class[]{Integer.TYPE, Class.forName("java.io.InputStream")});
                            m.invoke((Object)s, pos, is);
                        }
                        catch (Exception e) {
                            if (!(o instanceof ByteArrayInputStream)) {
                                is = new ByteArrayInputStream(IOUtil.toByteArray((InputStream)is));
                            }
                            s.setBinaryStream(pos, is, is.available());
                        }
                    } else if (o instanceof StringBuffer) {
                        StringBuffer sb = (StringBuffer)o;
                        s.setCharacterStream(pos, (Reader)new StringReader(sb.toString()), sb.length());
                    } else if (o == null && driver.shouldParameterizeNullValues()) {
                        s.setString(pos, null);
                    }
                    ++pos;
                }
            }
            pos = s.executeUpdate();
            return pos;
        }
        catch (IOException ioe) {
            log.warn((Object)"Exception thrown whilst processing InputStream", (Throwable)ioe);
            int n = -1;
            return n;
        }
        finally {
            try {
                if (driver != null && req != null && DataSource.isAdd((String)req.getOperationType())) {
                    driver.saveGeneratedKeys(s, req);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception thrown during saveGeneratedKeys()", (Throwable)e);
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected PreparedStatement getPreparedStatement(Connection conn, String update, SQLDataSource.SequenceMode sequenceMode) throws SQLException {
        if (sequenceMode == SQLDataSource.SequenceMode.JDBC_DRIVER) {
            if (SQLDriver.supportsGetGeneratedKeys(conn)) {
                return conn.prepareStatement(update, 1);
            }
            return conn.prepareStatement(update);
        }
        return conn.prepareStatement(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String sql, Connection conn, String dbName, SQLDriver driver) throws Exception {
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if (conn == null) {
            conn = SQLConnectionManager.getConnection(dbName);
            if (driver != null) {
                driver.dbConnection = conn;
            }
        }
        Statement s = null;
        try {
            log.info((Object)("Executing SQL on '" + dbName + "'"), (Object)sql);
            s = conn.createStatement();
            boolean bl = s.execute(sql);
            return bl;
        }
        catch (SQLException se) {
            log.info((Object)("Execute of sql: " + sql + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying update."));
            SQLConnectionManager.free(conn, true);
            conn = SQLConnectionManager.getNewConnection(dbName);
            if (driver != null) {
                driver.dbConnection = conn;
            }
            s = conn.createStatement();
            boolean bl = s.execute(sql);
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
            if (driver == null) {
                SQLConnectionManager.free(conn);
            }
        }
    }

    public boolean execute(String sql) throws Exception {
        return SQLDriver.execute(sql, this.dbConnection, this.dbName, this);
    }

    public int executeUpdate(String update, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, this.dbConnection, this.dbName, this, req);
    }

    public int executeUpdate(String update, List data, DSRequest req) throws Exception {
        return SQLDriver.update(update, data, this.dbConnection, this.dbName, this, req);
    }

    public List executeQuery(String query, DSRequest req) throws Exception {
        return this.executeQuery(query, null, req, null);
    }

    public List executeQuery(String query, List dataSources, DSRequest req) throws Exception {
        return this.executeQuery(query, dataSources, null, req, null);
    }

    public List executeQuery(String query, List dataSources, DSRequest req, DSResponse resp) throws Exception {
        return this.executeQuery(query, dataSources, null, req, resp);
    }

    public List executeQuery(String query, List dataSources, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        return SQLDriver.getTransformedResults(query, this.dbConnection, this.dbName, this, dataSources, opConfig, req, resp);
    }

    public Object executeScalar(String query, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, this.dbConnection, this.dbName, this, req);
    }

    public boolean supportsSQLLimit() {
        return false;
    }

    public boolean limitRequiresSQLOrderClause() {
        return false;
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, DSRequest req) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, null, null, null);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, DSRequest req, List dataSources) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, orderClause, req, dataSources, null);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, DSRequest req, List dataSources, Map context) throws Exception {
        throw new Exception("limitQuery not supported by '" + this.getDBType() + "'.  Implementation: " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public String getRowCountQueryString(String select, String tables, String ansiJoin, String where, String joinWhere, String group, String groupWhere, Map context) {
        boolean hasGroupWhere;
        boolean hasGroup;
        boolean _useDistinctForGroupBy = this.useDistinctForGroupBy;
        boolean hasCustomGroup = hasGroup = !group.equals("$defaultGroupClause") && !group.equals("$defaultGroupWithAliasClause");
        if (!hasGroup && context != null && context.containsKey("dsRequest")) {
            DSRequest req = (DSRequest)context.get("dsRequest");
            hasGroup = req.isSummary();
        }
        boolean bl = hasGroupWhere = !groupWhere.equals("$defaultGroupWhereClause");
        if (hasGroupWhere) {
            _useDistinctForGroupBy = false;
        }
        String qry = "SELECT COUNT(*) FROM ";
        if (hasGroup) {
            qry = !hasCustomGroup && _useDistinctForGroupBy ? qry + "(SELECT distinct " + group + " FROM " : qry + "(SELECT " + select + " FROM ";
        }
        qry = qry + tables;
        boolean emittedJoinClause = false;
        if (!"$defaultAnsiJoinClause".equals(ansiJoin) || context.get("defaultAnsiJoinClause") != null) {
            qry = qry + ansiJoin;
            emittedJoinClause = true;
        }
        boolean emittedWhere = false;
        if (!where.equals("$defaultWhereClause") || context.get("defaultWhereClause") != null && !SQLWhereClause.isDefaultPositiveClause(context.get("defaultWhereClause"))) {
            qry = qry + " WHERE " + where;
            emittedWhere = true;
        }
        if (!(emittedJoinClause || "$defaultJoinWhereClause".equals(joinWhere) && (context.get("defaultJoinWhereClause") == null || "".equals(context.get("defaultJoinWhereClause"))))) {
            qry = !emittedWhere ? qry + " WHERE " + joinWhere : qry + " AND " + joinWhere;
        }
        if (hasGroup) {
            if (!hasCustomGroup && _useDistinctForGroupBy) {
                qry = qry + " ) work";
            } else {
                qry = qry + " GROUP BY " + group + ") work";
                if (hasGroupWhere) {
                    qry = qry + " WHERE " + groupWhere;
                }
            }
        }
        return qry;
    }

    public abstract boolean supportsNativeReplace();

    public String sortBy(Object order, Map remapTable, Map valueMaps) {
        if (order == null) {
            return "";
        }
        List orderList = order instanceof String ? DataTools.makeList((Object)order) : (List)order;
        if (orderList.size() == 0) {
            return "";
        }
        if (remapTable == null) {
            remapTable = EMPTY_REMAP;
        }
        String clause = " ORDER BY ";
        Iterator e = orderList.iterator();
        while (e.hasNext()) {
            String orderColumn = (String)e.next();
            boolean descending = false;
            if (orderColumn.startsWith("-")) {
                orderColumn = orderColumn.substring(1);
                descending = true;
            }
            Map valueMap = (Map)valueMaps.get(orderColumn);
            String remappedName = (String)remapTable.get(orderColumn);
            if (remappedName != null) {
                orderColumn = remappedName;
            }
            orderColumn = this.escapeColumnName(orderColumn);
            clause = clause + this.getExpressionForSortBy(orderColumn, valueMap, null) + (descending ? " DESC" : "");
            if (!e.hasNext()) continue;
            clause = clause + ", ";
        }
        return clause;
    }

    protected abstract String getExpressionForSortBy(String var1, Map var2, DSRequest var3);

    protected String getExpressionForSortBy(String column, Map valueMap, String functionName, DSRequest request) {
        String expr = this.getExpressionForSortBy(column, valueMap, request);
        if (functionName != null && !"".equals(functionName.trim())) {
            expr = functionName + "(" + expr + ")";
        }
        return expr;
    }

    protected String getLocalizedDisplayValue(Object displayValue, DSRequest request) {
        if (displayValue instanceof LocaleMessage) {
            if (request != null && request.context == null) {
                log.warn((Object)"Passed a DSRequest with no context, so we cannot discover the client locale.  Using the server default locale");
            }
            Locale locale = request != null && request.context != null ? request.context.getLocale() : Locale.getDefault();
            return ((LocaleMessage)displayValue).getMessage(locale);
        }
        return displayValue == null ? null : displayValue.toString();
    }

    public abstract Map fetchLastPrimaryKeys(Map var1, List var2, SQLDataSource var3, DSRequest var4) throws Exception;

    public Map getJdbcPKs() {
        return this.jdbcPKs;
    }

    public void saveGeneratedKeys(Statement s, DSRequest req) throws Exception {
        this.jdbcPKs.clear();
        if (this.getLastSequenceMode() != SQLDataSource.SequenceMode.JDBC_DRIVER) {
            log.debug((Object)"SequenceMode is not JDBC_DRIVER, skipping search for generated values");
            return;
        }
        if (!SQLDriver.supportsGetGeneratedKeys(s.getConnection())) {
            log.warn((Object)"SequenceMode is JDBC_DRIVER but the driver is not GENERATED_KEYS capable");
            return;
        }
        if (req.getDataSource() instanceof SQLDataSource) {
            SQLDataSource ds = (SQLDataSource)req.getDataSource();
            List pkNames = ds.getPrimaryKeys();
            List fieldNames = ds.getFieldNames();
            boolean proceed = false;
            for (String fieldName : fieldNames) {
                DSField field = ds.getField(fieldName);
                if (field == null || !"sequence".equals(field.getType()) && (!pkNames.contains(fieldName) || !field.getBoolean("autoGenerated", false))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                log.debug((Object)("DataSource " + ds.getName() + " has no sequence fields and no primaryKeys where 'autoGenerated' is true.  Skipping search for generated values"));
                return;
            }
            LinkedMap sequences = new LinkedMap();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> sequenceFieldList = new ArrayList<String>();
            int count = 0;
            Iterator i = pkNames.iterator();
            while (i.hasNext()) {
                DSField pk = ds.getField((String)i.next());
                if (!"sequence".equals(pk.getType()) && !pk.getBoolean("autoGenerated", false)) continue;
                sequences.put(ds.getColumnName(pk.getName()).toLowerCase(), ds.getColumnName(pk.getName()));
                sequenceList.add(ds.getColumnName(pk.getName()));
                sequenceFieldList.add(pk.getName());
                ++count;
            }
            if (count > this.maxAllowedSequenceColumns()) {
                log.warn((Object)("DataSource " + ds.getName() + " can have a maximum of " + this.maxAllowedSequenceColumns() + " sequence fields, but it actually has " + count + ": " + sequenceFieldList + ". Cannot continue."));
                return;
            }
            log.debug((Object)("Found " + count + " sequence(s)/autoGenerated PK field(s): " + sequenceFieldList));
            ResultSet rs = s.getGeneratedKeys();
            if (rs == null) {
                return;
            }
            if (count == 1) {
                if (rs.next()) {
                    Object generated = rs.getObject(1);
                    if (generated != null) {
                        if (generated instanceof RowId || "oracle.sql.ROWID".equals(generated.getClass().getName())) {
                            this.jdbcPKs = this.fetchSequenceValues(sequenceFieldList, req, rs.getString(1));
                            this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                            log.debug((Object)("Discovered zero or one generated key via JDBC: " + this.jdbcPKs));
                            req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                        } else {
                            long pkValue = rs.getLong(1);
                            this.jdbcPKs.put(sequenceList.get(0), pkValue);
                            this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                            log.debug((Object)("Discovered zero or one generated key via JDBC: " + this.jdbcPKs));
                            req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                        }
                        req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                    } else {
                        log.warn((Object)"getGeneratedKeys: there was a row in the metadata resultset, but it contained a null value for the generated key");
                    }
                } else {
                    log.debug((Object)"No rows in metadata resultset - driver thinks there were no generated values!");
                }
            } else if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                Map<String, Long> jdbcPKs = new HashMap();
                for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                    Object generated = rs.getObject(i2 + 1);
                    if (generated == null) continue;
                    if (generated instanceof RowId || "oracle.sql.ROWID".equals(generated.getClass().getName())) {
                        jdbcPKs = this.fetchSequenceValues(sequenceFieldList, req, rs.getString(i2 + 1));
                        break;
                    }
                    String colName = rsmd.getColumnName(i2 + 1).toLowerCase();
                    if (colName == null || !sequences.containsKey(colName)) continue;
                    jdbcPKs.put(ds.getFieldNameFromColumnName((String)sequences.get(colName)), rs.getLong(i2 + 1));
                }
                jdbcPKs = this.mapColumnsToFields(jdbcPKs, ds);
                log.debug((Object)("Discovered zero or more generated key(s) via JDBC: " + jdbcPKs));
                req.setAttribute("_jdbcGeneratedKeys", (Object)true);
            } else {
                log.debug((Object)"No rows in metadata resultset - driver thinks there were no generated values!");
            }
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Map mapColumnsToFields(Map in, SQLDataSource ds) {
        LinkedHashMap out = new LinkedHashMap();
        for (String columnName : in.keySet()) {
            out.put(ds.native2DSFieldMap().get(columnName), in.get(columnName));
        }
        return out;
    }

    private int maxAllowedSequenceColumns() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map fetchSequenceValues(List sequences, DSRequest req, String rowId) throws Exception {
        LinkedMap linkedMap;
        block15: {
            List data;
            boolean free;
            Connection conn;
            LinkedMap values;
            block13: {
                LinkedMap linkedMap2;
                block14: {
                    DSTransaction dsTransaction;
                    DSRequest work = new DSRequest(req.getDataSourceName(), "fetch");
                    work.inheritClientContext(req);
                    work.setParameter((Object)"additionalOutputs", req.getParameter((Object)"additionalOutputs"));
                    Iterator i = req.getAttributeNames();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        work.setAttribute(key, req.getAttribute(key));
                    }
                    work.setPrimaryDSRequest(req);
                    req.addSubRequest(work);
                    values = new LinkedMap();
                    conn = null;
                    Statement stmt = null;
                    ResultSet rs = null;
                    free = false;
                    String sql = SQLDataSource.getSQLClause(SQLClauseType.All, work);
                    int index = sql.indexOf("WHERE ('1'='1')");
                    if (index != -1) {
                        sql = sql.substring(0, index) + "WHERE ROWID = '" + rowId + "'";
                    }
                    if ((dsTransaction = req.getDsTransaction()) != null) {
                        conn = (Connection)dsTransaction.getAttribute(req.getDataSource().getTransactionObjectKey(true));
                    }
                    if (conn == null) {
                        conn = ((SQLDataSource)req.getDataSource()).getConnection();
                        free = true;
                    }
                    stmt = conn.createStatement();
                    log.debug((Object)("Executing ROWID query: " + sql));
                    rs = stmt.executeQuery(sql);
                    data = SQLTransform.toListOfMaps(rs);
                    log.debug((Object)("ROWID query returned " + data.size() + " rows"));
                    if (data.size() == 1) break block13;
                    log.warn((Object)"ROWID query should return a single row, abandoning");
                    linkedMap2 = values;
                    if (!free || conn == null) break block14;
                    SQLConnectionManager.free(conn);
                }
                return linkedMap2;
            }
            try {
                Map record = (Map)data.get(0);
                if (record != null) {
                    for (int i = 0; i < sequences.size(); ++i) {
                        String key = (String)sequences.get(i);
                        Object value = record.get(key);
                        if (value == null) {
                            value = record.get(key.toUpperCase());
                        }
                        if (value == null) {
                            value = record.get(key.toLowerCase());
                        }
                        if (value != null) {
                            log.debug((Object)("Setting sequence value for field " + key + " to " + value));
                            values.put(key, value);
                            continue;
                        }
                        log.debug((Object)("No value for sequence field " + key + " found in record: " + record));
                    }
                }
                linkedMap = values;
                if (!free || conn == null) break block15;
            }
            catch (Throwable throwable) {
                if (free && conn != null) {
                    SQLConnectionManager.free(conn);
                }
                throw throwable;
            }
            SQLConnectionManager.free(conn);
        }
        return linkedMap;
    }

    public void clearState() {
        this.freeConnection();
        this.lastSequenceMode = null;
    }

    public String escapeColumnName(Object columnName) {
        return this.escapeColumnName(columnName, false);
    }

    public String escapeColumnName(Object columnName, boolean forceQuoteColumnName) {
        if (columnName == null) {
            return null;
        }
        if (forceQuoteColumnName || this.quoteColumnNames || this.table != null && this.table.isQuoteColumnNames()) {
            return this.openQuote() + globalPerl.substitute("s'\"'\"\"'g", columnName.toString()) + this.closeQuote();
        }
        return columnName.toString();
    }

    public abstract String escapeValue(Object var1);

    public abstract String escapeValueForFilter(Object var1, String var2);

    public abstract String formatValue(Object var1);

    public String escapeClause() {
        return "";
    }

    public abstract String escapeValueUnquoted(Object var1, boolean var2);

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) {
        return this.sqlInTransform(value, field, ds, true);
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds, boolean addLiteralPrefix) {
        String sqlType;
        boolean isFloat = false;
        boolean isInteger = false;
        boolean isSequence = false;
        boolean isBoolean = false;
        boolean isTime = false;
        boolean isDate = false;
        boolean isDateTime = false;
        if (field != null) {
            try {
                isFloat = ds.simpleTypeInheritsFrom(field.getType(), "float");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isInteger = ds.simpleTypeInheritsFrom(field.getType(), "integer");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isSequence = ds.simpleTypeInheritsFrom(field.getType(), "sequence");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isBoolean = ds.simpleTypeInheritsFrom(field.getType(), "boolean");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isTime = ds.simpleTypeInheritsFrom(field.getType(), "time");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isDate = ds.simpleTypeInheritsFrom(field.getType(), "date");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isDateTime = ds.simpleTypeInheritsFrom(field.getType(), "datetime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof GregorianCalendar) {
            value = ((GregorianCalendar)value).getTime();
        }
        if (value instanceof Date) {
            if (field != null) {
                sqlType = (String)field.get((Object)"sqlStorageStrategy");
                if ("number".equals(sqlType) || "integer".equals(sqlType) || "text".equals(sqlType)) {
                    String sqlFormat = (String)field.get((Object)"sqlDateFormat");
                    if (sqlFormat == null) {
                        sqlFormat = "yyyyMMdd";
                    }
                    if ("epoch".equalsIgnoreCase(sqlFormat)) {
                        return Long.toString(((Date)value).getTime() / 1000L);
                    }
                    if ("epochms".equalsIgnoreCase(sqlFormat)) {
                        return Long.toString(((Date)value).getTime());
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(sqlFormat);
                    String formatted = sdf.format(value);
                    return this.escapeValue(formatted);
                }
                if (isDateTime) {
                    long timeStamp = ((Date)value).getTime();
                    return this.escapeValue(this.formatTimestamp(timeStamp, true, ds, field));
                }
                if (isTime) {
                    return this.escapeValue(this.formatTime(((Date)value).getTime()));
                }
                if (isDate) {
                    return this.escapeValue(this.formatDate(((Date)value).getTime()));
                }
            }
            long timeStamp = ((Date)value).getTime();
            return this.escapeValue(this.formatTimestamp(timeStamp, true, ds, field));
        }
        if (isBoolean) {
            String val;
            sqlType = (String)field.get((Object)"sqlStorageStrategy");
            if ("number".equals(sqlType) || "integer".equals(sqlType)) {
                return value.equals(Boolean.TRUE) ? "1" : "0";
            }
            if (sqlType != null && sqlType.indexOf("singleChar") == 0 && (val = this.convertSingleCharValue(sqlType, value, field)) != null) {
                return val;
            }
        } else if (isFloat || isInteger || isSequence) {
            if (value instanceof Number) {
                return value.toString();
            }
            try {
                if (isFloat) {
                    return new Double(value.toString()).toString();
                }
                if (isInteger) {
                    return new Long(value.toString()).toString();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.escapeValue(value);
    }

    public String sqlStringComparisonRValue(String value, String operator) {
        StringBuffer sql = new StringBuffer();
        sql.append("'");
        if (operator.contains("ndsWith") || operator.contains("tains")) {
            sql.append("%");
        }
        if (operator.equals("containsPattern")) {
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (value.endsWith("%")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        sql.append(value);
        if (operator.contains("rtsWith") || operator.contains("tains")) {
            sql.append("%");
        }
        sql.append("'");
        return sql.toString();
    }

    public String sqlFilterTransform(Object value, DSField field, SQLDataSource ds, String filterStyle) {
        String compare = value.toString();
        if (this.caseInsensitiveStrategy() == 1 || this.caseInsensitiveStrategy() == 1) {
            compare = compare.toLowerCase();
        } else if (this.caseInsensitiveStrategy() == 2) {
            compare = compare.toUpperCase();
        }
        return this.escapeValueForFilter(compare, filterStyle);
    }

    protected String formatTimestamp(long millis, boolean convertToUTC, SQLDataSource ds, DSField field) {
        if (convertToUTC && (ds == null || ds.shouldUseUTCDateTimes())) {
            if (field != null && field.shouldStoreMilliseconds() && this.supportsMilliseconds()) {
                return this.getUTCDateTimeMsFormatter().format(new Timestamp(millis));
            }
            return this.getUTCDateTimeFormatter().format(new Timestamp(millis));
        }
        if (field != null && field.shouldStoreMilliseconds() && this.supportsMilliseconds()) {
            return this.getLocalDateTimeMsFormatter().format(new Timestamp(millis));
        }
        return this.getLocalDateTimeFormatter().format(new Timestamp(millis));
    }

    protected String formatDate(long millis) {
        return this.getLogicalDateFormatter().format(new Timestamp(millis));
    }

    protected String formatTime(long millis) {
        return this.getLogicalTimeFormatter().format(new Timestamp(millis));
    }

    protected String convertSingleCharValue(String sqlType, Object columnValue, DSField field) {
        String t = (String)field.get((Object)"sqlTrueValue");
        String f = (String)field.get((Object)"sqlFalseValue");
        if ("singleChar10".equals(sqlType)) {
            t = "1";
            f = "0";
        } else if ("singleCharYN".equals(sqlType)) {
            t = "Y";
            f = "N";
        } else if ("singleCharTF".equals(sqlType)) {
            t = "T";
            f = "F";
        }
        if (t != null || f != null) {
            return Boolean.TRUE.equals(DataTools.asBoolean((Object)columnValue)) ? (t == null ? "null" : "'" + t + "'") : (f == null ? "null" : "'" + f + "'");
        }
        return null;
    }

    public abstract String sqlOutTransform(String var1, String var2, String var3) throws Exception;

    public String sqlOutTransform(String columnName, String remapName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, null);
    }

    public String sqlOutTransform(String columnName) throws Exception {
        return this.sqlOutTransform(columnName, null, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, tableName, functionName, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (functionName != null && !"".equals(functionName)) {
            output = functionName + "(" + output + ")";
            if (remapName != null) {
                output = output + " AS " + this.escapeColumnName(remapName);
            }
        } else if (remapName != null && !remapName.equals(columnName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        return output;
    }

    public int getMaximumSetSize() {
        return 0;
    }

    public abstract String getNextSequenceValue(String var1, SQLDataSource var2) throws Exception;

    public Map forceSingleRow(List rows) throws Exception {
        if (rows == null) {
            throw new Exception("forceSingleRow() got null value");
        }
        if (rows.size() == 0 || rows.size() > 1) {
            throw new Exception("forceSingleRow() got " + rows.size() + " results");
        }
        return (Map)rows.get(0);
    }

    public boolean hasBrokenCursorAPIs() {
        return config.getBoolean((Object)("sql." + this.dbName + ".database.brokenCursorAPIs"), false);
    }

    public static String getSequenceName(String columnName, Map sequences, String tableName, SQLDriver sqlDriver) throws Exception {
        if (columnName == null || sequences == null || tableName == null) {
            return null;
        }
        String sequenceName = (String)sequences.get(columnName);
        if (sequenceName == null) {
            return null;
        }
        if (sequenceName.equals("__default")) {
            sequenceName = tableName + "_" + columnName;
            int fixedLength = columnName.length() + 1;
            if (sqlDriver != null) {
                String pref = sqlDriver.sequencePrefix();
                String suff = sqlDriver.sequenceSuffix();
                sequenceName = pref + sequenceName + suff;
                fixedLength += pref.length() + suff.length();
                int sequenceLength = sequenceName.length();
                int maxLength = sqlDriver.maxSequenceNameLength();
                if (maxLength >= 0 && sequenceLength > maxLength) {
                    if (fixedLength > maxLength) {
                        throw new Exception("can't create a unique sequence name for column name: '" + columnName + "' - unable to continue");
                    }
                    String truncatedTableName = tableName.substring(0, maxLength - fixedLength);
                    sequenceName = pref + truncatedTableName + "_" + columnName + suff;
                }
            }
        }
        return sequenceName;
    }

    protected String getSequenceName(String columnName) throws Exception {
        return SQLDriver.getSequenceName(columnName, this.table.getSequences(), this.table.getName(), this);
    }

    protected String getSequenceName(String columnName, SQLDataSource dataSource) throws Exception {
        return SQLDriver.getSequenceName(columnName, dataSource.getSequences(), this.table.getName(), this);
    }

    public boolean fieldIsSearchable(DSField field) {
        String fieldType = field.getType();
        return !field.isBinary() && !"blob".equals(fieldType) && !"clob".equals(fieldType);
    }

    public boolean fieldAssignableInline(DSField field) {
        String fieldType = field.getType();
        return !field.isBinary() && !"blob".equals(fieldType) && !"clob".equals(fieldType);
    }

    public Statement createFetchStatement(Connection conn, boolean streaming, long batchSize) throws SQLException {
        try {
            Statement stmt;
            if (streaming) {
                stmt = conn.createStatement(1003, 1007);
                if (this.canSetFetchSize() && this.shouldSetFetchSizeForStreaming()) {
                    stmt.setFetchSize(config.getInt((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".streaming.fetchSize"), 1));
                }
            } else {
                stmt = conn.createStatement();
                if (this.canSetFetchSize() && batchSize > 0L) {
                    stmt.setFetchSize((int)batchSize);
                }
            }
            return stmt;
        }
        catch (SQLException e) {
            if (streaming) {
                log.warn((Object)"Unable to create statement with flags: ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY.  Backing off to createStatement().");
                return conn.createStatement();
            }
            throw e;
        }
    }

    public Statement createScrollableFetchStatement(Connection conn, long batchSize) throws SQLException {
        try {
            Statement stmt = conn.createStatement(1004, 1007);
            if (this.canSetFetchSize() && batchSize > 0L) {
                stmt.setFetchSize((int)batchSize);
            }
            return stmt;
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to create statement with flags: ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY.  Backing off to createStatement()");
            return conn.createStatement();
        }
    }

    public boolean shouldSetFetchSizeForStreaming() {
        return true;
    }

    public boolean canSetFetchSize() {
        return true;
    }

    public Object transformFieldValue(DSField field, Object obj) {
        return obj;
    }

    public boolean shouldUseSQLDateType(DSField field) {
        String sqlType = null;
        if (field != null) {
            sqlType = field.getProperty("sqlStorageStrategy");
        }
        if (field == null || sqlType == null) {
            String defaultDateType = Config.getGlobal().getString((Object)("sql." + this.getDBName() + ".defaultDateType"));
            if (defaultDateType != null) {
                return defaultDateType.trim().toLowerCase().equals("date");
            }
        } else {
            return sqlType.equals("nativeDate");
        }
        return false;
    }

    protected static boolean supportsGetGeneratedKeys(Connection conn) throws SQLException {
        Method support = null;
        try {
            support = DatabaseMetaData.class.getMethod("supportsGetGeneratedKeys", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (support == null) {
            return false;
        }
        try {
            return conn.getMetaData().supportsGetGeneratedKeys();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    public InputStream handleInputStream(InputStream stream) throws Exception {
        if (config.getBoolean((Object)("sql." + this.getDBType() + ".readBinaryDataImmediately"), false)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtil.copyStreams((InputStream)stream, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        return stream;
    }

    public Reader handleCharacterStream(Reader reader) throws Exception {
        if (config.getBoolean((Object)("sql." + this.getDBType() + ".readBinaryDataImmediately"), false)) {
            return new StringReader(IOUtil.readerToString((Reader)reader));
        }
        return reader;
    }

    public void setConnectionProperties(Connection conn) {
    }

    public String getURLParameters() {
        return "";
    }

    public String getURLParameterString() {
        return null;
    }

    public void addDriverProperties(Map properties) {
    }

    public Timestamp adjustTimestamp(Timestamp timestamp) {
        return timestamp;
    }

    public String getLiteralPrefix(DSField field, BasicDataSource ds) {
        return "";
    }

    public Object modifyTemporalObject(Object obj, ResultSet rs, int ii) throws SQLException {
        return obj;
    }

    public int caseInsensitiveStrategy() {
        return 1;
    }

    public String caseSensitiveEqualsPredicate() {
        return "=";
    }

    public String caseSensitiveNotEqualPredicate() {
        return "<>";
    }

    public String getDriverNameForURL(Config driverConfig) {
        return driverConfig.getString((Object)"driverName");
    }

    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) {
        if (relation.getJoinType() == 1) {
            log.warn((Object)("The relation between " + relation.getFromDataSource().getID() + " and " + relation.getToDataSource().getID() + " is defined as an outer join, but outer joins are not yet supported on this database product (" + this.getDBType() + ")  Falling back to a regular inner join."));
        }
        return escapedFrom + " = " + escapedTo;
    }

    public boolean castNumbersBeforeLikeCompare() {
        return false;
    }

    public abstract String getNaturalDatabaseObjectName(String var1);

    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer();
        for (String s : strings) {
            if (sql.length() > 0) {
                sql.append(" || ");
            }
            sql.append(s);
        }
        return sql.toString();
    }

    public boolean aliasRequiredForSubselect() {
        return false;
    }

    public boolean aliasForbiddenForSubselect() {
        return false;
    }

    public boolean shouldParameterizeNullValues() {
        return true;
    }

    public boolean supportsMilliseconds() {
        return true;
    }

    public boolean supportsFieldComparison(String columnType, String otherColumnType) {
        return columnType != null && columnType.equals(otherColumnType);
    }

    public boolean tableExists(String tableName) throws Exception {
        return this.tableExists(tableName, null);
    }

    public boolean tableExists(String tableName, String schema) throws Exception {
        return new SQLMetaData(this.getOrCreateConnection()).tableExists(this.getNaturalDatabaseObjectName(tableName), this.getNaturalDatabaseObjectName(schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deriveDefaultSchema(String schema) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (schema == null) {
                String sql = this.getDummyQuery();
                stmt = this.getOrCreateConnection().createStatement();
                rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                schema = rsmd.getSchemaName(1);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return schema;
    }

    public abstract String getDummyQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canQueryTable(String tableName, String schemaName) throws Exception {
        String sql = "SELECT * FROM ";
        if (schemaName != null && !schemaName.equals("")) {
            sql = sql + schemaName + this.getQualifiedSchemaSeparator();
        }
        sql = sql + tableName + " WHERE '0'='1'";
        Connection conn = this.getOrCreateConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        log.debug((Object)("Checking for table existence with query: " + sql));
        try {
            rs = stmt.executeQuery(sql);
        }
        catch (Exception e) {
            log.debug((Object)("Test query failed, assuming table does not exist.  Error was: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        log.debug((Object)"Test query succeeded");
        return true;
    }

    public String getType() {
        return iscTypeForImplementer.getString((Object)((Object)((Object)this)).getClass().getName());
    }

    public static String getType(String dbName) throws Exception {
        return iscTypeForImplementer.getString((Object)SQLDriver.implementerClassForDB(dbName));
    }

    public static String getSnapshotFileName(String dbName, String catalog) throws Exception {
        return snapshotFileNamePrefix + "." + dbName + "." + catalog;
    }

    public static void snapshotDB(String dbName) throws Exception {
        String catalog = dbName;
        if (dbName.contains(".")) {
            List l = DataTools.simpleSplit((String)dbName, (String)".");
            dbName = (String)l.get(0);
            catalog = (String)l.get(1);
        } else {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        String snapshotFileName = SQLDriver.getSnapshotFileName(dbName, catalog);
        File tmpFile = new File(snapshotFileName);
        tmpFile.deleteOnExit();
        SQLDriver.instance(dbName).snapshotDB(catalog, new File(snapshotFileName));
    }

    public static void restoreDB(String dbName) throws Exception {
        String catalog = dbName;
        if (dbName.contains(".")) {
            List l = DataTools.simpleSplit((String)dbName, (String)".");
            dbName = (String)l.get(0);
            catalog = (String)l.get(1);
        } else {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        String snapshotFileName = SQLDriver.getSnapshotFileName(dbName, catalog);
        SQLDriver.instance(dbName).restoreDB(catalog, new File(snapshotFileName));
    }

    public void snapshotDB(String catalog, File snapshotFile) throws Exception {
        throw new Exception("snaphotDB not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public void restoreDB(String catalog, File snapshotFile) throws Exception {
        throw new Exception("restoreDB not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    static {
        iscImplementerForType.put((Object)"oracle", (Object)"com.isomorphic.sql.OracleDriver");
        iscImplementerForType.put((Object)"cloudsql", (Object)"com.isomorphic.sql.MysqlDriver");
        iscImplementerForType.put((Object)"mysql", (Object)"com.isomorphic.sql.MysqlDriver");
        iscImplementerForType.put((Object)"postgresql", (Object)"com.isomorphic.sql.PostgresDriver");
        iscImplementerForType.put((Object)"sqlserver", (Object)"com.isomorphic.sql.SQLServerDriver");
        iscImplementerForType.put((Object)"db2", (Object)"com.isomorphic.sql.DB2Driver");
        iscImplementerForType.put((Object)"db2iSeries", (Object)"com.isomorphic.sql.DB2iSeriesDriver");
        iscImplementerForType.put((Object)"hsqldb", (Object)"com.isomorphic.sql.HSQLDBDriver");
        iscImplementerForType.put((Object)"generic", (Object)"com.isomorphic.sql.GenericDriver");
        iscImplementerForType.put((Object)"cache", (Object)"com.isomorphic.sql.CacheDriver");
        iscImplementerForType.put((Object)"firebird", (Object)"com.isomorphic.sql.FirebirdDriver");
        iscImplementerForType.put((Object)"firebirdsql", (Object)"com.isomorphic.sql.FirebirdDriver");
        iscImplementerForType.put((Object)"generic", (Object)"com.isomorphic.sql.GenericSQLDriver");
        iscImplementerForType.put((Object)"informix", (Object)"com.isomorphic.sql.InformixDriver");
        iscImplementerForType.put((Object)"::hibernate::", (Object)"com.isomorphic.sql.HibernateDriver");
        for (String impType : iscImplementerForType.keySet()) {
            String impClass = iscImplementerForType.getString((Object)impType);
            if (iscTypeForImplementer.get((Object)impClass) != null) continue;
            iscTypeForImplementer.put((Object)impClass, (Object)impType);
        }
        snapshotFileNamePrefix = IOUtil.threadSafeTmpFileName((String)"/tmp/db_snapshot_sql");
    }
}

