<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.apache.struts.validator.ValidatorPlugIn" session="true" %>
<%@ page import="org.apache.struts.Globals" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<html:html locale="true">
<head>
<title><bean:message key="index.title"/></title>
<html:base/>
</head>
<body bgcolor="white">

<logic:notPresent name="<%= Globals.MESSAGES_KEY %>" >
  <font color="red">
    ERROR:  Application resources not loaded -- check servlet container
    logs for error messages.
  </font>
</logic:notPresent>


<h3>Form Examples</h3>
The following are three varations on the standard struts form example.  The first is the
original form example - provided for reference.  No SmartClient components are used and so form
validation/submission are page transition just like in any standard form.
<p>
The DynamicForm (Direct Submit) example uses a SmartClient DynamicForm, with a page transition
for both form validation and submission.  This shows the easiest integration strategy in that
the HTML form is plug-replaced with a SmartClient form, but the page transitions are still in
place.
<p>
The DynamicForm (with RPC-based Validation) is just like the DynamicForm (Direct Submit) except
that before the form is submitted to the actionURL, it works through the server-side validation
flow by sending an RPC to the validationURL.  So validation is done server-side and the
validation errors are returned by the server, but because the validation interaction is done
as an RPC, but the form isn't rebuilt when validation errors (or success) arrives.  Instead,
the validation errors are rendered inline in the form.  Once validation succeeds, the form is
submitted to the actionURL - this step is a page transition.
<p>

<ul>
   <li><html:link action="/plain_form">Plain Form</html:link></li>
   <li><html:link action="/dynamic_form">DynamicForm (Direct Submit)</html:link></li>
   <li><html:link action="/dynamic_form_rpc">DynamicForm (With RPC-based Validation)</html:link></li>
   </li>
</ul>

<p>&nbsp;</p>

<h3>Change Language | Changez Le Langage</h3>
You can use these link to switch the language used for form fields and validation errors - if
you then natigate back to the form examples - notice that the SmartClient form picks up the
correct language, just like the plain HTML form.
<ul>
   <li><html:link action="/locale?language=en">English | Anglais</html:link></li>
   <li>
      <html:link action="/locale?language=fr">French | Francais</html:link> -
      <bean:message key="localeForm.fr"/>
   </li>
   <li>
      <html:link action="/locale?language=fr&country=CA">French Canadian | Francais Canadien</html:link> -
      <bean:message key="localeForm.frCA"/>
   </li>
</ul>


</body>
</html:html>
