/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.dom.Attr;
import org.w3c.tidy.AttrCheckImpl;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.DOMAttrImpl;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.TagTable;
import org.w3c.tidy.TidyUtils;

public class AttVal
implements Cloneable {
    protected AttVal next;
    protected Attribute dict;
    protected Node asp;
    protected Node php;
    protected int delim;
    protected String attribute;
    protected String value;
    protected Attr adapter;

    public AttVal() {
    }

    public AttVal(AttVal attVal, Attribute attribute, int n, String string, String string2) {
        this.next = attVal;
        this.dict = attribute;
        this.delim = n;
        this.attribute = string;
        this.value = string2;
    }

    public AttVal(AttVal attVal, Attribute attribute, Node node, Node node2, int n, String string, String string2) {
        this.next = attVal;
        this.dict = attribute;
        this.asp = node;
        this.php = node2;
        this.delim = n;
        this.attribute = string;
        this.value = string2;
    }

    protected Object clone() {
        AttVal attVal = null;
        try {
            attVal = (AttVal)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.next != null) {
            attVal.next = (AttVal)this.next.clone();
        }
        if (this.asp != null) {
            attVal.asp = this.asp.cloneNode(false);
        }
        if (this.php != null) {
            attVal.php = this.php.cloneNode(false);
        }
        return attVal;
    }

    public boolean isBoolAttribute() {
        Attribute attribute = this.dict;
        return attribute != null && attribute.getAttrchk() == AttrCheckImpl.BOOL;
    }

    void checkLowerCaseAttrValue(Lexer lexer, Node node) {
        if (this.value == null) {
            return;
        }
        String string = this.value.toLowerCase();
        if (!this.value.equals(string)) {
            if (lexer.isvoyager) {
                lexer.report.attrError(lexer, node, this, (short)70);
            }
            if (lexer.isvoyager || lexer.configuration.lowerLiterals) {
                this.value = string;
            }
        }
    }

    public Attribute checkAttribute(Lexer lexer, Node node) {
        TagTable tagTable = lexer.configuration.tt;
        Attribute attribute = this.dict;
        if (attribute != null) {
            if (TidyUtils.toBoolean(attribute.getVersions() & 0x20)) {
                if (!lexer.configuration.xmlTags && !lexer.configuration.xmlOut) {
                    lexer.report.attrError(lexer, node, this, (short)57);
                }
            } else if (attribute != AttributeTable.attrTitle || node.tag != tagTable.tagA && node.tag != tagTable.tagLink) {
                lexer.constrainVersion(attribute.getVersions());
            }
            if (attribute.getAttrchk() != null) {
                attribute.getAttrchk().check(lexer, node, this);
            } else if (TidyUtils.toBoolean(this.dict.getVersions() & 0x1C0)) {
                lexer.report.attrError(lexer, node, this, (short)53);
            }
        } else if (!(lexer.configuration.xmlTags || node.tag == null || this.asp != null || node.tag != null && TidyUtils.toBoolean(node.tag.versions & 0x1C0))) {
            lexer.report.attrError(lexer, node, this, (short)48);
        }
        return attribute;
    }

    protected Attr getAdapter() {
        if (this.adapter == null) {
            this.adapter = new DOMAttrImpl(this);
        }
        return this.adapter;
    }

    public Node getAsp() {
        return this.asp;
    }

    public void setAsp(Node node) {
        this.asp = node;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) {
        this.attribute = string;
    }

    public int getDelim() {
        return this.delim;
    }

    public void setDelim(int n) {
        this.delim = n;
    }

    public Attribute getDict() {
        return this.dict;
    }

    public void setDict(Attribute attribute) {
        this.dict = attribute;
    }

    public AttVal getNext() {
        return this.next;
    }

    public void setNext(AttVal attVal) {
        this.next = attVal;
    }

    public Node getPhp() {
        return this.php;
    }

    public void setPhp(Node node) {
        this.php = node;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

