/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class ExecuteUpdateResultCheckStyle
implements Serializable {
    public static final ExecuteUpdateResultCheckStyle NONE = new ExecuteUpdateResultCheckStyle("none");
    public static final ExecuteUpdateResultCheckStyle COUNT = new ExecuteUpdateResultCheckStyle("rowcount");
    public static final ExecuteUpdateResultCheckStyle PARAM = new ExecuteUpdateResultCheckStyle("param");
    private final String name;

    private ExecuteUpdateResultCheckStyle(String name) {
        this.name = name;
    }

    private Object readResolve() throws ObjectStreamException {
        ExecuteUpdateResultCheckStyle resolved = ExecuteUpdateResultCheckStyle.parse(this.name);
        if (resolved == null) {
            throw new InvalidObjectException("unknown result style [" + this.name + "]");
        }
        return resolved;
    }

    public static ExecuteUpdateResultCheckStyle parse(String name) {
        if (name.equals(ExecuteUpdateResultCheckStyle.NONE.name)) {
            return NONE;
        }
        if (name.equals(ExecuteUpdateResultCheckStyle.COUNT.name)) {
            return COUNT;
        }
        if (name.equals(ExecuteUpdateResultCheckStyle.PARAM.name)) {
            return PARAM;
        }
        return null;
    }

    public static ExecuteUpdateResultCheckStyle determineDefault(String customSql, boolean callable) {
        if (customSql == null) {
            return COUNT;
        }
        return callable ? PARAM : COUNT;
    }
}

