/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum ConsoleLoggerMessage implements Message
{
    ON_CONSOLE_MESSAGE(1),
    CLEAR(2),
    LIST_MESSAGES(3),
    DEFAULT(-1);

    private static final Map<Integer, ConsoleLoggerMessage> lookup;
    private final int code;

    private ConsoleLoggerMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "console-logger";
    }

    public static ConsoleLoggerMessage get(int code) {
        ConsoleLoggerMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])ConsoleLoggerMessage.values()), (Function)new Function<ConsoleLoggerMessage, Integer>(){

            public Integer apply(ConsoleLoggerMessage message) {
                return message.getID();
            }
        });
    }
}

