/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInvocationHandler;
import com.isomorphic.base.MethodArgPair;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBSandbox;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.WrappedConnection;
import com.isomorphic.sql.WrappedResultSet;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WrappedStatement
extends ISCInvocationHandler {
    protected static Logger log = new Logger(WrappedStatement.class.getName());
    protected static Config config = Config.getGlobal();
    public static List updateMethods = config.getList((Object)"sql.sandbox.statementUpdateMethods");
    private List<MethodArgPair> replayLog = new ArrayList<MethodArgPair>();
    String dbName;
    String schemaName;
    WrappedConnection wrappedConnection;
    MethodArgPair statementCreation;
    public DBSandbox sandbox = null;

    public static boolean methodCausesUpdate(String methodName) {
        return updateMethods.contains(methodName) || updateMethods.contains("*");
    }

    public static boolean methodAltersState(String methodName) {
        return true;
    }

    public WrappedStatement(String dbName, String schemaName, WrappedConnection wrappedConnection, MethodArgPair statementCreation) {
        this.dbName = dbName;
        this.schemaName = schemaName;
        this.wrappedConnection = wrappedConnection;
        this.statementCreation = statementCreation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object invoke(Method method, Object[] args) throws Throwable {
        Class<?> methodReturnType;
        block12: {
            Object prevailingSandbox;
            boolean autoTestRunning;
            String methodName;
            block13: {
                block15: {
                    block14: {
                        methodName = method.getName();
                        methodReturnType = method.getReturnType();
                        if (Connection.class.isAssignableFrom(methodReturnType)) {
                            return this.wrappedConnection.getWrappedInstance();
                        }
                        autoTestRunning = config.getBoolean((Object)"autotest.instance.running", false);
                        if (!DBSandbox.isEnabled(this.dbName) || autoTestRunning) break block13;
                        prevailingSandbox = DBSandbox.getPrevailingSandbox(this.dbName);
                        if (prevailingSandbox == null && (this.sandbox == null || ((DBSandbox)prevailingSandbox).getSandboxName().equals(this.sandbox.getSandboxName()))) break block14;
                        log.debug((Object)("Using sandbox: " + ((DBSandbox)prevailingSandbox).getSandboxName()));
                        this.divertToSandbox((DBSandbox)prevailingSandbox);
                        break block12;
                    }
                    if (prevailingSandbox != null || this.sandbox == null) break block15;
                    this.divertToPrimaryDB();
                    break block12;
                }
                if (!DBSandbox.autoCreateOnWrite(this.dbName)) break block12;
                if (WrappedStatement.methodCausesUpdate(methodName)) {
                    String generatedSandboxName = DBSandbox.generateSandboxName(this.dbName);
                    if (generatedSandboxName != null) {
                        log.debug((Object)("Auto-creating and diverting to sandbox on update API call: " + methodName));
                        prevailingSandbox = new DBSandbox(this.dbName, generatedSandboxName);
                        DBSandbox.setSessionSandbox((DBSandbox)prevailingSandbox);
                        this.divertToSandbox((DBSandbox)prevailingSandbox);
                        break block12;
                    } else {
                        log.debug((Object)("Unable to auto-create and divert to sandbox for dbName: " + this.dbName + ", methodName: " + methodName + " because the sandbox name could not be auto-generated (most likely because a RequestContext threadLocal is not available on this thread - proceeding unsandboxed"));
                    }
                    break block12;
                } else if (WrappedStatement.methodAltersState(methodName)) {
                    log.debug((Object)("Recording API call in replayLog: " + methodName));
                    this.replayLog.add(new MethodArgPair(methodName, args));
                }
                break block12;
            }
            if (autoTestRunning && WrappedStatement.methodCausesUpdate(methodName)) {
                prevailingSandbox = WrappedStatement.class;
                // MONITORENTER : com.isomorphic.sql.WrappedStatement.class
                List restoreDBList = config.getList((Object)"autotest.instance.restoreDBList");
                List dbSnapshotFileList = config.getList((Object)"autotest.instance.dbSnapshotFileList");
                String canonicalDBName = "Mysql2".equals(this.dbName) ? "Mysql" : (this.dbName.endsWith("/defaultDatabase") ? config.getString((Object)"sql.defaultDatabase") : this.dbName);
                if (!this.dbName.equals(canonicalDBName)) {
                    log.debug((Object)("Canonicalized dbName: " + this.dbName + " to: " + canonicalDBName));
                }
                if (restoreDBList != null && !restoreDBList.contains(canonicalDBName)) {
                    log.debug((Object)("In autotest, detected possible update operation: " + method.getName() + " with args:" + (args == null ? "null" : Arrays.asList(args).toString()) + " current restoreDBList: " + restoreDBList.toString() + ", taking snapshotof: " + canonicalDBName));
                    String dbSnapshotFile = SQLDriver.createSnapshot(canonicalDBName);
                    restoreDBList.add(canonicalDBName);
                    if (dbSnapshotFileList != null) {
                        dbSnapshotFileList.add(dbSnapshotFile);
                    }
                }
                // MONITOREXIT : prevailingSandbox
            }
        }
        Object retVal = method.invoke(this.target, args);
        if (!ResultSet.class.isAssignableFrom(methodReturnType)) return retVal;
        return new WrappedResultSet(this).wrap(retVal);
    }

    public void divertToPrimaryDB() throws Exception {
        this.sandbox = null;
        Statement stmt = this.getUnwrappedStatement();
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getWrappedConnection().divertToPrimaryDB();
        Connection conn = this.getUnwrappedConnection();
        stmt = (Statement)Reflection.invokeMethod((Object)conn, (String)this.statementCreation.getMethodName(), (Object[])this.statementCreation.getArgs());
        this.setUnwrappedStatement(stmt);
    }

    public void divertToSandbox(DBSandbox sandbox) throws Exception {
        if (this.sandbox != null && sandbox.getSandboxName().equals(this.sandbox.getSandboxName())) {
            return;
        }
        this.sandbox = sandbox;
        Statement stmt = this.getUnwrappedStatement();
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getWrappedConnection().divertToSandbox(sandbox);
        Connection conn = this.getUnwrappedConnection();
        stmt = (Statement)Reflection.invokeMethod((Object)conn, (String)this.statementCreation.getMethodName(), (Object[])this.statementCreation.getArgs());
        this.setUnwrappedStatement(stmt);
        for (MethodArgPair replayEntry : this.replayLog) {
            Reflection.invokeMethod((Object)stmt, (String)replayEntry.getMethodName(), (Object[])replayEntry.getArgs());
        }
        this.replayLog.clear();
    }

    public WrappedConnection getWrappedConnection() {
        return this.wrappedConnection;
    }

    public Connection getUnwrappedConnection() {
        return this.getWrappedConnection().getUnwrappedConnection();
    }

    public Statement getWrappedStatement() {
        return (Statement)this.getWrappedInstance();
    }

    public Statement getUnwrappedStatement() {
        return (Statement)this.target;
    }

    public void setUnwrappedStatement(Statement stmt) {
        this.target = stmt;
    }
}

