/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSSyntaxScanner;
import com.isomorphic.taglib.LoadAppTag;
import com.isomorphic.taglib.LoadDSTag;
import com.isomorphic.taglib.LoadTag;
import com.isomorphic.taglib.LoadTypeTag;
import com.isomorphic.taglib.LoadUITag;
import com.isomorphic.taglib.WidgetXMLTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class LoadAssemblyTag
extends LoadTag {
    public String uri = null;
    public Boolean assemble = new Boolean(true);
    public String locale = null;
    public String media = null;
    public String configFile = null;

    public int doStartTag() throws JspException {
        this.init();
        try {
            if (this.uri == null) {
                throw new JspException("uri not set in tag - unable to proceed.");
            }
            IAssembly assembly = null;
            try {
                assembly = (IAssembly)InterfaceProvider.load("IAssembly");
            }
            catch (Exception e) {
                this.log.error("Use of the loadAssembly tag request the Network Performance Module. Please make sure isomorphic_assembly.jar is in your CLASSPATH");
                throw e;
            }
            String uriType = this.uri.toLowerCase().contains(".css") ? "css" : "js";
            JspWriter out = this.pageContext.getOut();
            if (this.assemble.booleanValue() || ISCFile.newInstance(webRoot + "/" + this.uri).exists()) {
                if ("css".equals(uriType)) {
                    out.write("<LINK REL=\"stylesheet\" TYPE=\"text/css\"" + (this.media != null ? " media=\"" + this.media + "\"" : "") + " HREF='" + this.versionedBrowserPathToFile(this.uri, "css") + "'/>\n");
                } else {
                    out.write("<SCRIPT SRC='" + this.versionedBrowserPathToFile(this.uri) + "'></SCRIPT>\n");
                }
            } else {
                Map assemblyConfig;
                Map myConfig;
                this.log.debug("processing non-assembled config");
                ServletContext sContext = this.pageContext.getServletContext().getContext(this.uri);
                if (this.configFile == null && sContext != null) {
                    this.configFile = sContext.getInitParameter("configFile");
                }
                if (this.configFile == null) {
                    this.log.debug("Unable to obtain configuration context for assembly URI: " + this.uri + " - trying include() mechanism instead.");
                    RequestDispatcher dispatcher = this.pageContext.getServletContext().getRequestDispatcher(this.uri);
                    if (dispatcher != null) {
                        ServletRequest request = this.pageContext.getRequest();
                        request.setAttribute("isc_fa_configOnly", (Object)new Boolean(true));
                        dispatcher.include(request, this.pageContext.getResponse());
                        this.configFile = (String)request.getAttribute("isc_fa_configFile");
                    } else {
                        this.log.warn("Unable to obtain RequestDispatcher for assembly URI: " + this.uri + ".  If you have a configFile location configured that is not the standard /isomorphicConfig/fileAssembly.xml, it will not be loaded.  To fix, please add a configFile attribute to your load tag.");
                    }
                }
                if (this.configFile != null) {
                    this.log.info("Found config file: " + this.configFile);
                    if (this.configFile != null) {
                        assembly.addConfigFile(config.getPath("webRoot") + this.configFile);
                    }
                }
                if ((myConfig = (Map)(assemblyConfig = assembly.getAssemblyConfig()).get(this.uri)) == null) {
                    int qIndex = this.uri.indexOf("?");
                    if (qIndex != -1) {
                        String origURI = this.uri;
                        this.uri = this.uri.substring(0, qIndex);
                        myConfig = (Map)assemblyConfig.get(this.uri);
                        if (myConfig == null) {
                            String error = "Unable to locate assembly URI: " + origURI + " in assembly config (Note: also tried and failed to match " + this.uri + ")";
                            this.log.error(error);
                            throw new Exception(error);
                        }
                    } else {
                        String error = "Unable to locate assembly URI: " + this.uri + " in assembly config.";
                        this.log.error(error);
                        throw new Exception(error);
                    }
                }
                out.write("<!-- Start assembly: " + this.uri + " -->\n");
                List components = (List)myConfig.get("components");
                for (Object component : components) {
                    String name;
                    Object componentData = component instanceof String ? DataTools.buildMap("type", "file", "fileName", (String)component) : (Map)component;
                    String type = (String)componentData.get("type");
                    if (type == null) {
                        throw new Exception("Component has no type: " + componentData);
                    }
                    if (type.equals("file")) {
                        String fileName = (String)componentData.get("fileName");
                        if (fileName == null) {
                            throw new Exception("Can't find a 'fileName' attribute on assembly component with config block: " + DataTools.prettyPrint(componentData) + " for Assembly URI" + this.uri);
                        }
                        String absFileName = webRoot + "/" + fileName;
                        JSSyntaxScanner ss = new JSSyntaxScanner();
                        ss.scanJS(IOUtil.inputStreamToString(ISCFile.newInstance(absFileName).getInputStream()), absFileName);
                        if ("css".equals(uriType)) {
                            out.write("<LINK  REL=\"stylesheet\" TYPE=\"text/css\"" + (this.media != null ? " media=\"" + this.media + "\"" : "") + " HREF='" + this.versionedBrowserPathToFile(fileName, "css") + "'/>\n");
                            continue;
                        }
                        out.write("<SCRIPT SRC='" + this.versionedBrowserPathToFile(fileName) + "'></SCRIPT>\n");
                        continue;
                    }
                    out.write("<SCRIPT>\n");
                    if (type.equals("jsFileList") || type.equals("jsModule")) {
                        throw new Exception("Assembler component of type: " + type + " is not supported by loadAssembly tag (while processing assembly URI:" + this.uri);
                    }
                    if (type.equals("xmlFile")) {
                        name = (String)componentData.get("fileName");
                        if (name == null) {
                            name = (String)componentData.get("name");
                        }
                        WidgetXMLTag.parseAndOutputErrors(name, (Writer)this.pageContext.getOut(), this.pageContext);
                    } else if (type.equals("datasource") || type.equals("ds")) {
                        name = (String)componentData.get("name");
                        if (name == null) {
                            name = (String)componentData.get("id");
                        }
                        LoadDSTag.outputJS(name, false, this.pageContext, this.locale, this.log);
                    } else if (type.equals("type")) {
                        name = (String)componentData.get("name");
                        if (name == null) {
                            name = (String)componentData.get("id");
                        }
                        LoadTypeTag.outputJS(name, this.pageContext);
                    } else if (type.equals("app")) {
                        name = (String)componentData.get("name");
                        if (name == null) {
                            name = (String)componentData.get("id");
                        }
                        LoadAppTag.outputJS(name, this.pageContext);
                    } else if (type.equals("ui")) {
                        name = (String)componentData.get("name");
                        if (name == null) {
                            name = (String)componentData.get("id");
                        }
                        LoadUITag.outputJS(name, this.pageContext);
                    } else {
                        throw new Exception("Assembler component of type: " + type + " is not supported by loadAssembly tag (while processing assembly URI:" + this.uri);
                    }
                    out.write("</SCRIPT>\n");
                }
                out.write("<!-- End assembly: " + this.uri + " -->\n");
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadAssembly tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public void setURI(String value) {
        this.uri = value;
    }

    public String getURI() {
        return this.uri;
    }

    public void setAssemble(boolean value) {
        this.setAssemble(new Boolean(value));
    }

    public void setAssemble(Boolean value) {
        this.setAssemble(value == null ? "false" : value.toString());
    }

    public void setAssemble(String value) {
        this.assemble = Boolean.valueOf(value);
    }

    public String getAssemble() {
        return this.assemble.toString();
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public String getMedia() {
        return this.media;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }
}

