/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class ISCHttpClient
extends Base {
    private static Logger log = new Logger(ISCHttpClient.class.getName());
    private boolean _warnOnStatusNotOk = false;
    HttpClient httpClient = new DefaultHttpClient();
    HttpRequest httpRequest = null;

    public ISCHttpClient setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ISCHttpClient setHttpMethod(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public ISCHttpClient warnOnStatusNotOk(boolean value) {
        this._warnOnStatusNotOk = value;
        return this;
    }

    public ByteArrayInputStream GET(String url) throws Exception {
        if (this.httpRequest == null) {
            this.httpRequest = new HttpGet(url);
        }
        ((HttpRequestBase)this.httpRequest).setProtocolVersion(new ProtocolVersion("HTTP", 1, 1));
        byte[] responseBody = this._httpExecute(this.httpClient, this.httpRequest);
        return responseBody != null ? new ByteArrayInputStream(responseBody) : null;
    }

    protected byte[] _httpExecute(HttpClient httpClient, HttpRequest httpRequest) {
        byte[] responseBody = null;
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                response.getEntity().writeTo((OutputStream)baos);
                responseBody = baos.toByteArray();
            } else if (this._warnOnStatusNotOk) {
                log.warn(((HttpRequestBase)httpRequest).getMethod() + " " + ((HttpRequestBase)httpRequest).getURI() + " failed with http code: " + statusCode);
            }
            return responseBody;
        }
        catch (IOException e) {
            log.warn((Object)"Fatal transport error: ", e);
            return null;
        }
    }
}

