<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://www.smartclient.com/taglib" prefix="isomorphic" %>
<%
    boolean hosted = "1".equals(request.getParameter("hosted"));

    RequestContext context = RequestContext.instance(this, request, response, out);        
    Config iscConfig = Config.getGlobal();
    String webRoot = iscConfig.getPath("webRoot");
    String toolsDir = iscConfig.getPath("toolsDir");


    String locale = request.getParameter("locale");
 
    String viewType = request.getParameter("type");
    String screenName = request.getParameter("screen");
    String projectName = request.getParameter("project");

    String shareId = request.getParameter("shareId");

    boolean isShared = false;
    if (shareId != null) {
        DSRequest sharedDSRequest = new DSRequest("sharedProjects", "fetch");
        sharedDSRequest.setCriteria(DataTools.buildMap("shareId", shareId));
        DSResponse sharedDSResponse = sharedDSRequest.execute();
        Map record = sharedDSResponse.getRecord();
        if (record == null) throw new Exception("Invalid shareId");
        String paramString = (String)record.get("parameters");
        Map params = ServletTools.parseQueryString(paramString);
        viewType = (String)params.get("type");
        screenName = (String)params.get("screen");
        projectName = (String)params.get("project");
        isShared = true;
    }
    String skin = request.getParameter("skin");
    if (skin == null) skin = "Tahoe";
%>
<HTML><HEAD><TITLE><%=isc_getShortURI(request)%></TITLE>
</HEAD><BODY>
<isomorphic:loadISC includeModules="SalesForce,Drawing,Charts,Analytics" skin="<%=skin%>"/>

<SCRIPT>
<%
if ("screen".equals(viewType)) {
    String ownerId = (isShared ? null : request.getRemoteUser());
    out.append(Screen.getLoadScript(screenName, ownerId));

} else if ("project".equals(viewType)) {
    String currentScreenName = request.getParameter("currentScreen");
    String ownerId = (isShared ? null : request.getRemoteUser());

    ProjectLoadSettings settings = new ProjectLoadSettings();
    settings.setCurrentScreenName(currentScreenName);
    settings.setOwnerId(ownerId);
    settings.setLocale(locale);
    settings.setShareId(shareId);

    out.append(Project.getLoadScript(projectName, settings));

} else {
    throw new Exception("Invalid viewType: " + viewType);
}
%>
        
</SCRIPT>

</BODY>
</HTML>
<%!
public String isc_getShortURI(HttpServletRequest request) {
    String uri = request.getRequestURI();
    int slashIndex = uri.lastIndexOf("/");
    if(slashIndex != -1) uri = uri.substring(slashIndex+1);
    return uri;
}
%>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>

<%@ page import="com.isomorphic.base.*" %>
<%@ page import="com.isomorphic.util.*" %>
<%@ page import="com.isomorphic.js.*" %>
<%@ page import="com.isomorphic.servlet.*" %>
<%@ page import="com.isomorphic.datasource.*" %>
<%@ page import="com.isomorphic.io.*" %>
<%@ page import="com.isomorphic.rpc.*" %>
<%@ page import="com.isomorphic.xml.*" %>
<%@ page import="com.isomorphic.tools.*" %>
<%@ page import="com.isomorphic.log.*" %>
<%@ page import="com.isomorphic.collections.*" %>

