/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSRequestCallback;
import com.isomorphic.datasource.DSRequestRunner;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISCSubscriber;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StreamDataSource
extends BasicDataSource {
    private static Logger log = new Logger(StreamDataSource.class.getName());
    static ExecutorService executor;

    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
    }

    public static void initStreamRouting() throws Exception {
        executor = Executors.newFixedThreadPool(1);
        DSRequest dataSourceDataChangedRequest = new DSRequest("DataSourceDataChanged", "fetch");
        dataSourceDataChangedRequest.setCallback(new DSRequestCallback(){

            public void callback(DSResponse dsResponse) {
                Map record = dsResponse.getRecord();
            }
        });
        DSRequestRunner dataSourceDataChangedObserver = new DSRequestRunner(dataSourceDataChangedRequest);
        executor.execute((Runnable)dataSourceDataChangedObserver);
    }

    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        if (serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        String transport = serverConfig.getString((Object)"transport");
        if (transport == null) {
            throw new Exception("You must specify a transport");
        }
        String messageFormat = serverConfig.getString((Object)"messageFormat", "json");
        String opType = dsRequest.getOperationType();
        if ("jms".equals(transport)) {
            block6: {
                DSResponse dsResponse;
                DataTypeMap jmsConfig = serverConfig.getMap((Object)"jms");
                if (jmsConfig == null) {
                    throw new Exception("jms transport requires a jms config block");
                }
                String channel = jmsConfig.getString((Object)"channel");
                if (channel == null) {
                    throw new Exception("jms transport requires a channel");
                }
                ISCSubscriber subscriber = new ISCSubscriber();
                ISCMessageDispatcher dispatcher = ISCMessageDispatcher.instance();
                dispatcher.register(subscriber);
                dispatcher.subscribe((ISubscriber)subscriber, channel);
                while (true) {
                    ISCMessage message = subscriber.nextMessage(-1L);
                    Object serializedData = message.getData();
                    if (!messageFormat.equals("json")) break block6;
                    Object data = JSTranslater.instance().fromJS(serializedData.toString());
                    Map record = this.getProperties(data);
                    if (!this.matchesCriteria(record, dsRequest.getAdvancedCriteria())) continue;
                    dsResponse = new DSResponse((DataSource)this);
                    dsResponse.setSuccess();
                    dsResponse.setData((Object)DataTools.makeListIfSingle((Object)data));
                    DSRequestCallback dsrc = dsRequest.getCallback();
                    if (dsrc == null) break;
                    dsrc.callback(dsResponse);
                }
                return dsResponse;
            }
            throw new Exception("messageFormat: " + messageFormat + " is not supported");
        }
        throw new Exception("Transport: " + transport + " is not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        Object outboundData;
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        if (serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        String transport = serverConfig.getString((Object)"transport");
        if (transport == null) {
            throw new Exception("You must specify a transport");
        }
        String messageFormat = serverConfig.getString((Object)"messageFormat", "json");
        String messageTemplate = serverConfig.getString((Object)"messageTemplate");
        if (messageTemplate != null) {
            messageTemplate = messageTemplate.trim();
            if (!messageFormat.equals("json") && !messageFormat.equals("java")) throw new Exception("messageFormat: " + messageFormat + " is not supported");
            outboundData = JSTranslater.instance().fromJS(messageTemplate);
        } else {
            outboundData = new HashMap();
        }
        outboundData = this.setProperties(dsRequest.getValues(), outboundData, dsRequest);
        if (!"jms".equals(transport)) throw new Exception("Transport: " + transport + " is not supported");
        DataTypeMap jmsConfig = serverConfig.getMap((Object)"jms");
        if (jmsConfig == null) {
            throw new Exception("jms transport requires a jms config block");
        }
        String channel = jmsConfig.getString((Object)"channel");
        if (channel == null) {
            throw new Exception("jms transport requires a channel");
        }
        ISCMessage iscMessage = new ISCMessage(channel, outboundData);
        ISCMessageDispatcher.instance().send(iscMessage);
        DSResponse dsResponse = new DSResponse((DataSource)this);
        dsResponse.setSuccess();
        dsResponse.setData((Object)dsRequest.getValues());
        return dsResponse;
    }
}

