/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.FrameworkDynamicDSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuditDSGenerator
implements FrameworkDynamicDSGenerator {
    public static final String DEFAULT_REVISION_FIELD_NAME = "audit_revision";
    public static final String DEFAULT_TIMESTAMP_FIELD_NAME = "audit_changeTime";
    public static final String DEFAULT_DIFF_FIELD_NAME = "audit_changedFields";
    public static final String DEFAULT_TYPE_FIELD_NAME = "audit_operationType";
    public static final String DEFAULT_USER_FIELD_NAME = "audit_modifier";
    static final Map<String, String> specialFields = new HashMap<String, String>(){
        {
            this.put("auditRevisionFieldName", AuditDSGenerator.DEFAULT_REVISION_FIELD_NAME);
            this.put("auditTimeStampFieldName", AuditDSGenerator.DEFAULT_TIMESTAMP_FIELD_NAME);
            this.put("auditChangedFieldsFieldName", AuditDSGenerator.DEFAULT_DIFF_FIELD_NAME);
            this.put("auditTypeFieldName", AuditDSGenerator.DEFAULT_TYPE_FIELD_NAME);
            this.put("auditUserFieldName", AuditDSGenerator.DEFAULT_USER_FIELD_NAME);
        }
    };
    static final String DIFF_FIELD_LENGTH_PROPERTY = "auditChangedFieldsFieldLength";
    public static String DEFAULT_SCHEMA_NAME = "auditSchema";
    private static Logger log = new Logger(AuditDSGenerator.class.getName());
    private Map ds2audit = Collections.synchronizedMap(new HashMap());
    private static List<String> auditedDses = Collections.synchronizedList(new ArrayList());
    public static Map ds2TableChecked = new HashMap();
    private static Config config = Config.getGlobal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public DataSource getDataSource(String id, DSRequest dsRequest) {
        block40: {
            if (!this.ds2audit.containsKey(id)) {
                return null;
            }
            AuditDSGenerator.log.debug(id + " is an audit DataSource, processing");
            hasPrimaryKey = true;
            ds = null;
            ds = (BasicDataSource)DataSourceManager.getDataSource((String)this.ds2audit.get(id));
            ret = ds.getAuditDataSource();
            if (ret != null) ** GOTO lbl179
            sw = new StringWriter();
            sw.write("<DataSource ");
            sw.write("serverType=\"");
            serverType = (String)ds.getConfig().get("serverType");
            sw.write(serverType);
            sw.write("\"");
            sw.write(" ID=\"");
            sw.write(id);
            sw.write("\"");
            if (serverType != null && serverType.trim().toLowerCase().equals("sql")) {
                sw.write(" tableName=\"");
                sw.write(id);
                sw.write("\"");
            }
            sw.write(" inheritsFrom=\"");
            sw.write(ds.getID());
            sw.write("\"");
            sw.write(" auditedDataSourceID=\"");
            sw.write(ds.getID());
            sw.write("\"");
            sw.write(" xmlFromConfig=\"true\"");
            auditDbName = ds.getConfig().getString("auditDbName");
            if (auditDbName == null) {
                auditDbName = ds.getConfig().getString("dbName");
            }
            if (auditDbName != null) {
                sw.write(" dbName=\"");
                sw.write(auditDbName);
                sw.write("\"");
            }
            if ((tmp = AuditDSGenerator.getAuditSchemaName(ds)) != null) {
                sw.write(" schema=\"");
                sw.write(tmp);
                sw.write("\"");
            }
            if ((tmp = AuditDSGenerator.getAuditDSConstructor(ds)) != null) {
                if ("sql".equals(tmp)) {
                    tmp = "com.isomorphic.sql.SQLDataSource";
                }
                sw.write(" serverConstructor=\"");
                sw.write(tmp);
                sw.write("\"");
            }
            sw.write(">\n");
            sw.write("<fields>\n");
            tmp = AuditDSGenerator.getAuditRevisionFieldName(ds);
            if (tmp != null) {
                sw.write("<field name=\"");
                sw.write(tmp);
                sw.write("\"    type=\"sequence\" primaryKey=\"true\"/>\n");
            } else {
                hasPrimaryKey = false;
            }
            tmp = AuditDSGenerator.getAuditTypeFieldName(ds);
            if (tmp != null) {
                sw.write("<field name=\"");
                sw.write(tmp);
                sw.write("\"    type=\"enum\">\n");
                sw.write("<valueMap>\n");
                sw.write("\t<value>add</value>");
                sw.write("\t<value>remove</value>");
                sw.write("\t<value>update</value>");
                sw.write("</valueMap>\n");
                sw.write("</field>\n");
            }
            if ((tmp = AuditDSGenerator.getAuditTimestampFieldName(ds)) != null) {
                sw.write("<field name=\"");
                sw.write(tmp);
                sw.write("\"    type=\"creatorTimestamp\" storeMilliseconds=\"true\" hidden=\"false\"/>\n");
            }
            if ((tmp = AuditDSGenerator.getAuditUserFieldName(ds)) != null) {
                sw.write("<field name=\"");
                sw.write(tmp);
                sw.write("\"    type=\"creator\" hidden=\"false\"/>\n");
            }
            if ((tmp = AuditDSGenerator.getAuditChangedFieldsFieldName(ds)) != null && !"hibernate".equals(ds.getType())) {
                sw.write("<field name=\"");
                sw.write(tmp);
                length = AuditDSGenerator.getAuditChangedFieldsFieldLength(ds);
                sw.write("\"    length=\"" + length);
                sw.write("\" type=\"text\" hidden=\"true\" multiple=\"true\" multipleStorage=\"simpleString\"/>\n");
            }
            fields = ds.getFieldNames();
            AuditDSGenerator.log.debug("Found " + fields.size() + " fields in the inherited datasource!");
            for (String name : fields) {
                needsChanges = false;
                f = new DSField((Map)ds.getField(name));
                if (f.containsKey("validators")) {
                    f.remove("validators");
                }
                if (f.containsKey("__cachedType")) {
                    f.remove("__cachedType");
                }
                if (f.containsKey("typeExplicitlyDeclared")) {
                    f.remove("typeExplicitlyDeclared");
                }
                if (f.isPrimaryKey() && !f.getName().equals(AuditDSGenerator.getAuditRevisionFieldName(ds))) {
                    if (hasPrimaryKey) {
                        AuditDSGenerator.log.debug("Setting primaryKey to false on field " + name);
                        f.put("primaryKey", false);
                        f.remove("autoGenerated");
                        needsChanges = true;
                        if ("sequence".equals(f.getType())) {
                            AuditDSGenerator.log.debug("Changing field " + name + " type from sequence to integer.");
                            f.put("type", "integer");
                        }
                    } else {
                        AuditDSGenerator.log.warn("Retaining primaryKey on field " + name + " as the Audit DataSource does not specify one!");
                    }
                }
                if (f.isRequired()) {
                    needsChanges = true;
                    f.put("required", false);
                }
                if (f.containsKey("audit") && ds.isAuditNeverField(name)) {
                    needsChanges = true;
                    f.put("inapplicable", true);
                }
                if (!needsChanges) continue;
                AuditDSGenerator.log.info("Field " + name + " has overriden attributes. Saving it to inheriting DataSource.");
                sw.write("<field ");
                for (K key : f.keySet()) {
                    if ("valueMap".equals(key)) continue;
                    val = f.get(key).toString();
                    sw.write(key.toString());
                    sw.write("=\"");
                    sw.write(val);
                    sw.write("\" ");
                }
                if (f.containsKey("valueMap")) {
                    sw.write(">\n");
                    sw.write("<valueMap>\n");
                    mapValues = f.get("valueMap").toString();
                    mapValues = mapValues.replace("[", "").replace("]", "");
                    for (String value : values = mapValues.split(",")) {
                        sw.write("<value>");
                        sw.write(value);
                        sw.write("</value>\n");
                    }
                    sw.write("</valueMap>\n");
                    sw.write("</field>\n");
                    continue;
                }
                sw.write(" />\n");
            }
            sw.write("</fields>\n");
            sw.write("</DataSource>");
            AuditDSGenerator.log.debug("Generating DataSource " + id + " from xml:");
            AuditDSGenerator.log.debug(sw.toString());
            ret = DataSource.fromXML(sw.toString());
            ret._isAutoGeneratedAuditDS = true;
            if (!AuditDSGenerator.ds2TableChecked.containsKey(id)) break block40;
            var11_14 = ret;
            DataSourceManager.free(ds);
            return var11_14;
        }
        try {
            bds = ds;
            if (ds.isAutoCreateAuditTableActive()) {
                AuditDSGenerator.log.debug("Audit table should be autocreated for DataSource " + ds.getID());
                if (ret.canQueryTable()) {
                    AuditDSGenerator.log.debug("Table for DataSource " + ds.getID() + " already exists, skipping autocreate step");
                    AuditDSGenerator.ds2TableChecked.put(id, id);
                } else {
                    try {
                        AuditDSGenerator.log.debug("Creating audit table for DataSource " + ds.getName());
                        ret.createStorage(false);
                        AuditDSGenerator.ds2TableChecked.put(id, id);
                        AuditDSGenerator.log.debug("Audit table successfully created for DataSource " + ds.getName());
                    }
                    catch (Exception e1) {
                        AuditDSGenerator.log.debug("Error creating audit table for DataSource " + ds.getName());
                    }
                }
            } else {
                AuditDSGenerator.log.debug("Audit table should not be automatically created for DataSource " + ds.getID());
            }
            {
                catch (Exception e) {
                    AuditDSGenerator.log.error("Couldn't create audit DataSource " + id + " for the DataSource '" + this.ds2audit.get(id) + " Problem was:\n" + DataTools.getStackTrace(e));
                }
            }
lbl179:
            // 6 sources

            var6_7 = ret;
        }
        catch (Exception e) {
            try {
                AuditDSGenerator.log.error("Couldn't create audit DataSource " + id + " for the DataSource '" + this.ds2audit.get(id) + " Problem was:\n" + DataTools.getStackTrace(e));
            }
            catch (Throwable var21_25) {
                DataSourceManager.free(ds);
                throw var21_25;
            }
            DataSourceManager.free(ds);
        }
        DataSourceManager.free(ds);
        return var6_7;
        return null;
    }

    public static String getAuditRevisionFieldName(DataSource ds) {
        return AuditDSGenerator.getSpecialAuditFieldName("auditRevisionFieldName", DEFAULT_REVISION_FIELD_NAME, ds);
    }

    public static String getAuditChangedFieldsFieldName(DataSource ds) {
        return AuditDSGenerator.getSpecialAuditFieldName("auditChangedFieldsFieldName", DEFAULT_DIFF_FIELD_NAME, ds);
    }

    public static Integer getAuditChangedFieldsFieldLength(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        Integer result = config.getInteger((Object)"audit.auditChangedFieldsFieldLength", 255);
        if (!Boolean.TRUE.equals(bds.getConfig().get("audit"))) {
            return result;
        }
        if (ds.getConfig().containsKey(DIFF_FIELD_LENGTH_PROPERTY)) {
            result = ((Number)ds.getConfig().get(DIFF_FIELD_LENGTH_PROPERTY)).intValue();
        }
        log.debug("getAuditChangedFieldsFieldLength() returns " + result);
        return result;
    }

    public static String getAuditTimestampFieldName(DataSource ds) {
        return AuditDSGenerator.getSpecialAuditFieldName("auditTimeStampFieldName", DEFAULT_TIMESTAMP_FIELD_NAME, ds);
    }

    public static String getAuditTypeFieldName(DataSource ds) {
        return AuditDSGenerator.getSpecialAuditFieldName("auditTypeFieldName", DEFAULT_TYPE_FIELD_NAME, ds);
    }

    public static String getAuditUserFieldName(DataSource ds) {
        return AuditDSGenerator.getSpecialAuditFieldName("auditUserFieldName", DEFAULT_USER_FIELD_NAME, ds);
    }

    static String getSpecialAuditFieldName(String configName, String defaultValue, DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (!Boolean.TRUE.equals(bds.getConfig().get("audit"))) {
            return null;
        }
        String result = defaultValue;
        if (ds.getConfig().containsKey(configName)) {
            result = (String)ds.getConfig().get(configName);
        }
        if (result.length() < 1) {
            return null;
        }
        log.debug("getSpecialAuditFieldName() for " + configName + " returns " + result);
        return result;
    }

    public static String getAuditSchemaName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (Boolean.TRUE.equals(bds.getConfig().get("audit"))) {
            String result = null;
            if (ds.getConfig().containsKey("auditSchema")) {
                result = (String)ds.getConfig().get("auditSchema");
            }
            return result;
        }
        return null;
    }

    public static String getAuditDSConstructor(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (Boolean.TRUE.equals(bds.getConfig().get("audit"))) {
            String result = null;
            if (ds.getConfig().containsKey("auditDSConstructor")) {
                result = (String)ds.getConfig().get("auditDSConstructor");
                if ("sql".equals(result)) {
                    result = "com.isomorphic.sql.SQLDataSource";
                }
                log.debug("Using " + result + " for auditDSConstructor.");
            }
            return result;
        }
        return null;
    }

    public void addMapping(String auditDSID, String dsID) {
        this.ds2audit.put(auditDSID, dsID);
        if (!auditedDses.contains(dsID)) {
            auditedDses.add(dsID);
        } else {
            log.warn(dsID + " is already on the list of datasoruces for which we generate audit DataSources!");
        }
    }

    public boolean hasMappingFor(String auditDSID) {
        return this.ds2audit.containsKey(auditDSID);
    }

    public String getMappingFor(String auditDSID) {
        if (this.ds2audit.containsKey(auditDSID)) {
            return (String)this.ds2audit.get(auditDSID);
        }
        return null;
    }
}

