/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.RESTDataSource;
import com.isomorphic.datasource.RequiresCompleteRESTResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.velocity.Velocity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ODataDataSource
extends RESTDataSource
implements RequiresCompleteRESTResponse {
    private static Logger log = new Logger(ODataDataSource.class);

    @Override
    public Map getRawFields() {
        HashMap<String, Object> work;
        HashMap fields = new HashMap(super.getRawFields());
        if (!fields.containsKey("$filter")) {
            work = new HashMap<String, Object>();
            work.put("name", "$filter");
            work.put("type", "text");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("$filter", work);
        }
        if (!fields.containsKey("$top")) {
            work = new HashMap();
            work.put("name", "$top");
            work.put("type", "integer");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("$top", work);
        }
        if (!fields.containsKey("$skip")) {
            work = new HashMap();
            work.put("name", "$skip");
            work.put("type", "integer");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("$skip", work);
        }
        if (!fields.containsKey("$orderby")) {
            work = new HashMap();
            work.put("name", "$orderby");
            work.put("type", "text");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("$orderby", work);
        }
        if (!fields.containsKey("$select")) {
            work = new HashMap();
            work.put("name", "$select");
            work.put("type", "text");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("$select", work);
        }
        if (!fields.containsKey("$count")) {
            work = new HashMap();
            work.put("name", "$count");
            work.put("type", "boolean");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("$count", work);
        }
        if (!fields.containsKey("@odata.count")) {
            work = new HashMap();
            work.put("name", "@odata.count");
            work.put("type", "integer");
            work.put("hidden", Boolean.TRUE);
            work.put("canEdit", Boolean.FALSE);
            fields.put("@odata.count", work);
        }
        return fields;
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        String outputs;
        DataTypeMap config = this.getServerConfig(req);
        if (ODataDataSource.isUpdate(req.getOperationType()) && config.getString("updateHttpMethod") == null) {
            config.put("updateHttpMethod", "PATCH");
        }
        if (config.getString("requestFormat") == null) {
            config.put("requestFormat", "params");
        }
        String query = this.buildODataQueryString(req, (Map)((Object)config));
        DataTypeMap<String, String> headers = config.getMap("headers");
        if (headers == null) {
            headers = new DataTypeMap<String, String>();
            config.put("headers", headers);
        }
        HashMap<String, Object> crit = new HashMap<String, Object>();
        if (query.trim().length() > 0) {
            crit.put("$filter", query);
        }
        crit.put("$skip", req.getStartRow());
        int pageSize = -1;
        if (req.getEndRow() > 0L) {
            crit.put("$top", req.getEndRow() - req.getStartRow());
            crit.put("$count", true);
            pageSize = (int)(req.getEndRow() - req.getStartRow());
            headers.put("Prefer", "odata.maxpagesize=" + pageSize + ",maxpagesize=" + pageSize);
        } else {
            Object configDefaultPageSize = config.get("defaultODataPageSize");
            if (configDefaultPageSize == null) {
                log.warn("Received a DSRequest with no endRow specified, and your <serverConfig> block does not define a defaultODataPageSize.  We will not send a maxpagesize Prefer header, so the server is free to set whatever default cap it likes, and you may get back fewer records than you expected.");
            } else {
                pageSize = Integer.parseInt(configDefaultPageSize.toString());
                headers.put("Prefer", "odata.maxpagesize=" + pageSize + ",maxpagesize=" + pageSize);
            }
        }
        String orderBy = this.buildODataOrderByString(req, (Map)((Object)config));
        if (orderBy.trim().length() > 0) {
            crit.put("$orderby", orderBy);
        }
        if ((outputs = this.buildODataSelectString(req, config)).trim().length() > 0) {
            crit.put("$select", outputs);
        }
        crit.put("$count", "true");
        log.debug("This criteria will become the URL params into the OData REST call: " + crit);
        req.setCriteria(crit);
        DSResponse dsResp = super.executeFetch(req);
        Map completeData = (Map)dsResp.getProperty("completeData");
        if (req.getEndRow() > 0L) {
            dsResp.setTotalRows((Long)completeData.get("@odata.count"));
        } else {
            dsResp.setTotalRows(dsResp.getDataList().size());
        }
        dsResp.setStartRow(req.getStartRow());
        dsResp.setEndRow(req.getStartRow() + (long)dsResp.getDataList().size());
        return dsResp;
    }

    public String buildODataQueryString(DSRequest req, Map config) {
        String customFilter;
        Map crit = req.getCriteria();
        String tms = req.getTextMatchStyle();
        String filter = "";
        for (String key : crit.keySet()) {
            Object value;
            String strValue;
            if (key.startsWith("_")) continue;
            DSField field = this.getField(key);
            if (field == null) {
                log.warn("Criteria contained unknown field '" + key + "'.  Ignoring this field");
                continue;
            }
            if (Boolean.FALSE.equals(field.get("canFilter"))) {
                log.warn("Criteria contained field '" + key + "', which is marked canFilter:false.  Ignoring this field");
                continue;
            }
            String filterName = key;
            if (field.getValueXPath() != null) {
                filterName = field.getValueXPath();
            }
            if (field.getNativeName() != null) {
                filterName = field.getNativeName();
            }
            if (filter.length() > 0) {
                filter = filter + " and ";
            }
            String string = strValue = (value = crit.get(key)) == null ? "" : value.toString();
            if (value instanceof String) {
                strValue = "'" + strValue + "'";
            }
            if ("startsWith".equals(tms) && !field.shouldIgnoreTextMatchStyle().booleanValue()) {
                filter = filter + "startswith(" + filterName + ", " + strValue + ")";
                continue;
            }
            if ("substring".equals(tms) && !field.shouldIgnoreTextMatchStyle().booleanValue()) {
                filter = filter + "contains(" + filterName + ", " + strValue + ")";
                continue;
            }
            filter = filter + filterName + " eq " + strValue;
        }
        DataTypeMap opBinding = this.getOperationBinding(req);
        String string = customFilter = opBinding == null ? null : (String)opBinding.get("customFilter");
        if (customFilter != null) {
            Map<Object, Object> params = Velocity.getStandardContextMap(req);
            params.put("$defaultFilter", filter);
            try {
                customFilter = (String)Velocity.evaluate(customFilter, params);
            }
            catch (Exception e) {
                log.warn((Object)("Caught exception evaluating customFilter text for ODataDataSource " + this.getName()), e);
            }
        }
        return filter;
    }

    public String buildODataOrderByString(DSRequest req, Map config) {
        List fields = req.getSortByFields();
        String orderBy = "";
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                orderBy = orderBy + ", ";
            }
            String field = (String)fields.get(i);
            boolean desc = false;
            if (field.charAt(0) == '-') {
                field = field.substring(1);
                desc = true;
            }
            orderBy = orderBy + field + (desc ? " desc" : " asc");
        }
        return orderBy;
    }

    public String buildODataSelectString(DSRequest req, DataTypeMap config) {
        List<String> fieldNames = req.getOutputs();
        if (fieldNames == null && this.dropExtraFields()) {
            fieldNames = this.getFieldNames();
        }
        HashSet<String> outputs = new HashSet<String>();
        if (fieldNames == null) {
            return "";
        }
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = fieldNames.get(i);
            if (fieldName.startsWith("$") || fieldName.startsWith("@")) continue;
            DSField field = this.getField(fieldName);
            if (field != null) {
                String valueXPath;
                String nativeName = field.getNativeName();
                if (nativeName != null && nativeName.trim().length() > 0) {
                    fieldName = nativeName;
                }
                if ((valueXPath = field.getValueXPath()) != null && valueXPath.trim().length() > 0) {
                    int slash = valueXPath.indexOf(47);
                    fieldName = valueXPath.substring(0, slash);
                }
            }
            outputs.add(fieldName);
        }
        String selectString = "";
        Iterator i = outputs.iterator();
        while (i.hasNext()) {
            selectString = selectString + (String)i.next();
            if (!i.hasNext()) continue;
            selectString = selectString + ",";
        }
        return selectString;
    }
}

